/** collaboration.h is part of JamMo.
License: GPLv2, read more from COPYING
*/
#ifndef _COLLABORATION_H_
#define _COLLABORATION_H_


#include <gst/gst.h>

typedef struct {
	int id;
	char *name;
	char *address;
	int port;
} User;
typedef struct {
	User current;
	User *next;
} UserList;

typedef struct {
	int users[4];	
} Game;

void collaboration_add_new_sample_to_track(int track_number, const gchar srcLocation[], guint64 startTime);
void collaboration_add_new_sample_to_track_nth_slot(int track_number, const gchar srcLocation[], guint slot);
void collaboration_remove_sample_from_slot(guint track_number,int slot);
void collaboration_start_pair_game();
int collaboration_create_game_server(int port);//For testing
int collaboration_create_game_client(char *address, int port);//For testing
int collaboration_create_game();//The function to be used in final product
void collaboration_handle_message(char* message,int length, int id);
int collaboration_send_to_current_group(char* message,int length);
int decode_add_new_sample_to_track(char* message,int length);
int decode_add_new_sample_to_track_nth_slot(char* message,int length);
int decode_remove_sample_from_slot(char* message,int length);
int decode_user_info_request(char* message,int length, int id);
int decode_user_info_response(char* message,int length, int id);

#endif  /* _COLLABORATION_H_ */

