/*
 * jammo_singinggame.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu
 *
 * Authors: Aapo Rantalainen
 */

#include <tangle.h>
#include <clutter/clutter.h>
#include <fcntl.h> //we check some files

#include "../chum/chum.h"
#include "../chum/gui.h" /*For SCREEN_*-macros */
#include "mentor.h"

#include "../meam/jammo-recording-track.h"

extern JammoRecordingTrack* recording_track;

ClutterActor *contour_cursor;
ClutterActor *contour_trace;
ClutterActor *singinggame_display_freq;


/*
This will be more fancier some day.
*/
#define radius  5.0
static void draw_trace(int x, int y) {
	//offset: it looks like contour_star (png at this moment) is drawing line
	cogl_path_ellipse (x+5, y+15, radius, radius);
	cogl_path_stroke();
}

static void update_trace(ClutterActor *data,int x,int y){
		//printf("update_texture called\n");
		CoglHandle handle;
		CoglHandle offscreen;

		if ((handle = clutter_texture_get_cogl_texture(CLUTTER_TEXTURE(data))) == COGL_INVALID_HANDLE) 
		{
					handle = cogl_texture_new_with_size(800, 480, COGL_TEXTURE_NO_SLICING, COGL_PIXEL_FORMAT_RGBA_8888_PRE);
					g_assert(handle != COGL_INVALID_HANDLE);
					clutter_texture_set_cogl_texture(CLUTTER_TEXTURE(data), handle);
		}

		cogl_push_draw_buffer();
		offscreen = cogl_offscreen_new_to_texture(handle);
		g_assert(offscreen != COGL_INVALID_HANDLE);
		cogl_set_draw_buffer(COGL_OFFSCREEN_BUFFER, offscreen);

		cogl_set_source_color4f(1.0, 1.0, 0.1, 1.0);

		draw_trace(x,y);
		cogl_pop_draw_buffer();	
		cogl_offscreen_unref(offscreen);

		clutter_actor_queue_redraw(CLUTTER_ACTOR(data));
}


#define LEFT_MARGINAL 10      /*Marginal from left border.*/
int contour_counter=LEFT_MARGINAL; /* This counts how many times cursor is moved*/
/*
FIXME we should handle x-axis with duration + current place of playback track.
Now we just keep count how many signals are cathed.
*/
static void on_pitch_detected(JammoRecordingTrack* track, gfloat frequency, gpointer user_data) {
		if (contour_cursor==NULL)  //error case
		{
			printf("contour_star==NULL \n");
			return;
		}
		if (contour_trace==NULL)  //error case
		{
			printf("contour_trace==NULL \n");
			return;
		}

		contour_counter+=1;
		//int Y=(contour_counter-400)*(contour_counter-400)*0.001+100; //This is good for demo 
		int Y=840-(frequency*2); //frequence [220,480] -> place [480,0] //origo is on upper left corner

		//if (contour_counter%10==0) //If it takes too much effort to draw it in each round.
		update_trace(contour_trace,contour_counter,Y);
		clutter_actor_set_position(contour_cursor,contour_counter,Y);

		
		if (frequency==-1.0) /*This means, we do not have good value*/
			clutter_text_set_text (CLUTTER_TEXT(singinggame_display_freq),"[ ∞ ]");
		else
			{
			gchar* buffer0;
			buffer0 = g_strdup_printf("[%3.1lf]",frequency);
			clutter_text_set_text (CLUTTER_TEXT(singinggame_display_freq),buffer0);
			g_free(buffer0);
			}
		
}







gboolean singingame_start_sequencer(){
chum_play_sequencer();
return FALSE;
}


gchar* GLOBAL_CHAR;
ClutterActor* GLOBAL_ACTOR;
static void song_view_showed(TangleAction* action, GObject* source, const gchar* trigger, TangleProperties* properties){
	printf("song_view_showed\n");
	gchar *filepath1;
	filepath1 =  g_strdup_printf("mentor_speech/mentor_song_%s_fi.ogg", chum_get_current_song());
	
	printf("pass to mentor: '%s' \n",filepath1);
	ClutterActor* new_parent= GLOBAL_ACTOR;
	ClutterActor *temp_bear=mentor_give_temp_bear();
	clutter_container_add_actor (CLUTTER_CONTAINER (new_parent), temp_bear);
	mentor_speech(temp_bear,filepath1);
}


/*
trigger="clicked"
Source= TangleButton.
*/
void singinggame_song_click(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	ClutterActor* ct =CLUTTER_ACTOR(source);
	const gchar* name = clutter_actor_get_name(ct);
	printf("Song clicked. get_name: '%s'\n",name);

	chum_change_to_song(name);
	gchar* selected_language=chum_get_selected_language();


	gchar* name_of_view;
	name_of_view = g_strdup_printf("song-%s-view", name );
	ClutterActor* view = jammo_get_actor_by_id(name_of_view);
	g_free(name_of_view);
	
	
	gchar *filepath1;
	GLOBAL_ACTOR=view; //FIXME. view is not passed with g_signal_connect
	g_signal_connect(view, "transition-completed", G_CALLBACK(song_view_showed), NULL);
	
	
	//This 7sec is just guess! FIXME. use mentor-completed-signal TODO
	g_timeout_add (7000,singingame_start_sequencer,NULL);
	
	//Do not use pitch_detect on OFFICIAL_RELEASE (not robust enough)
	#ifndef OFFICIAL_RELEASE
	//contour_cursor = moving thing
	contour_cursor = clutter_texture_new();
	filepath1 = g_strdup_printf("%s/songs/%s/cursor%s.png", DATA_DIR, name, selected_language );
	int fd = open(filepath1,O_RDONLY);
	if (fd == -1) //File not found
		{
		filepath1 = g_strdup_printf("%s/songs/%s/cursor.png", DATA_DIR,name ); //try without language postfix
		int fd = open(filepath1,O_RDONLY);
		if (fd == -1) //File not found
			{
			printf("file '%s' not found, using default cursor\n",filepath1);
			//contour_cursor = config_get_configured_actor(NULL,"contour_star");
			}
		else
			clutter_texture_set_from_file (CLUTTER_TEXTURE (contour_cursor), filepath1, NULL);
		}
	else
		clutter_texture_set_from_file (CLUTTER_TEXTURE (contour_cursor), filepath1, NULL);

	clutter_container_add_actor (CLUTTER_CONTAINER (view), contour_cursor);



	//contour_trace
	contour_trace = g_object_new (CLUTTER_TYPE_TEXTURE, "disable-slicing", TRUE, NULL);

	CoglHandle new_texture;
	CoglTextureFlags flags = COGL_TEXTURE_NO_SLICING; //NO_SLICING is important.
	new_texture = cogl_texture_new_with_size (WIDTH_OF_WINDOW,HEIGHT_OF_WINDOW,
                                              flags,
                                              COGL_PIXEL_FORMAT_RGBA_8888_PRE);

	clutter_texture_set_cogl_texture (CLUTTER_TEXTURE(contour_trace), new_texture);
	cogl_handle_unref (new_texture);

 clutter_container_add_actor (CLUTTER_CONTAINER (view), contour_trace);

 
  //And for debugging, text-field
	singinggame_display_freq=  clutter_text_new_with_text ("Liberty","START"); //start with empty text
	clutter_text_set_font_name(CLUTTER_TEXT(singinggame_display_freq),"Luxi Mono 18");
	clutter_container_add_actor (CLUTTER_CONTAINER (view), singinggame_display_freq);
	clutter_actor_set_position (singinggame_display_freq, 100, 30); 
	clutter_actor_show (singinggame_display_freq);


	//recording_track is from chum.c. on_pitch_detected uses only globals
	g_signal_connect(recording_track, "pitch-detected", G_CALLBACK(on_pitch_detected), NULL);
	
	//End of melodic contour
	#endif /*OFFICIAL_RELEASE */
	
	g_free(filepath1);

}

#ifdef old
gboolean back_to_songselection = FALSE;
static void back_to_songselection_completed(TangleAction* action, GObject* source, const gchar* trigger, TangleProperties* properties) {
	if (!( back_to_songselection)){

		//Parent will be same than buttons (just clicked) parent.
		ClutterActor* new_parent = clutter_actor_get_parent(CLUTTER_ACTOR(source));
		if (new_parent==NULL) printf("new_parent is NULL\n");
		else printf("new_parent not NULL\n");

		ClutterActor *temp_bear=mentor_give_temp_bear();
		clutter_container_add_actor (CLUTTER_CONTAINER (new_parent), temp_bear);

		mentor_speech(temp_bear,"mentor_speech/mentor_28_fi.ogg"); //Good job.
		back_to_songselection=TRUE;
	}
}
#endif

static void singinggame_singing_over_mentor(){
	ClutterActor* new_parent= GLOBAL_ACTOR;
	ClutterActor *temp_bear=mentor_give_temp_bear();
	clutter_container_add_actor (CLUTTER_CONTAINER (new_parent), temp_bear);
	mentor_speech(temp_bear,GLOBAL_CHAR);
}


void singinggame_cross_click(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	ClutterActor* actor =CLUTTER_ACTOR(source);

	const gchar* id_of_actor;
	id_of_actor = clutter_get_script_id(source);
			
	printf("cross_clicked. get_id: '%s' and parent '%s'\n",id_of_actor,clutter_get_script_id(G_OBJECT(clutter_actor_get_parent(CLUTTER_ACTOR(source)))));


	if (chum_get_state_of_chum()==SCREEN_SONG_RECORDING)
		{
		printf("chum_get_state_of_chum()==SCREEN_SONG_RECORDING\n");

		#ifndef OFFICIAL_RELEASE
		clutter_actor_hide(contour_cursor);
		clutter_actor_hide(contour_trace);
		clutter_actor_hide(singinggame_display_freq);
		contour_counter=LEFT_MARGINAL;
		#endif
		
		GLOBAL_ACTOR=clutter_actor_get_parent(CLUTTER_ACTOR(source));
		GLOBAL_CHAR="mentor_speech/mentor_28_fi.ogg";
		singinggame_singing_over_mentor();

		chum_play_recorded_and_backing_track();
		
		//This 2sec is just guess! FIXME. use mentor-completed-signal TODO
		g_timeout_add (2000,singingame_start_sequencer,NULL);
		
		}

	else if (chum_get_state_of_chum()==SCREEN_PLAY_RECORDED	)
		{
		printf("chum_get_state_of_chum()==SCREEN_PLAY_RECORDED");
		chum_stop_sequencer();

		//'actor' is pressed button, and it's parent is song-*-view
		//Hide it
		ClutterActor* parent = clutter_actor_get_parent(CLUTTER_ACTOR(actor));
		clutter_actor_hide(parent);

		//And go back to songselection
		ClutterActor* view = jammo_get_actor_by_id("songselection-view");
		clutter_actor_show(view);

		//Automatic saving on N900. THIS MUST BE DOCUMENTED.
		//filenames look like this: jammo_2010.02.22_21.16.27.wav
		#ifdef N900
		gchar* cmd;
		cmd = g_strdup_printf("cp %s /home/user/MyDocs/jammo_`date +%%Y.%%m.%%d_%%H.%%M.%%S`.wav", RECORDING_FILENAME );

		int error_code = system(cmd);
		if (error_code)
			printf("Error, can't call '%s'\n",cmd);
		#endif
		}

	else printf("Singinggame_cross_click: Error\n");

}

