/**instrument_mode_joystick.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is used on terminal and clutter guis.
It reads joystick port (you need joystick driver loaded in kernel).
*/

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <linux/joystick.h>

#include "../chum/chum.h"
#include "instrument_mode_joystick.h"

/*joystick events:
struct js_event {
	__u32 time;	// event timestamp in milliseconds 
	__s16 value;	// value 
	__u8 type;	// event type 
	__u8 number;	// axis/button number 
};
*/


#ifdef N810
//In n810, js0 is pointing touchscreen by default.
#define JOY_DEV "/dev/input/js1"
#else
#define JOY_DEV "/dev/input/js0"
#endif


static int handle( int code) {
char note=' ';
//printf("joy :%d\n",code);
switch (code){
    //these are buttons (10button joystic)
    case 0: note='c';break;
    case 1: note='1';break;
    case 2: note='d';break;
    case 3: note='2';break;
    case 4: note='e';break;
    case 5: note='f';break;
    case 6: note='3';break;
    case 7: note='g';break;
    case 8: note='4';break;
    case 9 :note='a';break;
    //these are right,left,down,up
    case 10: note='5';break; //right
    case 11: note='b';break; //left
    case 12: chum_octave_down(); return 1;
    case 13: chum_octave_up(); return 1;

/* // If we have more buttons, we can do quitting with it.
    case 14:
      printf("Leaving Virtual instrument mode\n");
      return 0;
*/
    default: return 1;
}
chum_state_of_note(1, note);

//this can be used with flute, but there should be some smarter way
//chum_toggle_note(note);
return 1;
}


/*Reading-loop can be stopped from outside.
Or some button can be assigned to quit.*/
int cont;
void stop_virtual_instrument_mode_joystick (){
cont=0;
}

void virtual_instrument_mode_joystick () {
	int joy_fd, *axis=NULL, num_of_axis=0, num_of_buttons=0;
	char *button=NULL, name_of_joystick[80];
	struct js_event js;

	if( ( joy_fd = open( JOY_DEV , O_RDONLY)) == -1 )
	{
		//printf( "Couldn't open joystick\n" );
		return;
	}
        printf( "Joystick found!\n" );

	ioctl( joy_fd, JSIOCGAXES, &num_of_axis );
	ioctl( joy_fd, JSIOCGBUTTONS, &num_of_buttons );
	ioctl( joy_fd, JSIOCGNAME(80), &name_of_joystick );

	axis = (int *) calloc( num_of_axis, sizeof( int ) );
	button = (char *) calloc( num_of_buttons, sizeof( char ) );

	printf("Joystick detected: %s\n\t%d axis\n\t%d buttons\n\n"
		, name_of_joystick
		, num_of_axis
		, num_of_buttons );

	fcntl( joy_fd, F_SETFL, O_NONBLOCK );	/* use non-blocking mode */

	//this 14 should be num_of_buttons+4 (4=left+rigth+up+down)
	int last_accessed[14];
	int i;
	for (i=0;i<14;i++){
	  last_accessed[i]=0;
	}

	cont=1;
	while( cont )
	{
		/* read the joystick state */
		if (!(read(joy_fd, &js, sizeof(struct js_event))))
		  printf("error\n");
		int note=0;

		switch (js.type & ~JS_EVENT_INIT)
		{
			case JS_EVENT_AXIS:
				//printf("jsnumber %d.  jsvalue %d\n",js.number,js.value);
				axis   [ js.number ] = js.value;
				if (js.value>0 && js.number==0)
				  note=10;
				if (js.value<0 && js.number==0)
				  note=11;
				if (js.value>0 && js.number==1)
				  note=12;
				if (js.value<0 && js.number==1)
				  note=13;
				break;
			case JS_EVENT_BUTTON:
				button [ js.number ] = js.value;
				if (js.value){
				  note=js.number;
				}
				break;
		}

		if (js.value)
		{
		  //printf("previous: %d, current ms =%d \n",last_accessed[js.number],js.time);
		  if (last_accessed[note]+10 < js.time)
		  {
		      last_accessed[note]= js.time;
		      if (!handle(note))
		      cont=0;
		  }
		}
	}

	close( joy_fd );
}
