#include "../meam/jammo-sample.h"
#include "../chum/chum.h"  //DATA_DIR
#include <tangle.h>
#include <clutter/clutter.h>
#include "string.h"

gboolean mentor_is_talking = FALSE;


static gboolean mentor_speech_over2(gpointer data){
ClutterActor* mentor = CLUTTER_ACTOR(data);
//FIXME. This should be remove!
clutter_actor_hide(mentor);
return FALSE;
}

/*
It is possible, that both signal and user call this in very same time
and both pass the first 'if'.
  -> this is not critical.

*/
static void mentor_speech_over(JammoSample* sample, gpointer data){
	ClutterActor* mentor = CLUTTER_ACTOR(data);
	if (!(mentor_is_talking))
		return;
	printf("switching mentor_is_talking FALSE\n");
	mentor_is_talking = FALSE;

	//Animated shrinking.
	ClutterAnimation* animation;
	animation = clutter_actor_animate(mentor, CLUTTER_EASE_OUT_QUAD, 1500, "width", 78.0,  "height", 120.0, NULL);

	//And lastly hide it.
	g_timeout_add (1500,mentor_speech_over2,mentor);
}



/*
Give actor (mentor) for popping and shrinking.
It should be visible and in current view. This will hide it.

Give filename for audio sample. DATA_DIR is added.
*/
gboolean mentor_speech(ClutterActor *mentor, gpointer data) {
	gchar* filename;
	JammoSample* sample;

	//First stop all other mentor speaking.
	jammo_sample_stop_all(); 
	mentor_is_talking = TRUE;

	filename = g_strdup_printf("%s/%s",DATA_DIR,(char*)data);
	printf("Play: %s\n", filename);
	sample = jammo_sample_new_from_file(filename);
	g_free(filename);
	g_signal_connect(sample, "stopped", G_CALLBACK(mentor_speech_over), mentor);
	jammo_sample_play(sample);
	g_object_unref(sample);

	ClutterAnimation* animation;
	animation = clutter_actor_animate(mentor, CLUTTER_EASE_IN_QUAD, 1500, "width", 309.0,  "height", 480.0, NULL);

	return FALSE;
}


ClutterActor* mentor_give_temp_bear(){
	ClutterActor *temp_bear = clutter_texture_new_from_file ("/opt/jammo/mentor.png", NULL);
	clutter_actor_set_size(temp_bear,78.0,120.0);
	//clutter_actor_raise_top(temp_bear);
	clutter_actor_set_reactive(temp_bear, TRUE);
	g_signal_connect (temp_bear, "button-press-event", G_CALLBACK (jammo_sample_stop_all),NULL);
	return temp_bear;
}



void mentor_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	if (mentor_is_talking)
		{
		printf("mentor was talking, silence it.\n");
		jammo_sample_stop_all();   //This will trigger mentor_speech_over(NULL);
		return;
		}

		//Parent will be same than buttons (just clicked) parent.
		ClutterActor* new_parent = clutter_actor_get_parent(CLUTTER_ACTOR(source));
		if (new_parent==NULL) printf("new_parent is NULL\n");
		else printf("new_parent not NULL\n");

		ClutterActor *temp_bear=mentor_give_temp_bear();
		clutter_container_add_actor (CLUTTER_CONTAINER (new_parent), temp_bear);
		
		
		//We need this.
	ClutterActor* mentor = CLUTTER_ACTOR(source);

	const gchar* id_of_actor;
  id_of_actor = clutter_get_script_id(G_OBJECT(mentor));
	printf("mentor. get_name: '%s'\n",id_of_actor);
	//gchar* filename;
	 //we have mentor in two places.
	if (strcmp(id_of_actor,"main-menu-mentor")==0)
		{
		mentor_speech(temp_bear,"mentor_speech/mentor_02_fi.ogg");
		}
	if (strcmp(id_of_actor,"songselection-mentor")==0)
		{
		mentor_speech(temp_bear,"mentor_speech/mentor_22_fi.ogg");
		}

}
