/*
 * jammo.c (=> main.c)
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu
 *
 * Authors: Henrik Hedberg <henrik.hedberg@oulu.fi>
 */

#include "jammo-chum.h"
#include "../meam/jammo-meam.h"
#include <tangle.h>
#include <clutter/clutter.h>
#include <stdlib.h> 

#include "chum.h" //e.g. DATA_DIR
#include <fcntl.h> //we check some files
#include "mentor.h"

#include <pthread.h> 

static const char* search_path = "/opt/jammo";

/*
 * Note! You need Tangle Toolkit that is available here:
 *
 * http://gitorious.org/tangle
 *
 * To compile:
 * gcc -rdynamic -o jammo jammo.c jammo-*.c $(pkg-config --cflags --libs clutter-1.0 tangle gstreamer-0.10 gstreamer-base-0.10 gstreamer-controller-0.10) ../meam/libmeam.a
 *
 * Note that -rdynamic is important in order to dynamic signal handler binding to work!
 */

static ClutterScript* script;

ClutterActor* jammo_get_actor_by_id(const char* id) {
	ClutterActor* actor = NULL;

	if (!(actor = CLUTTER_ACTOR(clutter_script_get_object(script, id)))) {
		g_warning("Actor '%s' not found.", id);
	}
	
	return actor;
}





//Disable automatic screen dimming
#ifdef N900
#include <libosso.h>

void maemo_heartbeat()
{
	osso_context_t *ossocontext = NULL;
	
	ossocontext = osso_initialize("jammo", "git", 0, NULL);
	if (ossocontext==NULL)
		{
		printf("error initialization of ossocontext\n");
		}
		
	osso_display_state_on(ossocontext);     //if dimmed, this will light it again
	osso_display_blanking_pause(ossocontext);

	osso_return_t ret;
	while(TRUE)
		{
		g_usleep( 55 * G_USEC_PER_SEC );
		ret = osso_display_blanking_pause(ossocontext);
		if (ret==OSSO_OK) printf ("OSSO_OK\n");
		else if (ret==OSSO_ERROR) printf ("OSSO_ERROR\n");
		else if (ret==OSSO_INVALID) printf ("OSSO_INVALID\n");
		else printf("Unknow return\n");
		}
}
#endif

int main(int argc, char** argv) {
	TangleStylesheet* stylesheet;
	ClutterActor* stage;
	GError* error = NULL;
	GObject* object;
	ClutterActor* actor;
	
	jammo_meam_init(&argc, &argv);
	jammo_chum_init(&argc, &argv);

	if ((stylesheet = tangle_stylesheet_new_from_file("jammo"))) {
		tangle_stylesheet_set_default(stylesheet);
	}

	script = clutter_script_new();
	clutter_script_add_search_paths(script, &search_path, 1);
	if (!clutter_script_load_from_file(script, "test.json", &error)) {
		g_warning("Could not load file 'test.json': %s", error->message);

		return 1;
	}
	
	if (!(object = clutter_script_get_object(script, "main"))) {
		g_warning("Object 'main' not found from the file 'test.json'.");
		
		return 2;
	}
	
	if (!CLUTTER_IS_ACTOR(object)) {
		g_warning("Object 'main' is not ClutterActor in the file 'test.json'.");
		
		return 3;
	}
	
	actor = CLUTTER_ACTOR(object);
	
	stage = clutter_stage_get_default();

#ifdef N900
	clutter_stage_set_fullscreen(CLUTTER_STAGE(stage), TRUE);
	
	pthread_t preloader_thread;
	pthread_create(&preloader_thread, NULL, maemo_heartbeat, NULL);
#else
	clutter_actor_set_size(stage, 800, 480);
#endif

	clutter_container_add_actor(CLUTTER_CONTAINER(stage), actor);
	
	clutter_actor_show(stage);
	
	clutter_main();

	return 0;
}

void jammo_quit_confirmed(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	exit(0);
}


#include "string.h"
void singinggame_duetto_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	ClutterActor* ct =CLUTTER_ACTOR(source);
	const gchar* name = clutter_actor_get_name(ct);
	printf("duetto clicked. get_name: '%s'\n",name);
	
	if (strcmp(name,"duetto")==0)
			chum_set_duetto(TRUE);
	else
			chum_set_duetto(FALSE); //This could also hide language selection
	
	ClutterActor* button;
	ClutterActor* texture;
	gchar *new_name = g_strdup_printf("songselection-%s-icon-texture",name);
	 
	button = jammo_get_actor_by_id("songselection-duetto");
	texture = jammo_get_actor_by_id(new_name);
	tangle_button_set_normal_background_actor(TANGLE_BUTTON(button), texture);
}
	
	gboolean first_time_in_songselection = TRUE;

static void entering_first_time_to_songselection(TangleAction* action, GObject* source, const gchar* trigger, TangleProperties* properties) {
	if (first_time_in_songselection){
		ClutterActor* new_parent =  jammo_get_actor_by_id("songselection-view");
		if (new_parent==NULL) printf("new_parent is NULL\n");
		else printf("new_parent not NULL\n");
		
		ClutterActor *temp_bear=mentor_give_temp_bear();
		clutter_container_add_actor (CLUTTER_CONTAINER (new_parent), temp_bear);

		mentor_speech(temp_bear,"mentor_speech/mentor_06_fi.ogg");
	
	first_time_in_songselection = FALSE;
	}
}

	
ClutterColor white_color = { 0, 0, 0, 0xbb };
ClutterColor *get_white_color(){        return &white_color; }

void jammo_going_to_songselection(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
		ClutterActor* view;
		if ((view = jammo_get_actor_by_id("songselection-view"))) {
			g_object_set(view, "transition-duration", 1500, "transition-mode", 2, NULL);
			clutter_actor_show(view);
		}
	if (first_time_in_songselection)
		{
		//Mentor's speech.
		g_signal_connect(view, "transition-completed", G_CALLBACK(entering_first_time_to_songselection), NULL);
		}


	//Add transperency mask to songs which do not have current language vocal-track.
	///////////////////////////////////////////////////////////////////////////////
	char* selected_language = chum_get_selected_language();
	gfloat x,y,w,h;
	ClutterActor* box;
	GList* songlist = clutter_container_get_children(CLUTTER_CONTAINER(view));
	GList *l;

	//First: Remove all existing mask-boxes. FIXME: now it only hides them!
	for (l = songlist; l; l = l->next){
		const gchar* name;
		g_object_get(l->data, "name", &name, NULL);
		if (name!=NULL && strncmp(name,"box",3)==0)
			{
			//clutter_actor_hide(l->data);
			//clutter_container_remove_actor(CLUTTER_CONTAINER(view), CLUTTER_ACTOR(l->data));
			clutter_container_remove_actor(CLUTTER_CONTAINER(view), CLUTTER_ACTOR(l->data));
			}
	}
	g_list_free(songlist);

	//Second: add new boxes
	songlist = clutter_container_get_children(CLUTTER_CONTAINER(view));
	for (l = songlist; l; l = l->next){
		const gchar* id_of_actor;
		id_of_actor = clutter_get_script_id(G_OBJECT(l->data));
		if (id_of_actor==NULL) continue; //In child-list there are many id=NULL actors.
			
		if (strncmp(id_of_actor,"songselection-song-",19)==0)
			{
			const gchar* name;
			g_object_get(l->data, "name", &name, NULL);
		  //printf("name: '%s'\n",name);
			
			gchar* filename;
			filename = g_strdup_printf("%s/songs/%s/vocal%s.ogg",DATA_DIR,name,selected_language);
			//printf("filename: '%s'\n",filename);
			int fd = open(filename,O_RDONLY);
			if (fd == -1) //File not found => now vocal_track for this language
				{
				g_object_get(l->data, "x", &x, "y", &y, "width", &w, "height", &h, NULL);
				//printf("child: %s, %lf: %lf: %lf: %lf\n",id_of_actor,x,y,w,h);
				box=clutter_rectangle_new_with_color (get_white_color());
				clutter_actor_set_size (box, w,h);
				clutter_actor_set_position (box, x, y); 
				clutter_actor_show (box);
				clutter_actor_set_name (box, "box"); //this is used to remove this b
				clutter_container_add_actor (CLUTTER_CONTAINER (view), box);
				}
			}
	}
	
	g_list_free(songlist);
}

void singinggame_language_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	ClutterActor* ct =CLUTTER_ACTOR(source);
	const gchar* name = clutter_actor_get_name(ct);
	printf("Lan clicked. get_name: '%s'\n",name);

	chum_set_selected_language(name);

	ClutterActor* button;
	ClutterActor* texture;
	gchar *new_name = g_strdup_printf("songselection-language-%s-texture", name);
 
	button = jammo_get_actor_by_id("songselection-language");
	texture = jammo_get_actor_by_id(new_name);
	tangle_button_set_normal_background_actor(TANGLE_BUTTON(button), texture);


	ClutterActor* view;
	if ((view = jammo_get_actor_by_id("language-selection-view"))) {
		g_object_set(view, "transition-duration", 1500, "transition-mode", 2, NULL);
		clutter_actor_hide(view);
	}

	jammo_going_to_songselection(action,source,trigger,properties);
}







gboolean first_time_ask_quitting = TRUE;
void jammo_ask_quitting2(){
	if (first_time_ask_quitting){
		ClutterActor* new_parent;
		new_parent = jammo_get_actor_by_id("quitconfirmation-view");
		ClutterActor *temp_bear=mentor_give_temp_bear();
		clutter_container_add_actor (CLUTTER_CONTAINER (new_parent), temp_bear);
		mentor_speech(temp_bear,"mentor_speech/mentor_quit_confirmation_fi.ogg");
		first_time_ask_quitting=FALSE;
	}
	
}

void jammo_ask_quitting(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	ClutterActor* new_parent;
	new_parent = jammo_get_actor_by_id("quitconfirmation-view");

	g_signal_connect(new_parent, "transition-completed", G_CALLBACK(jammo_ask_quitting2), NULL);	
}

