#include "collaboration.h"
#include "communication.h"
#include "messages.h"
#include <stdlib.h>
#include <string.h>
#include "../chum/chum.h"

int groupwork=0;//0=stand-alone, other=number of users in game
int classroom=0;//0=not connected to teacher, 1=is connected to teacher
Game currentgame;
UserList users;


void collaboration_add_new_sample_to_track(int track_number, const gchar srcLocation[], guint64 startTime)
{
	char *message;
	char location;
	short messageid;
	
	if (groupwork)
	{
		location=0;
		
		//send message to pair/group members
		message=(char *)malloc(sizeof(short)+sizeof(int)+g_utf8_strlen(srcLocation,-1)+1+sizeof(guint64));
		messageid=ADD_NEW_SAMPLE_TO_TRACK;
		memcpy(message+location,&messageid,sizeof(short));
		location=location+sizeof(short);
		memcpy(message+location,&track_number,sizeof(int));
		location=location+sizeof(int);
		memcpy(message+location,srcLocation,g_utf8_strlen(srcLocation,-1)+1);
		location=location+g_utf8_strlen(srcLocation,-1)+1;
		memcpy(message+location,&startTime,sizeof(guint64));
		location=location+sizeof(guint64);

		//printf("\nConstructed message: %s, %d, %s",srcLocation,g_utf8_strlen(srcLocation,-1),message+sizeof(short)+sizeof(int));
		//communication_send_data(1, message,location);
		collaboration_send_to_current_group(message,location);
		free(message);
	}
}
void collaboration_add_new_sample_to_track_nth_slot(int track_number, const gchar srcLocation[], guint slot)
{
	char *message;
	char location;
	short messageid;

	if (groupwork)
	{
		location=0;
		//send message to pair/group members
		message=(char *)malloc(sizeof(short)+sizeof(int)+g_utf8_strlen(srcLocation,-1)+1+sizeof(guint));
		messageid=ADD_NEW_SAMPLE_TO_TRACK_NTH_SLOT;
		memcpy(message+location,&messageid,sizeof(short));
		location=location+sizeof(short);
		memcpy(message+location,&track_number,sizeof(int));
		location=location+sizeof(int);
		memcpy(message+location,srcLocation,g_utf8_strlen(srcLocation,-1)+1);
		location=location+g_utf8_strlen(srcLocation,-1)+1;
		memcpy(message+location,&slot,sizeof(guint));
		location=location+sizeof(guint);



		//communication_send_data(1, message,location);
		collaboration_send_to_current_group(message,location);
		free(message);
	}
}
void collaboration_remove_sample_from_slot(guint track_number,int slot)
{
	char *message;
	char location;
	short messageid;

	if (groupwork)
	{
		location=0;
		//send message to pair/group members

		message=(char *)malloc(sizeof(short)+sizeof(guint)+sizeof(int));
		messageid=REMOVE_SAMPLE_FROM_SLOT;
		memcpy(message+location,&messageid,sizeof(short));
		location=location+sizeof(short);
		memcpy(message+location,&track_number,sizeof(guint));
		location=location+sizeof(guint);
		memcpy(message+location,&slot,sizeof(int));
		location=location+sizeof(int);

		//communication_send_data(1, message,location);
		collaboration_send_to_current_group(message,location);
		free(message);
	}
}

void collaboration_user_info_request()
{
	char *message;
	short messageid;
	char location;

	message=(char *)malloc(sizeof(short));
	memcpy(message+location,&messageid,sizeof(short));
	location=location+sizeof(short);
	communication_send_data(0, message,location);
}

void collaboration_handle_message(char* message,int length, int id)
{
	short messageid;
	int ret=0;
	memcpy(&messageid,message,sizeof(short));
	printf("Got message with id: %d, length: %d\n",messageid, length);
	switch (messageid)
	 {
		case ADD_NEW_SAMPLE_TO_TRACK:
			ret=decode_add_new_sample_to_track(message, length);
			break;	
		case REMOVE_SAMPLE_FROM_SLOT:
			ret=decode_remove_sample_from_slot(message, length);
			break;
		case USER_INFO_REQUEST:
			ret=decode_user_info_request(message, length, id);
			break;
		case USER_INFO_RESPONSE:
			ret=decode_user_info_response(message, length, id);
			break;		

	}
	if (ret<length && ret>0)
	{
		collaboration_handle_message(message+ret,length-ret, id);
	}
	
}

int decode_add_new_sample_to_track(char* message,int length)
{
	int track_number;
	gchar* srcLocation;
	guint64 startTime;
	char location;

	location=sizeof(short);
	memcpy(&track_number,message+location,sizeof(int));
	location=location+sizeof(int);

	srcLocation=(gchar *)malloc(g_utf8_strlen(message+location,-1)+1);
	memcpy(srcLocation,message+location,g_utf8_strlen(message+location,-1)+1);
	location=location+g_utf8_strlen(message+location,-1)+1;
	memcpy(&startTime,message+location,sizeof(guint64));
	location=location+sizeof(guint64);

	//call upper level function with these parameters
	printf("\nTrack number: %d, id: %s, starttime: %lld, message length: %d\n",track_number, srcLocation, startTime, location);
	chum_add_new_sample_to_track_remote(track_number, srcLocation, startTime);
	return location;
}


int decode_remove_sample_from_slot(char* message,int length)
{
	guint track_number;
	int slot;
	char location;

	location=sizeof(short);
	memcpy(&track_number,message+location,sizeof(guint));
	location=location+sizeof(int);

	memcpy(&slot,message+location,sizeof(int));
	location=location+sizeof(int);

	//call upper level function with these parameters
	printf("\nTrack number: %d, slot: %d, message length: %d",track_number, slot, location);
	chum_remove_sample_from_slot_remote(track_number,slot);
	return location;
}

int decode_user_info_request(char* message,int length, int id)
{
	char name[20]="User Name";
	char address[20]="127.0.0.1";
	int port=5555;
	char *rspmessage;
	char location=0;
	short messageid;
	
	//Send the info of this user
	rspmessage=(char *)malloc(sizeof(short)+strlen(name)+1+strlen(address)+1+sizeof(int));
	messageid=USER_INFO_RESPONSE;
	memcpy(rspmessage+location,&messageid,sizeof(short));
	location=location+sizeof(short);
	memcpy(rspmessage+location,name,strlen(name)+1);
	location=location+strlen(name)+1;
	memcpy(rspmessage+location,name,strlen(address)+1);
	location=location+strlen(address)+1;
	memcpy(rspmessage+location,&port,sizeof(int));
	location=location+sizeof(int);
	communication_send_data(id, rspmessage,location);

	//return the (possible )rest of the message
	location=sizeof(short);
	return location;
}

int decode_user_info_response(char* message,int length, int id)
{
	char location;

	location=sizeof(short);
	users.current.id=id;
	users.current.name=(char *)malloc(strlen(message+location)+1);
	memcpy(users.current.name,message+location,strlen(message+location)+1);
	location=location+strlen(message+location)+1;
	users.current.address=(char *)malloc(strlen(message+location)+1);
	memcpy(users.current.address,message+location,strlen(message+location)+1);
	location=location+strlen(message+location)+1;
	memcpy(&users.current.port,message+location,sizeof(int));
	location=location+sizeof(int);

	printf("\nUser info, id: %d, name: %s address: %s, port: %d",users.current.id, users.current.name, users.current.address,users.current.port );

	return location;
}

void collaboration_start_pair_game()
{
	
}

int collaboration_create_game_client(char *address, int port)
{
	int result;



	currentgame.users[0]=1;
	result=communication_create_connection(currentgame.users[0], address, port);
	if (result)
		groupwork=1;
	return result;
}
int collaboration_create_game_server(int port)
{
	int result;


	currentgame.users[0]=1;
	result=communication_start_server(currentgame.users[0], port);
	if (result)
		groupwork=1;

	return result;
}

int collaboration_send_to_current_group(char* message,int length)
{
	int i;

	if (classroom)//send to teacher
	{
		communication_send_data(0, message,length);
	}
	for(i=0;i<groupwork;i++)//send to other members of group
	{
		communication_send_data(i+1, message,length);
	}
	return 0;

}
