/**object.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
Objects are those icons which user can drag from playing area to timeline area.
*/

#include <clutter/clutter.h>
#include <stdlib.h>
#include <stdio.h>
#include "clutter_jammo.h"
#include "config.h"
#include "object.h"
#include "jammo-texture.h"
#include "composing_game.h"

#include "../chum/chum.h"

//private functions
static void add_object_to_group(ClutterActor* actor,ClutterActor* group);

static JammoTexture *dragging = NULL;		     /*object which is currently dragged*/
static gint x_start_of_dragging, y_start_of_dragging, x_drag_offset, y_drag_offset;   /*these are related to dragging also*/



/*
Every time mouse moves on stage we check if dragging is going. Is so we move the
dragged object. This is because only watching dragged object we lost it if mouse
moves too fast and isn't anymore top of object.
*/
//void mouse_motion_on_stage(ClutterActor *actor, ClutterEvent *event, gpointer data) {
static void motion_on_object(ClutterActor *actor, ClutterEvent *event, gpointer data) {
  gfloat x_mouse_position_f, y_mouse_position_f;
/*
clutter_event_get_coords (event,&x_mouse_position, &y_mouse_position);
clutter_actor_set_position (CLUTTER_ACTOR(actor), x_mouse_position, y_mouse_position);
return;
*/
  if (CLUTTER_IS_ACTOR(dragging) && dragging != NULL) {
      clutter_event_get_coords (event,&x_mouse_position_f, &y_mouse_position_f);
      //printf("X=%f, Y=%f\n",x_mouse_position, y_mouse_position);
      gint new_x, new_y;
      gint x_mouse_position=(gint)x_mouse_position_f;
      gint y_mouse_position=(gint)y_mouse_position_f;

      //If object are over valid_area, use SNAPPING.
      if (is_inside_valid_area(x_mouse_position, y_mouse_position)) {
	  int slot_number =  (x_mouse_position + x_drag_offset) / WIDTH_OF_SLOT;
	  new_x = slot_number*WIDTH_OF_SLOT;
	  new_y=Y_PLACE_OF_TIMELINE;
      } else {
	  new_x=x_mouse_position + x_drag_offset;
	  new_y=y_mouse_position + y_drag_offset;
      }

      clutter_actor_set_position (CLUTTER_ACTOR(dragging), new_x, new_y);		
  }
}

#ifdef BEHAVIOURS_DISABLED
/*When we want stop behaviour, we add signal to timeline which triggers when frame 1 starts.
Then this function is called and we stop behaviour for this actor.*/
static void start_of_loop(ClutterTimeline *timeline,  gchar *name, gint frame, gpointer data) {
//We want this happens only once, so remove it.
clutter_timeline_remove_marker(timeline,name); 
//printf("frame 1 reached: %s\n",name);

    ActorBehaviour *ab = (ActorBehaviour*)data;
    ClutterActor *actor = ab->actor;
    ClutterBehaviour *behaviour = ab->behaviour;

    clutter_behaviour_remove (behaviour,actor);
}
#endif

/*
Use this function when actor is placed in valid-area.
This handles only places of graphical actors, not sound samples.
*/
void put_in_timeline(JammoTexture *dropped_actor, gint release_x)  {
//This new will take asked place.
clutter_actor_set_position (CLUTTER_ACTOR(dropped_actor), release_x, Y_PLACE_OF_TIMELINE);
gint width_of_new=clutter_actor_get_width(CLUTTER_ACTOR(dropped_actor));
//if this doesn't fit, we can remove graphical object now. sound is already handled.
if (width_of_new+release_x>WIDTH_OF_WINDOW) {
    clutter_container_remove_actor(CLUTTER_CONTAINER(clutter_actor_get_parent(CLUTTER_ACTOR(dropped_actor))), CLUTTER_ACTOR(dropped_actor));
return;
}
int slots_of_new= width_of_new / WIDTH_OF_SLOT; //how many slot this takes.
//printf("put_in_timeline starts: x=%d, width=%d\n",release_x,width_of_new);

int i,j;

  //Loop over all actors
  GList* children = composing_game_get_actors_in_track();
  GList *l;
  for (l = children; l; l = l->next){
    JammoTexture *actor = l->data;
    const gchar *name = clutter_actor_get_name(CLUTTER_ACTOR(actor));
    printf ("name is %s\n",name);
       gfloat x0_f,y0_f;
       clutter_actor_get_position (CLUTTER_ACTOR(actor),&x0_f,&y0_f);
       //objects coordinates:
       gint x0=(gint)x0_f;
       //gint y0=(gint)y0_f; //not used yet.
       //we not interested in current_actor
       if ( actor != dropped_actor){
             //printf("x=%d, y=%d\n",x0,y0);
             gint x0_width=clutter_actor_get_width(CLUTTER_ACTOR(actor));
             gint x0_slots=x0_width/ WIDTH_OF_SLOT;
             for (i=0;i<slots_of_new;i++) {
                  for (j=0;j<x0_slots;j++) {
                      //check if new actor has any common slots with this
                      if ((x0+j*WIDTH_OF_SLOT==release_x+i*WIDTH_OF_SLOT)) { 
                          //move it too
                          put_in_timeline(actor,x0+(slots_of_new-i+j)*WIDTH_OF_SLOT);
                          //break;
                      }
                  }
            }
      }
  }
  /*
  ClutterActor *stage=clutter_actor_get_parent(CLUTTER_ACTOR(dropped_actor));
  GList* children= clutter_container_get_children (CLUTTER_CONTAINER (stage));
  GList *l;
  for (l = children; l; l = l->next){
    JammoTexture *actor = l->data;
    gchar *name = clutter_actor_get_name(actor);
    printf ("name is %s\n",name);
       gfloat x0_f,y0_f;
       clutter_actor_get_position (CLUTTER_ACTOR(actor),&x0_f,&y0_f);
       gint x0=(gint)x0_f,y0=(gint)y0_f; //objects coordinates
       //we are interested in only objects in valid_area (but not current_actor)
       if (is_inside_valid_area(x0,y0) && actor != dropped_actor){
             //printf("x=%d, y=%d\n",x0,y0);
	     gint x0_width=clutter_actor_get_width(CLUTTER_ACTOR(actor));
	     gint x0_slots=x0_width/ WIDTH_OF_SLOT;
	     for (i=0;i<slots_of_new;i++) {
		  for (j=0;j<x0_slots;j++) {
		      //check if new actor has any common slots with this
		      if ((x0+j*WIDTH_OF_SLOT==release_x+i*WIDTH_OF_SLOT)) { 
			  //move it too
			  put_in_timeline(actor,x0+(slots_of_new-i+j)*WIDTH_OF_SLOT);
			  //break;
		      }
		  }
	    }
      }
  }*/

}

char* object_add_to_timeline_remote(const char* id, guint64 startTime){
ClutterActor* new_actor;
new_actor = config_respawn_loop_actor(chum_get_theme_folder(chum_get_current_theme()), id);

if (new_actor ==NULL) printf("new_actor is NULL\n");
    
ClutterActor* stage = main_getStage();
clutter_container_add_actor (CLUTTER_CONTAINER (stage), new_actor);
clutter_actor_set_position (CLUTTER_ACTOR(new_actor), 500, 200 );
clutter_actor_show (new_actor);

gchar *sound;
g_object_get(G_OBJECT(new_actor), "sound-file", &sound, NULL);

return sound;
}


/**
dropped_actor = actor which is just placed valid_area
release_x, release_y = its coordinates (they are in valid_area)
*/
void object_add_to_timeline(JammoTexture *dropped_actor, gint release_x,gint sukka_y){
int slot_number = release_x / WIDTH_OF_SLOT;
gint icon_place_of_dropped = slot_number*WIDTH_OF_SLOT;   //this is x coordinate of dropped

GList *actors_in_track  = composing_game_get_actors_in_track();
actors_in_track  = g_list_append(actors_in_track,  CLUTTER_ACTOR (dropped_actor));


printf ("slot number %d\n",slot_number);
put_in_timeline(dropped_actor,icon_place_of_dropped);
//Put sound
 gchar *sound;
  g_object_get(G_OBJECT(dropped_actor), "sound-file", &sound, NULL);
  const gchar* id_of_actor;
  id_of_actor = clutter_get_script_id(G_OBJECT(dropped_actor));

  gchar* buffer0;
  buffer0 = g_strdup_printf("%s/themes/%s/%s",DATA_DIR,chum_get_theme_folder(chum_get_current_theme()), sound);

 chum_add_new_sample_to_track_nth_slot(editing_track,id_of_actor,buffer0,slot_number);

#ifdef ALL_BEHAVING_ARE_DISABLED_TEMPORARILY
//stop behaving
  GList *behaviours_and_actors = get_current_behaviours_and_actors();
  GList *l_counter;
  int counter=0;
  for (l_counter = behaviours_and_actors; l_counter; l_counter = l_counter->next){
    counter++;
    ActorBehaviour *ab = l_counter->data;
    ClutterActor *actor = ab->actor;
    if (CLUTTER_ACTOR(dropped_actor)==actor)	{
	printf("found\n");
	ClutterAlpha* alpha=clutter_behaviour_get_alpha(ab->behaviour);
	ClutterTimeline *tl=clutter_alpha_get_timeline (alpha);

        clutter_timeline_add_marker_at_time (tl,"first_frame",1); //time in milliseconds
	g_signal_connect (tl, "marker-reached", G_CALLBACK (start_of_loop),ab);

	//some mysterious reason, we can't remove first entry from list
	//just let it here (this isn't cumulative bloat)
	if (counter==1)
	    {}
	else
	  behaviours_and_actors=g_list_remove(behaviours_and_actors,l_counter->data);

	break; //we can stop when actor is founded
    }
    else printf("not\n");
  }
#endif

}



/**
 * This function checks the coordinates to determine whether the given 
 * location is inside valid area (dropping area) and returns a boolean
 *
 * @param	x_release	this is the x-coordinate 
 * 
 * @param	y_release	this is the y-coordinate 
 * 
 * @return	gboolean	this just returns a boolean is this coordinate inside area
 */
gboolean is_inside_valid_area (gint asked_x, gint asked_y) {
	ClutterActor* valid_area = get_drop_area();

	gint valid_area_x = clutter_actor_get_x(CLUTTER_ACTOR(valid_area));
	gint valid_area_y = clutter_actor_get_y(CLUTTER_ACTOR(valid_area));
	guint valid_area_width = clutter_actor_get_width(CLUTTER_ACTOR(valid_area));
	guint valid_area_height = clutter_actor_get_height(CLUTTER_ACTOR(valid_area));

	//printf("valid_area: x=%d, y=%d, width=%d, heigth=%d\n",valid_area_x,valid_area_y,valid_area_width,valid_area_height);
	//printf("in_valid_area? x=%d, y=%d\n",x_release,y_release);

	gboolean r =FALSE;
	// returns true if the position is inside the given values
	if( asked_x >= valid_area_x && asked_x <= (valid_area_x + valid_area_width) ) {
	  if( asked_y >= valid_area_y && (asked_y) <= (valid_area_y + valid_area_height) ) {
			r=TRUE;
		}
	}
return r;
}


static void object_pressed (JammoTexture *actor, ClutterEvent *event, gpointer data) {
  gfloat x_start_of_dragging_f,y_start_of_dragging_f;
  clutter_event_get_coords (event, &x_start_of_dragging_f, &y_start_of_dragging_f);

  x_start_of_dragging=(gint)x_start_of_dragging_f;
  y_start_of_dragging=(gint)y_start_of_dragging_f;

  dragging=actor;// puts the actor clicked to the dragging actor
  x_drag_offset = (clutter_actor_get_x (CLUTTER_ACTOR(dragging)) - (int)x_start_of_dragging);
  y_drag_offset = (clutter_actor_get_y (CLUTTER_ACTOR(dragging)) - (int)y_start_of_dragging);

  //even this object is not focused it still gets the mouse events
  clutter_grab_pointer(CLUTTER_ACTOR(actor)); 
}


//Game is designed to play with finger, so this should be high.
#define CLICKING_THRESHOLD 30

static void object_released (JammoTexture *actor, ClutterEvent *event, gpointer data) {
  //Just to be sure.
  if (dragging == NULL){
    printf("dragging == NULL\n");
    return;
  }
  //If object are clicked but not moved, we play its sound
  gfloat x_release_f, y_release_f;
  clutter_event_get_coords (event, &x_release_f, &y_release_f);
  gint x_release=(gint)x_release_f;
  gint y_release=(gint)y_release_f;
  clutter_ungrab_pointer(); //ungrab
  dragging = NULL;

  /*Check if this is not drag, but click on object.*/
  if ( x_release<=x_start_of_dragging+CLICKING_THRESHOLD &&
       x_release>=x_start_of_dragging-CLICKING_THRESHOLD &&
       y_release<=y_start_of_dragging+CLICKING_THRESHOLD &&
       y_release>=y_start_of_dragging-CLICKING_THRESHOLD   )
     {
     	JammoSample* sample;
	
/*	if ((sample = jammo_texture_get_sample(JAMMO_TEXTURE(actor)))) {
There is no path of sound-file in JSON. So...
*/
  gchar* buffer0;
  buffer0 = g_strdup_printf("%s/themes/%s/%s",DATA_DIR,chum_get_theme_folder(chum_get_current_theme()), jammo_texture_get_sound_file_name(JAMMO_TEXTURE(actor)));
  sample = jammo_sample_new_from_file(buffer0);
		jammo_sample_stop_all();
		jammo_sample_play(sample);
/*	}
*/
  g_free(buffer0);
  g_object_unref(sample);

       //if icon is  moved little bit, we should move it back (other these little moves can be cumulated*/
       clutter_actor_set_position (CLUTTER_ACTOR(actor), x_start_of_dragging + x_drag_offset, y_start_of_dragging + y_drag_offset );

       return;
     }

/*There are four possibilities.
A) Dragged object starts from valid_area and it is moved another place in valid_area
B) Dragged object starts from valid_area and it is removed out from valid_area
C) Dragged object starts from stage and lands on valid_area
D) Dragged object starts from stage and lands on stage
*/
gint width_of_new=clutter_actor_get_width(CLUTTER_ACTOR(actor));
//if tried to move outside of the screen (even partially), just move it back
//right side of screen might be only risk-area
if (width_of_new+x_release>WIDTH_OF_WINDOW) {
  clutter_actor_set_position (CLUTTER_ACTOR(actor), x_start_of_dragging + x_drag_offset, y_start_of_dragging + y_drag_offset );
 return;
}

  //check are we handling already placed objects
  //we need better way to solve this. FIXME
  if (is_inside_valid_area((x_start_of_dragging += x_drag_offset), (y_start_of_dragging += y_drag_offset))) {
   int slot_number = (x_start_of_dragging - x_drag_offset) / WIDTH_OF_SLOT;
   chum_remove_sample_from_slot(0,slot_number); //first parameter is track_number

  //moving valid_area to valid_area.
  if ((is_inside_valid_area( (x_release + x_drag_offset), (y_release + y_drag_offset)))) {
    //use this (if there are something in way, they are handled too)
    object_add_to_timeline(actor,x_release + x_drag_offset, (y_release + y_drag_offset));
  }
  else  {
    clutter_container_remove_actor(CLUTTER_CONTAINER(clutter_actor_get_parent(CLUTTER_ACTOR(actor))), CLUTTER_ACTOR(actor));
    }
  }else {

  //We are handling object from stage 
      if (is_inside_valid_area( (x_release + x_drag_offset), (y_release + y_drag_offset))) {
        //it is allowed to place here
        object_add_to_timeline(actor,x_release + x_drag_offset, (y_release + y_drag_offset));
          //object_add_to_timeline(actor,x_release, (y_release ));

///////////////////
          //Spawn new object in stage.
          ClutterActor* parent_group = clutter_actor_get_parent(CLUTTER_ACTOR(actor));
          const gchar* id_of_actor;
          id_of_actor = clutter_get_script_id(G_OBJECT(actor));

          ClutterActor* new_actor;
          new_actor = config_respawn_loop_actor(chum_get_theme_folder(chum_get_current_theme()),  (gchar*)id_of_actor);
          if (new_actor ==NULL)
              printf("new_actor is NULL\n");
          if (parent_group ==NULL)
            printf("parent_group is NULL\n");

          add_object_to_group(new_actor,parent_group);

      } else {
          //Forbidden place to drop object, move it back where it comes.
          clutter_actor_set_position (CLUTTER_ACTOR(actor), x_start_of_dragging, y_start_of_dragging );
     }
  }


}



static void add_object_to_group(ClutterActor* actor,ClutterActor* group){
    clutter_container_add_actor(CLUTTER_CONTAINER(group), actor);
    clutter_actor_set_reactive(actor, TRUE);
    g_signal_connect (actor, "button-press-event", G_CALLBACK (object_pressed), NULL);
    g_signal_connect (actor, "button-release-event", G_CALLBACK (object_released), NULL);
    g_signal_connect (actor, "motion-event", G_CALLBACK (motion_on_object), NULL);
}


/**
 * This function loads all objects for a stage. It loads the
 * objects to objects_group (ClutterGroup). 
 *
 * Each object got connected to signals, press, release, motion.
 * 
 * @param	objects_group	pointer for all objects in a stage
 * @param	theme_folder	Folder of asked theme
 */
void object_create_stage_object_group (ClutterActor* objects_group, const gchar *theme_folder) {
	ClutterActor* actor;

 GList *actors= config_get_objects_for_theme(theme_folder);
 GList *l;
 for (l = actors; l; l = l->next){
    actor=l->data; 
    //printf("object.c: %s\n",clutter_get_script_id(actor) );
  add_object_to_group(actor,objects_group);

 }

}
