/*
 * jammo-instrument-track.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009 University of Oulu
 *
 * Authors: Aapo Rantalainen
 */
 
#include "jammo-instrument-track.h"
#include "jammo-meam.h"
#include "jammo-meam-private.h"
#include <sys/time.h>
#include "../chum/chum.h" //because of DATA_DIR
#define INSTRUMENT_FOLDER DATA_DIR "/virtual-instruments/"

G_DEFINE_TYPE(JammoInstrumentTrack, jammo_instrument_track, JAMMO_TYPE_TRACK);

enum {
	PROP_0,
	PROP_INSTRUMENT_TYPE,
};

struct _JammoInstrumentTrackPrivate {
	GstElement* element;
	int instrument_type;
	struct timeval creation_time;
};

JammoInstrumentTrack* jammo_instrument_track_new(JammoInstrumentType instrument_type) {
	return JAMMO_INSTRUMENT_TRACK(g_object_new(JAMMO_TYPE_INSTRUMENT_TRACK,"instrument-type",instrument_type,NULL));
}

static guint64 jammo_instrument_track_get_duration(JammoTrack* track) {
	guint64 duration = 0;

	/* TODO: Get real duration. */

	return duration;
}

static GstElement* jammo_instrument_track_get_element(JammoTrack* track) {

	return JAMMO_INSTRUMENT_TRACK(track)->priv->element;
}

static void jammo_instrument_track_set_property(GObject* object, guint prop_id, const GValue* value, GParamSpec* pspec) {
	JammoInstrumentTrack* instrument_track;
	
	instrument_track = JAMMO_INSTRUMENT_TRACK(object);

	switch (prop_id) {
		case PROP_INSTRUMENT_TYPE:
			instrument_track->priv->instrument_type = g_value_get_int(value);
			printf("set_property: instrument=%d \n",g_value_get_int(value));
			break;
		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
			break;
	}
}

static void jammo_instrument_track_get_property(GObject* object, guint prop_id, GValue* value, GParamSpec* pspec) {
    JammoInstrumentTrack* instrument_track;
		instrument_track = JAMMO_INSTRUMENT_TRACK(object);

        switch (prop_id) {
					case PROP_INSTRUMENT_TYPE:
						g_value_set_int(value, instrument_track->priv->instrument_type);
						break;
	        default:
		        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
		        break;
        }
}

static void jammo_instrument_track_finalize(GObject* object) {
	G_OBJECT_CLASS(jammo_instrument_track_parent_class)->finalize(object);
}

static void jammo_instrument_track_dispose(GObject* object) {
	JammoInstrumentTrack* instrument_track;

	instrument_track = JAMMO_INSTRUMENT_TRACK(object);
	G_OBJECT_CLASS(jammo_instrument_track_parent_class)->dispose(object);
}


static GObject* jammo_instrument_track_constructor(GType type, guint n_properties, GObjectConstructParam* properties) {
	GObject* object;
	JammoInstrumentTrack* instrument_track;

	object = G_OBJECT_CLASS(jammo_instrument_track_parent_class)->constructor(type, n_properties, properties);

	instrument_track = JAMMO_INSTRUMENT_TRACK(object);
	instrument_track->priv = G_TYPE_INSTANCE_GET_PRIVATE(instrument_track, JAMMO_TYPE_INSTRUMENT_TRACK, JammoInstrumentTrackPrivate);

	int instrument_nro = instrument_track->priv->instrument_type;
	printf ("Type of instrument is: %d\n",instrument_nro);
	
	instrument_track->priv->element = gst_element_factory_make("jammosampler", NULL);

	//We must first define folder of samples
	g_object_set(G_OBJECT(instrument_track->priv->element), "instrument-folder", INSTRUMENT_FOLDER, NULL);
	char *buffer=NULL;
	buffer=g_strdup_printf("%s%s",INSTRUMENT_FOLDER,"flute.txt"); //Default value

	if (instrument_nro==JAMMO_INSTRUMENT_TYPE_FLUTE){
			buffer=g_strdup_printf("%s%s",INSTRUMENT_FOLDER,"flute.txt");
	}
	if (instrument_nro==JAMMO_INSTRUMENT_TYPE_DRUMKIT){
			buffer=g_strdup_printf("%s%s",INSTRUMENT_FOLDER,"drumkit.txt");
	}
	if (instrument_nro==JAMMO_INSTRUMENT_TYPE_UD){
			buffer=g_strdup_printf("%s%s",INSTRUMENT_FOLDER,"ud.txt");
	}

	g_object_set(G_OBJECT(instrument_track->priv->element), "init-instrument", buffer, NULL);

	gettimeofday(&instrument_track->priv->creation_time, NULL);

	return object;
}


static void jammo_instrument_track_class_init(JammoInstrumentTrackClass* instrument_track_class) {
	GObjectClass* gobject_class = G_OBJECT_CLASS(instrument_track_class);
	JammoTrackClass* track_class = JAMMO_TRACK_CLASS(instrument_track_class);

	track_class->get_duration = jammo_instrument_track_get_duration;
	track_class->get_element = jammo_instrument_track_get_element;
	gobject_class->constructor = jammo_instrument_track_constructor;
	gobject_class->finalize = jammo_instrument_track_finalize;
	gobject_class->dispose = jammo_instrument_track_dispose;
	gobject_class->set_property = jammo_instrument_track_set_property;
	gobject_class->get_property = jammo_instrument_track_get_property;

	/**
	 * JammoInstrumentTrack:instrument-type:
	 */
	g_object_class_install_property(gobject_class, PROP_INSTRUMENT_TYPE,
	                                g_param_spec_int("instrument-type",
	                                "Instrument type",
	                                "Specifies type of instrument",
	                                0,JAMMO_INSTRUMENT_TYPE_DUMMY-1,0,
	                                G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	
	g_type_class_add_private(gobject_class, sizeof(JammoInstrumentTrackPrivate));
}


/*
 Returns time difference between current time
 and instrument_track->priv->creation_time  
*/
struct timeval calc_timestamp (JammoInstrumentTrack* instrument_track) {
  struct timeval result;

  struct timeval now;
  gettimeofday(&now, NULL);

  if (now.tv_usec < instrument_track->priv->creation_time.tv_usec) {
    int nsec = (instrument_track->priv->creation_time.tv_usec - now.tv_usec) / 1000000 + 1;
    instrument_track->priv->creation_time.tv_usec -= 1000000 * nsec;
    instrument_track->priv->creation_time.tv_sec += nsec;
  }
  if (now.tv_usec - instrument_track->priv->creation_time.tv_usec > 1000000) {
    int nsec = (now.tv_usec - instrument_track->priv->creation_time.tv_usec) / 1000000;
    instrument_track->priv->creation_time.tv_usec += 1000000 * nsec;
    instrument_track->priv->creation_time.tv_sec -= nsec;
  }

  /* Compute the time.
     tv_usec is certainly positive. */
  result.tv_sec = now.tv_sec - instrument_track->priv->creation_time.tv_sec;
  result.tv_usec = now.tv_usec - instrument_track->priv->creation_time.tv_usec;

  return result;
}


void jammo_instrument_track_set_note(JammoInstrumentTrack* instrument_track,char note,int octave){
	gchar *buffer0;
	buffer0 = g_strdup_printf("%c%d",note,octave);
	g_object_set(G_OBJECT(instrument_track->priv->element), "note-toggle", buffer0, NULL);

	struct timeval timestamp;
	timestamp=calc_timestamp(instrument_track);
	printf("INSTRUMENT_TRACK: %ld.%ld: note %c%d toggled\n", timestamp.tv_sec,timestamp.tv_usec,note,octave); 
}

static void jammo_instrument_track_init(JammoInstrumentTrack* instrument_track) {
	instrument_track->priv = G_TYPE_INSTANCE_GET_PRIVATE(instrument_track, JAMMO_TYPE_INSTRUMENT_TRACK, JammoInstrumentTrackPrivate);
}

