/**sequencer.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is the sequencer.
 */

#include <glib-object.h>
#include <clutter/clutter.h>
#include <math.h>
#include <string.h>

#include "jammo-texture.h"
#include "clutter_jammo.h"

#include "config.h"
#include "sequencer.h"

//private functions
//static void add_object_to_group(ClutterActor* actor,ClutterActor* group);
static void create_general_container();

gboolean sequencer_is_ready = FALSE;


/*
 * state machine states
 */
enum {
	SEQUENCER_STATE_MOVING = 0,
			SEQUENCER_STATE_LOOP,
			SEQUENCER_STATE_SEQUENCER,
			SEQUENCER_STATE_GENERAL,
			LOOP_ROLL_READY,
			LOOP_ROLL_MOVING,
			SEQUENCER_STATE_PLAYING,
			SEQUENCER_STATE_AUDIO_RECORD

};

int state = SEQUENCER_STATE_SEQUENCER, loop_view_state = LOOP_ROLL_READY;

//dragging
gboolean is_dragging;
gint x_start_of_dragging, y_start_of_dragging, x_drag_offset, y_drag_offset;
gint height, pos_0_y, pos_1_y, pos_2_y;
ClutterRectangle* tempo_switch_positions[3];
ClutterRectangle* pitch_switch_positions[3];
ClutterRectangle* tempo_switch_area;
ClutterRectangle* pitch_switch_area;

ClutterActor *sequencer_group;

ClutterActor *BUTTON_SEQUENCER_PLAY;
ClutterActor *BUTTON_SEQUENCER_PLAY_STOP;
ClutterActor *BUTTON_SEQUENCER_HOME;
ClutterActor *BUTTON_SEQUENCER_WORKSHOP;
ClutterActor *BUTTON_SEQUENCER_MENTOR;
ClutterActor *BUTTON_SEQUENCER_AUDIO_RECORD;
ClutterActor *BUTTON_SEQUENCER_AUDIO_RECORD_STOP;
ClutterActor *BUTTON_SEQUENCER_METRONOME;
ClutterActor *BUTTON_SEQUENCER_METRONOME_STOP;
ClutterActor *BUTTON_SEQUENCER_MUTE[6];
ClutterActor *BUTTON_SEQUENCER_VOLUME[6];

gboolean BUTTON_SEQUENCER_MUTE_STATES[6] = {0,0,0,0,0,0}; //0=mute off, 1=mute on
gint SEQUENCER_VOLUME_STATES[6] = {0,0,0,0,0,0};
gint BUTTON_SEQUENCER_VOLUME_ACTIVE = -1; //which volume button is pressed down

/*
 * Packs ClutterActors in array which size is known.
 * Eases usage of actors in loop rolls.
 */
typedef struct {
	ClutterActor *roll_group;
	ClutterActor **roll_background;
	ClutterActor **sample_labels;
	int size_of_array;
	gboolean is_locked;
} ActorArray;

ActorArray *get_actor_array_new() {
	ActorArray *actor_array = malloc(sizeof(ActorArray));
	actor_array->size_of_array = 0;
	actor_array->roll_group = clutter_group_new();
	actor_array->roll_background = malloc(5 * sizeof(ClutterActor*));
	actor_array->sample_labels = NULL;
	actor_array->is_locked = FALSE;

	return actor_array;
}
/*
 * Adds actor to given ActorArray
 */
void add_actor_to_actor_array(ActorArray *array, ClutterActor *actor) {
	if(array->sample_labels != NULL) {
		array->size_of_array++;
		array->sample_labels = realloc(array->sample_labels, array->size_of_array * sizeof(ClutterActor*));
		array->sample_labels[array->size_of_array - 1] = actor;
	} else {
		array->size_of_array = 1;
		array->sample_labels = malloc(sizeof(ClutterActor*));
		array->sample_labels[0] = actor;
	}
	clutter_container_add_actor(CLUTTER_CONTAINER(array->roll_group), actor);
	gfloat pos_y = 0;

	if(array->size_of_array > 1) {
		int i = 0, old_max = array->size_of_array - 1;
		pos_y = clutter_actor_get_y(array->sample_labels[old_max - 1]);
		clutter_actor_set_position(actor, 0.0, pos_y + 95.0);

		for(i = 0; i < old_max; i++) {
			if(clutter_actor_get_y(array->sample_labels[i]) >= pos_y + 95.0) {
				clutter_actor_set_position(array->sample_labels[i], 0.0, clutter_actor_get_y(array->sample_labels[i]) + 95.0);
			}
		}

	} else {
		clutter_actor_set_position(array->sample_labels[array->size_of_array - 1], 0.0, 192.0);
	}
	pos_y = clutter_actor_get_y(array->sample_labels[array->size_of_array - 1]);
	if(pos_y > 2 && pos_y < 390) {
		clutter_actor_show(array->sample_labels[array->size_of_array - 1]);
	} else {
		clutter_actor_hide(array->sample_labels[array->size_of_array - 1]);
	}
}


static gboolean set_sequencer_state_loop(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	state = SEQUENCER_STATE_LOOP;
	return TRUE;
}

static gboolean set_sequencer_state_sequncer(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	state = SEQUENCER_STATE_SEQUENCER;
	return TRUE;
}

static gboolean set_sequencer_state_general(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	state = SEQUENCER_STATE_GENERAL;
	return TRUE;
}

static gboolean set_sequencer_state_play(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	clutter_actor_hide (BUTTON_SEQUENCER_PLAY);

	state = SEQUENCER_STATE_PLAYING;

	//Show stop-button
	clutter_actor_show(BUTTON_SEQUENCER_PLAY_STOP);

	return TRUE;
}

static gboolean set_sequencer_state_play_stop(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	clutter_actor_hide (BUTTON_SEQUENCER_PLAY_STOP);

	state = SEQUENCER_STATE_SEQUENCER;

	//Show stop-button
	clutter_actor_show(BUTTON_SEQUENCER_PLAY);

	return TRUE;
}

static gboolean set_sequencer_state_return_home(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	/*ClutterAnimation *anim = */
	clutter_actor_animate (BUTTON_SEQUENCER_HOME,          /* the actor to animate */
			CLUTTER_LINEAR, /* the easing mode */
			100,           /* the duration of the animation */
			"scale-x", 1.0, /* final horizontal scaling factor */
			"scale-y", 1.0, /* final vertical scaling factor */
			"scale-gravity",CLUTTER_GRAVITY_CENTER,
			NULL);

	return TRUE;
}

static gboolean set_sequencer_state_workshop(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	/*ClutterAnimation *anim =*/
	clutter_actor_animate (BUTTON_SEQUENCER_WORKSHOP,          /* the actor to animate */
			CLUTTER_LINEAR, /* the easing mode */
			100,           /* the duration of the animation */
			"scale-x", 1.0, /* final horizontal scaling factor */
			"scale-y", 1.0, /* final vertical scaling factor */
			"scale-gravity",CLUTTER_GRAVITY_CENTER,
			NULL);

	return TRUE;
}

static gboolean set_sequencer_state_mentor(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	/*ClutterAnimation *anim = */
	clutter_actor_animate (BUTTON_SEQUENCER_MENTOR,          /* the actor to animate */
			CLUTTER_LINEAR, /* the easing mode */
			100,           /* the duration of the animation */
			"scale-x", 1.0, /* final horizontal scaling factor */
			"scale-y", 1.0, /* final vertical scaling factor */
			"scale-gravity",CLUTTER_GRAVITY_CENTER,
			NULL);

	return TRUE;
}

static gboolean set_sequencer_state_audio_record(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	clutter_actor_hide (BUTTON_SEQUENCER_AUDIO_RECORD);

	state = SEQUENCER_STATE_AUDIO_RECORD;

	//Show stop-button
	clutter_actor_show(BUTTON_SEQUENCER_AUDIO_RECORD_STOP);

	return TRUE;
}

static gboolean set_sequencer_state_audio_record_stop(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	clutter_actor_hide (BUTTON_SEQUENCER_AUDIO_RECORD_STOP);

	state = SEQUENCER_STATE_SEQUENCER;

	//Show stop-button
	clutter_actor_show(BUTTON_SEQUENCER_AUDIO_RECORD);

	return TRUE;
}



static gboolean set_sequencer_state_metronome_on(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	clutter_actor_hide (BUTTON_SEQUENCER_METRONOME);

	//Show stop-button
	clutter_actor_show(BUTTON_SEQUENCER_METRONOME_STOP);

	return TRUE;
}

static gboolean set_sequencer_state_metronome_stop(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	clutter_actor_hide (BUTTON_SEQUENCER_METRONOME_STOP);

	//Show stop-button
	clutter_actor_show(BUTTON_SEQUENCER_METRONOME);

	return TRUE;
}

static gboolean set_sequencer_mute_on(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	//button number is in data-parameter
	//int *num = data;
	//printf("%d\n", *num);

	//clutter_actor_hide (BUTTON_SEQUENCER_MUTE[*num]);

	return TRUE;
}

static gboolean set_sequencer_mute_off(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	//button number is in data-parameter
	//int *num = data;
	//printf("%d\n", *num);

	//clutter_actor_hide (BUTTON_SEQUENCER_MUTE[*num]);

	return TRUE;
}

/*
 * Event for changing to loop view
 */
static gboolean change_loop_view(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	if(state != SEQUENCER_STATE_MOVING) {
		ClutterAnimation *anim = clutter_actor_animate(sequencer_group,
				CLUTTER_EASE_IN_OUT_CUBIC, 1000, "x", 0.0, "y", 0.0, NULL);
		state = SEQUENCER_STATE_MOVING;
		g_signal_connect(anim, "completed", G_CALLBACK(set_sequencer_state_loop), NULL);
	}

	return TRUE;
}

/*
 * Event for changing to sequencer view
 */
static gboolean change_sequencer_view(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	if(state != SEQUENCER_STATE_MOVING) {
		ClutterAnimation *anim = clutter_actor_animate (sequencer_group,
				CLUTTER_EASE_IN_OUT_CUBIC, 1000, "x", 0.0, "y", -480.0, NULL);
		state = SEQUENCER_STATE_MOVING;
		g_signal_connect(anim, "completed", G_CALLBACK(set_sequencer_state_sequncer), NULL);
	}

	return TRUE;
}

/*
 * Event for changing to general view
 */
static gboolean change_general_view(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	if(state != SEQUENCER_STATE_MOVING) {
		ClutterAnimation *anim = clutter_actor_animate (sequencer_group,
				CLUTTER_EASE_IN_OUT_CUBIC, 1000, "x", 0.0, "y", -960.0, NULL);
		state = SEQUENCER_STATE_MOVING;
		g_signal_connect(anim, "completed", G_CALLBACK(set_sequencer_state_general), NULL);
	}
	return TRUE;
}

/*
 * locks loop wheel (given in data)
 */
static gboolean lock_loop_wheel(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	ActorArray *actor_array = data;
	actor_array->is_locked = TRUE;

	return TRUE;
}

/*
 * unlock loop wheel
 */
static gboolean unlock_loop_wheel(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	ActorArray *actor_array = data;
	actor_array->is_locked = FALSE;

	return TRUE;
}

/*
 * When triggered, enables moving of loop roll, given in data parameter.
 * Each roll has transparent ClutterRectangle, which is event (button-press-event) triggering actor
 */
static gboolean move_rolls(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	ActorArray *actor_array = data;
	if (!actor_array->is_locked) {
		loop_view_state = LOOP_ROLL_MOVING;
		gfloat tmp_x = 0, tmp_y = 0;
		clutter_event_get_coords(event, &tmp_x, &tmp_y);
		y_start_of_dragging = (gint) tmp_y;
		clutter_grab_pointer(actor);
	}
	return TRUE;
}

/*
 * When mouse button is released or function is called from roll_loop,
 * loop roll snaps into right position.
 */
static gboolean stop_rolls(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	loop_view_state = LOOP_ROLL_READY;
	clutter_ungrab_pointer();
	ActorArray *tmp = data;
	int i = 0;
	/* not currently needed, but if moving background in loop rolls
	   is wanted this can be used
	for (i = 0; i < 5; i++) {
		int now_y = (int) clutter_actor_get_y(tmp->roll_background[i]) + 100;
		int offset = (now_y - 5) % 95;
		if(offset != 0) {
			if(offset > 48) {
				clutter_actor_set_position(tmp->roll_background[i], 0, now_y - 100 + (95 - offset));
			} else {
				clutter_actor_set_position(tmp->roll_background[i], 0, now_y - 100 - offset);
			}
		}
		now_y = (int) clutter_actor_get_y(tmp->roll_background[i]);

		if(now_y < 0) {
			clutter_actor_set_position(tmp->roll_background[i], 0, now_y + 5 * 95);
		} else if(now_y > 390) {
			clutter_actor_set_position(tmp->roll_background[i], 0, now_y - 5 * 95);
		}
	}
	 */
	if(tmp->size_of_array > 0) {
		int total_height = tmp->size_of_array * 95;
		for (i = 0; i < tmp->size_of_array; i++) {
			int now_y = (int) clutter_actor_get_y(tmp->sample_labels[i]) + 100;
			int offset = (now_y - 5) % 95;
			if(offset != 0) {
				if(offset > 48) {
					clutter_actor_set_position(tmp->sample_labels[i], 0, now_y - 100 + (95 - offset));
				} else {
					clutter_actor_set_position(tmp->sample_labels[i], 0, now_y - 100 - offset);
				}
			}
			now_y = (int) clutter_actor_get_y(tmp->sample_labels[i]);

			if(now_y < 0) {
				if(tmp->size_of_array > 5)
					clutter_actor_set_position(tmp->sample_labels[i], 0, now_y + total_height);
				else
					clutter_actor_set_position(tmp->sample_labels[i], 0, now_y + 475);
			} else if(now_y > total_height) {
				if(tmp->size_of_array > 5)
					clutter_actor_set_position(tmp->sample_labels[i], 0, now_y - total_height);
				else
					clutter_actor_set_position(tmp->sample_labels[i], 0, now_y - 475);
			}
			now_y = (int) clutter_actor_get_y(tmp->sample_labels[i]);
			if(now_y >= 2 && now_y <= 390) {
				clutter_actor_show(tmp->sample_labels[i]);
			} else {
				clutter_actor_hide(tmp->sample_labels[i]);
			}
		}
	}

	return TRUE;
}

/*
 * Organizes loop roll elements while roll is being rolled.
 */
static gboolean roll_loop(ClutterActor *actor, ClutterEvent *event, gpointer data) {


  if(loop_view_state == LOOP_ROLL_MOVING) {
	  ActorArray *tmp = data;
	  gfloat tmp_pos_y = 0, tmp_pos_x = 0, new_pos_y = 0;
	  clutter_event_get_coords(event, &tmp_pos_x, &tmp_pos_y);
	  y_drag_offset = (gint) tmp_pos_y - y_start_of_dragging;
	  y_start_of_dragging = (gint) tmp_pos_y;
	  if(tmp_pos_y > 102 && tmp_pos_y < 382) {
		  int i = 0;

			/* not currently needed, but if moving background in loop rolls
			   is wanted this can be used
		  for (i = 0; i < 5; i++) {
			  new_pos_y = clutter_actor_get_y(tmp->roll_background[i]);
			  clutter_actor_set_position(tmp->roll_background[i], 0, new_pos_y + y_drag_offset);
			  int now_y = (int) clutter_actor_get_y(tmp->roll_background[i]);

			  if(now_y < 2) {
				  clutter_actor_set_position(tmp->roll_background[i], 0, now_y + 475);
			  } else if(now_y > 390) {
				  clutter_actor_set_position(tmp->roll_background[i], 0, now_y - 475);
			  }
		  }
<<<<<<< HEAD:src/gui_clutter/sequencer.c
		  */
		  if(tmp->size_of_array > 0) {
			  gint full_height = tmp->size_of_array * 95;
			  for (i = 0; i < tmp->size_of_array; i++) {
				  new_pos_y = clutter_actor_get_y(tmp->sample_labels[i]);
				  clutter_actor_set_position(tmp->sample_labels[i], 0, new_pos_y + y_drag_offset);
				  int now_y = (int) clutter_actor_get_y(tmp->sample_labels[i]);

				  if(now_y < 0) {
					  if(full_height > 475)
						  clutter_actor_set_position(tmp->sample_labels[i], 0, now_y + full_height);
					  else
						  clutter_actor_set_position(tmp->sample_labels[i], 0, now_y + 475);
				  } else if(now_y > 390) {
					  if(full_height > 475)
						  clutter_actor_set_position(tmp->sample_labels[i], 0, now_y - full_height);
					  else
						  clutter_actor_set_position(tmp->sample_labels[i], 0, now_y - 475);
				  }
				  new_pos_y = clutter_actor_get_y(tmp->sample_labels[i]);

				  if(new_pos_y >= 2 && new_pos_y <= 390) {
					  clutter_actor_show(tmp->sample_labels[i]);
				  } else {
					  clutter_actor_hide(tmp->sample_labels[i]);
				  }
			  }
		  }
	  } else {
		  stop_rolls(actor, event, data);
	  }
  }

	return TRUE;
}

ClutterActor *create_loop_view_rolls() {
	//Data structures for loop rolls
	ActorArray *rhytmical_sample_looper = get_actor_array_new();
	ActorArray *melodical_sample_looper = get_actor_array_new();
	ActorArray *harmonical_sample_looper = get_actor_array_new();
	ActorArray *effect_sample_looper = get_actor_array_new();

	ClutterActor *looper_container = clutter_group_new();

	rhytmical_sample_looper->roll_group = clutter_group_new();
	melodical_sample_looper->roll_group = clutter_group_new();
	harmonical_sample_looper->roll_group = clutter_group_new();
	effect_sample_looper->roll_group = clutter_group_new();

	ClutterActor *loop_mask = config_get_configured_actor("sequencer", "loop_container_mask");

	int i = 0;
	ClutterColor *orange = clutter_color_new(255, 150, 0, 255);
	ClutterColor *purple = clutter_color_new(255, 0, 255, 255);
	ClutterColor *green = clutter_color_new(0, 200, 0, 255);
	ClutterColor *red = clutter_color_new(255, 0, 0, 255);

	for(i = 0; i < 5; i++) {
		//rhytmical_roll_background[i] = config_get_configured_actor("sequencer", "loop_background_orange");
		rhytmical_sample_looper->roll_background[i] = clutter_rectangle_new_with_color(orange);
		//clutter_actor_set_name(rhytmical_sample_labels->roll_background[i], g_strdup_printf("%d", i));
		clutter_actor_set_size(rhytmical_sample_looper->roll_background[i], 95.0, 95.0);
		clutter_group_add(CLUTTER_GROUP(rhytmical_sample_looper->roll_group), CLUTTER_ACTOR(rhytmical_sample_looper->roll_background[i]));
		clutter_actor_set_position(rhytmical_sample_looper->roll_background[i], 0.0, i * 95.0);
	}
	ClutterActor *rhytmical_reactive = clutter_rectangle_new_with_color(clutter_color_new(0,0,0,0));
	g_signal_connect(CLUTTER_ACTOR(rhytmical_reactive), "button-press-event", G_CALLBACK(move_rolls), rhytmical_sample_looper);
	g_signal_connect(CLUTTER_ACTOR(rhytmical_reactive), "motion-event", G_CALLBACK(roll_loop), rhytmical_sample_looper);
	g_signal_connect(CLUTTER_ACTOR(rhytmical_reactive), "button-release-event", G_CALLBACK(stop_rolls), rhytmical_sample_looper);
	clutter_actor_set_reactive(rhytmical_reactive, TRUE);
	clutter_actor_set_size(rhytmical_reactive, 95.0, 3 * 95.0);
	clutter_group_add(CLUTTER_GROUP(rhytmical_sample_looper->roll_group), rhytmical_reactive);
	clutter_actor_set_position(rhytmical_reactive, 0.0, 95.0);
	add_actor_to_actor_array(rhytmical_sample_looper, config_get_configured_actor("sequencer", "wheel_number_0"));
	add_actor_to_actor_array(rhytmical_sample_looper, config_get_configured_actor("sequencer", "wheel_number_1"));
	add_actor_to_actor_array(rhytmical_sample_looper, config_get_configured_actor("sequencer", "wheel_number_2"));
	add_actor_to_actor_array(rhytmical_sample_looper, config_get_configured_actor("sequencer", "wheel_number_3"));

	for(i = 0; i < 5; i++) {
		//melodical_roll_background[i] = config_get_configured_actor("sequencer", "loop_background_purple");
		melodical_sample_looper->roll_background[i] = clutter_rectangle_new_with_color(purple);
		clutter_actor_set_size(melodical_sample_looper->roll_background[i], 95.0, 95.0);
		clutter_container_add_actor(CLUTTER_CONTAINER(melodical_sample_looper->roll_group), CLUTTER_ACTOR(melodical_sample_looper->roll_background[i]));
		clutter_actor_set_position(melodical_sample_looper->roll_background[i], 0.0, (i * 95.0));
	}
	ClutterActor *melodical_reactive = clutter_rectangle_new_with_color(clutter_color_new(0,0,0,0));
	g_signal_connect(CLUTTER_ACTOR(melodical_reactive), "button-press-event", G_CALLBACK(move_rolls), melodical_sample_looper);
	g_signal_connect(CLUTTER_ACTOR(melodical_reactive), "motion-event", G_CALLBACK(roll_loop), melodical_sample_looper);
	g_signal_connect(CLUTTER_ACTOR(melodical_reactive), "button-release-event", G_CALLBACK(stop_rolls), melodical_sample_looper);
	clutter_actor_set_reactive(melodical_reactive, TRUE);
	clutter_actor_set_size(melodical_reactive, 95.0, 3 * 95.0);
	clutter_group_add(CLUTTER_GROUP(melodical_sample_looper->roll_group), melodical_reactive);
	clutter_actor_set_position(melodical_reactive, 0.0, 95.0);

	for(i = 0; i < 5; i++) {
		harmonical_sample_looper->roll_background[i] = clutter_rectangle_new_with_color(red);
//				config_get_configured_actor("sequencer", "loop_background_red");
		clutter_actor_set_size(harmonical_sample_looper->roll_background[i], 95.0, 95.0);
		clutter_group_add(CLUTTER_GROUP(harmonical_sample_looper->roll_group), harmonical_sample_looper->roll_background[i]);
		clutter_actor_set_position(harmonical_sample_looper->roll_background[i], 0.0, (i * 95.0));
	}
	ClutterActor *harmonical_reactive = clutter_rectangle_new_with_color(clutter_color_new(0,0,0,0));
	g_signal_connect(CLUTTER_ACTOR(harmonical_reactive), "button-press-event", G_CALLBACK(move_rolls), harmonical_sample_looper);
	g_signal_connect(CLUTTER_ACTOR(harmonical_reactive), "motion-event", G_CALLBACK(roll_loop), harmonical_sample_looper);
	g_signal_connect(CLUTTER_ACTOR(harmonical_reactive), "button-release-event", G_CALLBACK(stop_rolls), harmonical_sample_looper);
	clutter_actor_set_reactive(harmonical_reactive, TRUE);
	clutter_actor_set_size(harmonical_reactive, 95.0, 3 * 95.0);
	clutter_group_add(CLUTTER_GROUP(harmonical_sample_looper->roll_group), harmonical_reactive);
	clutter_actor_set_position(harmonical_reactive, 0.0, 95.0);

	for(i = 0; i < 5; i++) {
		//effect_roll_background[i] = config_get_configured_actor("sequencer", "loop_background_green");
		effect_sample_looper->roll_background[i] = clutter_rectangle_new_with_color(green);
		clutter_actor_set_size(effect_sample_looper->roll_background[i], 95.0, 95.0);
		clutter_group_add(CLUTTER_GROUP(effect_sample_looper->roll_group), effect_sample_looper->roll_background[i]);
		clutter_actor_set_position(effect_sample_looper->roll_background[i], 0.0, (i * 95.0));
	}
	ClutterActor *effect_reactive = clutter_rectangle_new_with_color(clutter_color_new(0,0,0,0));
	g_signal_connect(CLUTTER_ACTOR(effect_reactive), "button-press-event", G_CALLBACK(move_rolls), effect_sample_looper);
	g_signal_connect(CLUTTER_ACTOR(effect_reactive), "motion-event", G_CALLBACK(roll_loop), effect_sample_looper);
	g_signal_connect(CLUTTER_ACTOR(effect_reactive), "button-release-event", G_CALLBACK(stop_rolls), effect_sample_looper);
	clutter_actor_set_reactive(effect_reactive, TRUE);
	clutter_actor_set_size(effect_reactive, 95.0, 3 * 95.0);
	clutter_group_add(CLUTTER_GROUP(effect_sample_looper->roll_group), effect_reactive);
	clutter_actor_set_position(effect_reactive, 0.0, 95.0);

	clutter_color_free(orange);
	clutter_color_free(purple);
	clutter_color_free(green);
	clutter_color_free(red);

	clutter_actor_set_reactive(loop_mask, FALSE);

	clutter_group_add(CLUTTER_GROUP(looper_container), rhytmical_sample_looper->roll_group);
	clutter_group_add(CLUTTER_GROUP(looper_container), melodical_sample_looper->roll_group);
	clutter_group_add(CLUTTER_GROUP(looper_container), harmonical_sample_looper->roll_group);
	clutter_group_add(CLUTTER_GROUP(looper_container), effect_sample_looper->roll_group);
	clutter_group_add(CLUTTER_GROUP(looper_container), loop_mask);

	clutter_actor_set_position(rhytmical_sample_looper->roll_group, 120.0, 2.0);
	clutter_actor_set_position(melodical_sample_looper->roll_group, 240.0, 2.0);
	clutter_actor_set_position(harmonical_sample_looper->roll_group, 360.0, 2.0);
	clutter_actor_set_position(effect_sample_looper->roll_group, 480.0, 2.0);
	return looper_container;
}

/*
 * Event for pressing sequencer view play button
 */
static gboolean pressed_sequencer_button_play(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	set_sequencer_state_play(NULL,NULL,NULL);
	//printf("Play-Button pressed\n");

	return TRUE;
}

/*
 * Event for pressing sequencer view play-stop button
 */
static gboolean pressed_sequencer_button_play_stop(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	//	g_signal_connect(anim, "completed", G_CALLBACK(set_sequencer_state_play_stop), NULL);
	set_sequencer_state_play_stop(NULL,NULL,NULL);

	//printf("Play-Button pressed\n");

	return TRUE;
}

static gboolean pressed_sequencer_button_home(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	ClutterAnimation *anim = clutter_actor_animate (actor,          /* the actor to animate */
			CLUTTER_LINEAR, /* the easing mode */
			100,           /* the duration of the animation */
			"scale-x", 0.80, /* final horizontal scaling factor */
			"scale-y", 0.80, /* final vertical scaling factor */
			"scale-gravity",CLUTTER_GRAVITY_CENTER,
			NULL);

	g_signal_connect(anim, "completed", G_CALLBACK(set_sequencer_state_return_home), NULL);

	return TRUE;
}

static gboolean pressed_sequencer_button_workshop(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	ClutterAnimation *anim = clutter_actor_animate (actor,          /* the actor to animate */
			CLUTTER_LINEAR, /* the easing mode */
			100,           /* the duration of the animation */
			"scale-x", 0.80, /* final horizontal scaling factor */
			"scale-y", 0.80, /* final vertical scaling factor */
			"scale-gravity",CLUTTER_GRAVITY_CENTER,
			NULL);

	g_signal_connect(anim, "completed", G_CALLBACK(set_sequencer_state_workshop), NULL);

	return TRUE;
}

static gboolean pressed_sequencer_button_mentor(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	ClutterAnimation *anim = clutter_actor_animate (actor,          /* the actor to animate */
			CLUTTER_LINEAR, /* the easing mode */
			100,           /* the duration of the animation */
			"scale-x", 0.80, /* final horizontal scaling factor */
			"scale-y", 0.80, /* final vertical scaling factor */
			"scale-gravity",CLUTTER_GRAVITY_CENTER,
			NULL);

	g_signal_connect(anim, "completed", G_CALLBACK(set_sequencer_state_mentor), NULL);

	return TRUE;
}

static gboolean pressed_sequencer_button_audio_record(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	set_sequencer_state_audio_record(NULL,NULL,NULL);

	return TRUE;
}

static gboolean pressed_sequencer_button_audio_record_stop(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	set_sequencer_state_audio_record_stop(NULL,NULL,NULL);

	return TRUE;
}


static gboolean pressed_sequencer_button_metronome(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	set_sequencer_state_metronome_on(NULL,NULL,NULL);

	return TRUE;
}

static gboolean pressed_sequencer_button_metronome_stop(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	set_sequencer_state_metronome_stop(NULL,NULL,NULL);

	return TRUE;
}

static gboolean pressed_sequencer_button_mute(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	int num = GPOINTER_TO_INT(data);
	//printf("pressed_sequencer_button_mute: %d\n",num);

	//ClutterShader *shade = clutter_shader_new();

	//if mute is off, set it on
	if (BUTTON_SEQUENCER_MUTE_STATES[num] == 0) {

		ClutterAnimation *anim = clutter_actor_animate (actor,          /* the actor to animate */
				CLUTTER_LINEAR, /* the easing mode */
				100,           /* the duration of the animation */
				"scale-x", 0.80, /* final horizontal scaling factor */
				"scale-y", 0.80, /* final vertical scaling factor */
				"scale-gravity",CLUTTER_GRAVITY_CENTER,
				NULL);

		g_signal_connect(anim, "completed", G_CALLBACK(set_sequencer_mute_on), GINT_TO_POINTER(num));
		//Shade button
		//clutter_actor_set_shader(actor,shade);
	}

	//if mute is on, set it off
	if (BUTTON_SEQUENCER_MUTE_STATES[num] == 1) {

		ClutterAnimation *anim = clutter_actor_animate (actor,          /* the actor to animate */
				CLUTTER_LINEAR, /* the easing mode */
				100,           /* the duration of the animation */
				"scale-x", 1.0, /* final horizontal scaling factor */
				"scale-y", 1.0, /* final vertical scaling factor */
				"scale-gravity",CLUTTER_GRAVITY_CENTER,
				NULL);

		g_signal_connect(anim, "completed", G_CALLBACK(set_sequencer_mute_off), NULL);
		//Shade button
		//clutter_actor_set_shader(actor,shade);

	}

	//Change mute state to opposite
	BUTTON_SEQUENCER_MUTE_STATES[num] = !BUTTON_SEQUENCER_MUTE_STATES[num];

	return TRUE;
}

static gboolean pressed_sequencer_button_volume(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	int num = GPOINTER_TO_INT(data);
	//printf("pressed_sequencer_button_volume: %d\n",num);

	//printf("last active %d\n",BUTTON_SEQUENCER_VOLUME_ACTIVE);
	//printf("now pressed %d\n",*num);

	//if selected button was in normal state (not pressed down)
	if (num != BUTTON_SEQUENCER_VOLUME_ACTIVE) {

		//release last active volume button
		if (BUTTON_SEQUENCER_VOLUME_ACTIVE >= 0) {
			/*ClutterAnimation *anim = */
			clutter_actor_animate (BUTTON_SEQUENCER_VOLUME[BUTTON_SEQUENCER_VOLUME_ACTIVE],          /* the actor to animate */
					CLUTTER_LINEAR, /* the easing mode */
					100,           /* the duration of the animation */
					"scale-x", 1.0, /* final horizontal scaling factor */
					"scale-y", 1.0, /* final vertical scaling factor */
					"scale-gravity",CLUTTER_GRAVITY_CENTER,
					NULL);
		}

		//Push selected volume button down
		/*ClutterAnimation *anim = */
		clutter_actor_animate (BUTTON_SEQUENCER_VOLUME[num],          /* the actor to animate */
				CLUTTER_LINEAR, /* the easing mode */
				100,           /* the duration of the animation */
				"scale-x", 0.80, /* final horizontal scaling factor */
				"scale-y", 0.80, /* final vertical scaling factor */
				"scale-gravity",CLUTTER_GRAVITY_CENTER,
				NULL);

		//Open volume slider next to selected button

		//set new active volume button
		BUTTON_SEQUENCER_VOLUME_ACTIVE = num;

	} else {


		//selected volume button was down - set it to normal state
		/*ClutterAnimation *anim = */
		clutter_actor_animate (BUTTON_SEQUENCER_VOLUME[num],          /* the actor to animate */
				CLUTTER_LINEAR, /* the easing mode */
				100,           /* the duration of the animation */
				"scale-x", 1.0, /* final horizontal scaling factor */
				"scale-y", 1.0, /* final vertical scaling factor */
				"scale-gravity",CLUTTER_GRAVITY_CENTER,
				NULL);
		BUTTON_SEQUENCER_VOLUME_ACTIVE = -1;
	}

	return TRUE;
}

JammoTexture *dragging = NULL;		     /*object which is currently dragged*/

static void object_pressed (JammoTexture *actor, ClutterEvent *event, gpointer data) {
	gfloat x_start_of_dragging_f,y_start_of_dragging_f;
	clutter_event_get_coords (event, &x_start_of_dragging_f, &y_start_of_dragging_f);

	x_start_of_dragging=(gint)x_start_of_dragging_f;
	y_start_of_dragging=(gint)y_start_of_dragging_f;

	dragging=actor;// puts the actor clicked to the dragging actor
	x_drag_offset = (clutter_actor_get_x (CLUTTER_ACTOR(dragging)) - (int)x_start_of_dragging);
	y_drag_offset = (clutter_actor_get_y (CLUTTER_ACTOR(dragging)) - (int)y_start_of_dragging);

	//even this object is not focused it still gets the mouse events
	clutter_grab_pointer(CLUTTER_ACTOR(actor));
}


//Game is designed to play with finger, so this should be high.
//#define CLICKING_THRESHOLD 30

static void object_released (JammoTexture *actor, ClutterEvent *event, gpointer data) {
	//Just to be sure.
	if (dragging == NULL){
		printf("dragging == NULL\n");
		return;
	}
	//If object are clicked but not moved, we play its sound
	//  gfloat x_release_f, y_release_f;
	//  clutter_event_get_coords (event, &x_release_f, &y_release_f);
	//  gint x_release=(gint)x_release_f;
	//  gint y_release=(gint)y_release_f;
	clutter_ungrab_pointer(); //ungrab
	dragging = NULL;

	gfloat actor_x = 0.0;
	gfloat actor_y = 0.0;

	clutter_actor_get_position (CLUTTER_ACTOR(actor), &actor_x, &actor_y);

	ClutterRectangle** switch_positions = NULL;
	G_CONST_RETURN gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(actor));
	if (name != NULL)
	{
		if (strcmp( name, "tempo_switch_button") == 0)
		{
			switch_positions = tempo_switch_positions;
		}
		else if ( strcmp( name, "pitch_switch_button") == 0)
		{
			switch_positions = pitch_switch_positions;
		}
		else
		{
			// error, fail?
		}
	}
	else
	{
		// couldn't get name, fail?
	}


	gfloat distance = 0.0;
	gint i = 0;
	gint found = -1;
	for (i = 0; i < 3; i++) //magic switch position count
	{
		gfloat position_x = 0.0;
		gfloat position_y = 0.0;
		clutter_actor_get_position (CLUTTER_ACTOR(switch_positions[i]), &position_x, &position_y);
		if (fabs(position_y - actor_y) < distance || found == -1)
		{
			found = i;
			distance = fabs(position_y - actor_y);
		}
	}
	if (found != -1)
	{
		gfloat position_x = 0.0;
		gfloat position_y = 0.0;
		clutter_actor_get_position (CLUTTER_ACTOR(switch_positions[found]), &position_x, &position_y);
		//		clutter_actor_set_position (CLUTTER_ACTOR(actor), position_x, position_y);

		ClutterAnimation *anim = clutter_actor_animate(CLUTTER_ACTOR(actor),
				CLUTTER_EASE_IN_OUT_CUBIC, 200, "x", position_x, "y", position_y, NULL);
	}
}

static void motion_on_object(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	gfloat x_mouse_position_f, y_mouse_position_f;
	if (CLUTTER_IS_ACTOR(dragging) && dragging != NULL) {
		clutter_event_get_coords (event,&x_mouse_position_f, &y_mouse_position_f);
		//printf("X=%f, Y=%f\n",x_mouse_position, y_mouse_position);
		gint new_x, new_y;
		gint x_mouse_position=(gint)x_mouse_position_f;
		gint y_mouse_position=(gint)y_mouse_position_f;
		new_x=x_mouse_position + x_drag_offset;
		new_y=y_mouse_position + y_drag_offset;

		ClutterRectangle* switch_area = NULL;
		G_CONST_RETURN gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(actor));
		if (name != NULL)
		{
			if (strcmp( name, "tempo_switch_button") == 0)
			{
				switch_area = tempo_switch_area;
			}
			else if ( strcmp( name, "pitch_switch_button") == 0)
			{
				switch_area = pitch_switch_area;
			}
			else
			{
				// error, fail?
			}
		}
		else
		{
			// couldn't get name, fail?
		}

		gfloat area_x = 0;
		gfloat area_y = 0;
		gfloat area_width = 0;
		gfloat area_height = 0;

		clutter_actor_get_position (CLUTTER_ACTOR(switch_area), &area_x, &area_y);
		clutter_actor_get_size (CLUTTER_ACTOR(switch_area), &area_width, &area_height);
		if (new_x > area_x)
			new_x = area_x;
		else if (new_x < area_x)
			new_x = area_x;
		if (new_y > area_y+area_height)
			new_y = area_y+area_height;
		else if (new_y < area_y)
			new_y = area_y;
		clutter_actor_set_position (CLUTTER_ACTOR(dragging), new_x, new_y);
	}
}

/*  gfloat x_release_f, y_release_f;
  clutter_event_get_coords (event, &x_release_f, &y_release_f);
  gint x_release=(gint)x_release_f;
  gint y_release=(gint)y_release_f;
 *//*
  clutter_ungrab_pointer(); //ungrab
  is_dragging = FALSE;*/

/*static void add_object_to_group(ClutterActor* group,ClutterActor* actor){
    clutter_container_add_actor(CLUTTER_CONTAINER(group), actor);
    clutter_actor_set_reactive(actor, TRUE);
    g_signal_connect (actor, "button-press-event", G_CALLBACK (object_pressed), NULL);
    g_signal_connect (actor, "button-release-event", G_CALLBACK (object_released), NULL);
    g_signal_connect (actor, "motion-event", G_CALLBACK (motion_on_object), NULL);
}*/

ClutterActor *joo;

void start_sequencer()
{
	glong timeout = 10000000;
	while(!sequencer_is_initialized() )//&& timeout > 0)
	{
		g_usleep(1000000);
		timeout -= 1000000;
	}
	if (timeout <= 0)
	{
		printf("Sequencer initialization timed out\n");
	//	return;
	}
	clutter_actor_show (CLUTTER_ACTOR(sequencer_group));
}

void init_sequencer() {
	sequencer_is_ready = FALSE;
	ClutterActor* stage = main_getStage();
	sequencer_group = clutter_group_new();
	clutter_actor_hide(CLUTTER_ACTOR(sequencer_group));
	ClutterActor *sequencer_background;
	//Buttons for sequencer scrolling

	ClutterActor *sequencer_view = config_get_configured_actor("sequencer", "sequencer_view");
	ClutterActor *loop_button_down = config_get_configured_actor("sequencer", "loop_button_down");
	ClutterActor *sequencer_button_down = config_get_configured_actor("sequencer", "sequencer_button_down");
	ClutterActor *sequencer_button_up = config_get_configured_actor("sequencer", "sequencer_button_up");
	ClutterActor *general_button_up = config_get_configured_actor("sequencer", "general_button_up");
	ClutterActor *loop_view = config_get_configured_actor("sequencer", "loop_view");

	ClutterActor *general_container = clutter_group_new();
	create_general_container(general_container);

	//Sequencer view - buttons
	ClutterActor *sequencer_button_play = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_play");
	ClutterActor *sequencer_button_play_stop = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_play_stop");
	ClutterActor *sequencer_button_home = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_home");
	ClutterActor *sequencer_button_workshop = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_workshop");
	ClutterActor *sequencer_button_mentor = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_mentor");
	ClutterActor *sequencer_button_audio_record = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_audio_record");
	ClutterActor *sequencer_button_metronome = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_metronome");
	ClutterActor *sequencer_button_audio_record_stop = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_audio_record_stop");
	ClutterActor *sequencer_button_metronome_stop = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_metronome_stop");

	//Mute buttons
	BUTTON_SEQUENCER_MUTE[0] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_mute_1");
	BUTTON_SEQUENCER_MUTE[1] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_mute_2");
	BUTTON_SEQUENCER_MUTE[2] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_mute_3");
	BUTTON_SEQUENCER_MUTE[3] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_mute_4");
	BUTTON_SEQUENCER_MUTE[4] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_mute_5");
	BUTTON_SEQUENCER_MUTE[5] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_mute_6");

	//Volume buttons
	BUTTON_SEQUENCER_VOLUME[0] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_volume_1");
	BUTTON_SEQUENCER_VOLUME[1] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_volume_2");
	BUTTON_SEQUENCER_VOLUME[2] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_volume_3");
	BUTTON_SEQUENCER_VOLUME[3] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_volume_4");
	BUTTON_SEQUENCER_VOLUME[4] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_volume_5");
	BUTTON_SEQUENCER_VOLUME[5] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_volume_6");


	sequencer_background = config_get_configured_actor("sequencer","sequencer_bg"); //background

	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), sequencer_background);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), sequencer_view);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), create_loop_view_rolls());
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), loop_view);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), loop_button_down);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), sequencer_button_up);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), sequencer_button_down);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), general_button_up);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), general_container);


	//  add_object_to_group(tempo_group, tempo_switch);
	//  add_object_to_group(pitch_group, pitch_switch);

	//  clutter_actor_show (CLUTTER_ACTOR(tempo_group));

	//  clutter_container_add_actor(CLUTTER_CONTAINER(pitch_group), pitch_bg);

	//  clutter_actor_show (CLUTTER_ACTOR(pitch_group));
	clutter_actor_set_rotation(loop_button_down, CLUTTER_Z_AXIS, 180, 0, 0, 0);
	//clutter_actor_set_rotation(sequencer_button_up, CLUTTER_Z_AXIS, 270, 0, 0, 0);
	clutter_actor_set_rotation(sequencer_button_down, CLUTTER_Z_AXIS, 180, 0, 0, 0);
	//clutter_actor_set_rotation(general_button_up, CLUTTER_Z_AXIS, 0, 0, 0, 0);

	g_signal_connect(CLUTTER_ACTOR(loop_button_down), "button_press_event", G_CALLBACK(change_sequencer_view), NULL);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_down), "button_press_event", G_CALLBACK(change_general_view), NULL);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_up), "button_press_event", G_CALLBACK(change_loop_view), NULL);
	g_signal_connect(CLUTTER_ACTOR(general_button_up), "button_press_event", G_CALLBACK(change_sequencer_view), NULL);

	//Sequencer view buttons - function bindings
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_play), "button_press_event", G_CALLBACK(pressed_sequencer_button_play), NULL);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_play_stop), "button_press_event", G_CALLBACK(pressed_sequencer_button_play_stop), NULL);
	clutter_actor_hide (sequencer_button_play_stop);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_home), "button_press_event", G_CALLBACK(pressed_sequencer_button_home), NULL);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_workshop), "button_press_event", G_CALLBACK(pressed_sequencer_button_workshop), NULL);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_mentor), "button_press_event", G_CALLBACK(pressed_sequencer_button_mentor), NULL);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_audio_record), "button_press_event", G_CALLBACK(pressed_sequencer_button_audio_record), NULL);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_metronome), "button_press_event", G_CALLBACK(pressed_sequencer_button_metronome), NULL);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_audio_record_stop), "button_press_event", G_CALLBACK(pressed_sequencer_button_audio_record_stop), NULL);
	clutter_actor_hide (sequencer_button_audio_record_stop);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_metronome_stop), "button_press_event", G_CALLBACK(pressed_sequencer_button_metronome_stop), NULL);
	clutter_actor_hide (sequencer_button_metronome_stop);

	int *button_number = malloc(sizeof(int));
	int i;

	for (i=0; i<6; i++) {
		*button_number = i;
		g_signal_connect(CLUTTER_ACTOR(BUTTON_SEQUENCER_MUTE[i]), "button_press_event", G_CALLBACK(pressed_sequencer_button_mute), button_number);
		g_signal_connect(CLUTTER_ACTOR(BUTTON_SEQUENCER_VOLUME[i]), "button_press_event", G_CALLBACK(pressed_sequencer_button_volume), button_number);
	}

	BUTTON_SEQUENCER_PLAY = sequencer_button_play;
	BUTTON_SEQUENCER_PLAY_STOP = sequencer_button_play_stop;
	BUTTON_SEQUENCER_HOME = sequencer_button_home;
	BUTTON_SEQUENCER_WORKSHOP = sequencer_button_workshop;
	BUTTON_SEQUENCER_MENTOR = sequencer_button_mentor;
	BUTTON_SEQUENCER_AUDIO_RECORD = sequencer_button_audio_record;
	BUTTON_SEQUENCER_METRONOME = sequencer_button_metronome;
	BUTTON_SEQUENCER_AUDIO_RECORD_STOP = sequencer_button_audio_record_stop;
	BUTTON_SEQUENCER_METRONOME_STOP = sequencer_button_metronome_stop;

	/*
  clutter_actor_set_anchor_point(loop_button_down, 42, 50);
  clutter_actor_set_anchor_point(sequencer_button_up, 42, 50);
  clutter_actor_set_anchor_point(sequencer_button_down, 42, 50);
  clutter_actor_set_anchor_point(general_button_up, 42, 5sequencer_button_play_stop0);

  clutter_actor_set_position(loop_view, 0.0, 0.0);
  clutter_actor_set_position(sequencer_view, 0.0, 480.0); //-480.0
  clutter_actor_set_position(loop_button_down, 700, 420);
  clutter_actor_set_position(sequencer_button_up, 700, 520);
  clutter_actor_set_position(sequencer_button_down, 700, 920);
  clutter_actor_set_position(general_button_up, 700, 1000);
	 */
	//  clutter_actor_show_all (CLUTTER_ACTOR(general_container));
	//  clutter_actor_set_reactive(CLUTTER_ACTOR(general_container), TRUE);
	clutter_actor_set_size (CLUTTER_ACTOR(general_container), 800, 480);
	clutter_actor_set_position (CLUTTER_ACTOR(general_container), 0, 960);

	clutter_container_add_actor (CLUTTER_CONTAINER (stage), CLUTTER_ACTOR(sequencer_group));

	clutter_actor_set_reactive(CLUTTER_ACTOR(sequencer_group), TRUE);
	clutter_actor_set_reactive(loop_button_down, TRUE);
	clutter_actor_set_reactive(sequencer_button_down, TRUE);
	clutter_actor_set_reactive(sequencer_button_up, TRUE);
	clutter_actor_set_reactive(general_button_up, TRUE);

	//Sequencer view buttons - setting buttons reactive
	clutter_actor_set_reactive(sequencer_button_play, TRUE);
	clutter_actor_set_reactive(sequencer_button_play_stop, TRUE);
	clutter_actor_set_reactive(sequencer_button_home, TRUE);
	clutter_actor_set_reactive(sequencer_button_workshop, TRUE);
	clutter_actor_set_reactive(sequencer_button_mentor, TRUE);
	clutter_actor_set_reactive(sequencer_button_audio_record, TRUE);
	clutter_actor_set_reactive(sequencer_button_metronome, TRUE);
	clutter_actor_set_reactive(sequencer_button_audio_record_stop, TRUE);
	clutter_actor_set_reactive(sequencer_button_metronome_stop, TRUE);
	for (i=0; i<6; i++) clutter_actor_set_reactive(BUTTON_SEQUENCER_MUTE[i], TRUE);
	for (i=0; i<6; i++) clutter_actor_set_reactive(BUTTON_SEQUENCER_VOLUME[i], TRUE);

	clutter_actor_set_position (sequencer_group, 0.0, -480.0);

	/*  g_signal_connect (grid, "button-release-event", G_CALLBACK (grid_released), NULL);
  g_signal_connect (grid, "motion-event", G_CALLBACK (grid_motion), NULL);
  g_signal_connect (grid, "button-press-event", G_CALLBACK (grid_press),NULL);*/


	//stencil will be all other buttons and elements in editor
	/*
  ClutterActor* stencil=clutter_rectangle_new_with_color (get_transparency_color());
  clutter_actor_set_size (stencil, 800, 480);
  clutter_actor_set_position (stencil, 0, 0);
  clutter_rectangle_set_border_color(CLUTTER_RECTANGLE(stencil),get_blue_color());
  clutter_rectangle_set_border_width(CLUTTER_RECTANGLE(stencil),50);
  clutter_actor_show (stencil);
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), stencil);
	 */
	//clutter_actor_raise_top (actor);
	printf("Sequencer initialization complete!\n");
	sequencer_is_ready = TRUE;
}

gboolean sequencer_is_initialized()
{
	return sequencer_is_ready;
}

static void create_general_container(ClutterActor* general_container)
{
	// "grid" might be cluttergroup and contains grid and notes and so on.
	//	  ClutterActor *general_bg = config_get_configured_actor("sequencer","loop_background");
	ClutterActor *tempo_group = config_get_configured_actor("sequencer","tempo_switch_group");
	ClutterActor *pitch_group = config_get_configured_actor("sequencer","pitch_switch_group");
	//  ClutterActor *tempo_bg = config_get_configured_actor("sequencer","tempo_background");
	//  ClutterActor *pitch_bg = config_get_configured_actor("sequencer","pitch_background");
	//  ClutterActor *tempo_switch = config_get_configured_actor("sequencer","tempo_switch");
	//  ClutterActor *pitch_switch = config_get_configured_actor("sequencer","pitch_switch");
	ClutterActor *tempo_switch = NULL;
	ClutterActor *pitch_switch = NULL;

	ClutterActor *temp = NULL;
	temp = config_get_configured_actor("sequencer","tempo_fast");
	clutter_container_add_actor (CLUTTER_CONTAINER (general_container), CLUTTER_ACTOR(temp));
	temp = config_get_configured_actor("sequencer","tempo_slow");
	clutter_container_add_actor (CLUTTER_CONTAINER (general_container), CLUTTER_ACTOR(temp));
	temp = config_get_configured_actor("sequencer","pitch_high");
	clutter_container_add_actor (CLUTTER_CONTAINER (general_container), CLUTTER_ACTOR(temp));
	temp = config_get_configured_actor("sequencer","pitch_low");
	clutter_container_add_actor (CLUTTER_CONTAINER (general_container), CLUTTER_ACTOR(temp));
	temp = config_get_configured_actor("sequencer","make_record_button");
	clutter_container_add_actor (CLUTTER_CONTAINER (general_container), CLUTTER_ACTOR(temp));
	temp = config_get_configured_actor("sequencer","sequencer_general_button_mentor");
	clutter_container_add_actor (CLUTTER_CONTAINER (general_container), CLUTTER_ACTOR(temp));

	tempo_switch_positions[0] = (ClutterRectangle*)clutter_container_find_child_by_name(CLUTTER_CONTAINER(tempo_group), "switch_position_0");
	tempo_switch_positions[1] = (ClutterRectangle*)clutter_container_find_child_by_name(CLUTTER_CONTAINER(tempo_group), "switch_position_1");
	tempo_switch_positions[2] = (ClutterRectangle*)clutter_container_find_child_by_name(CLUTTER_CONTAINER(tempo_group), "switch_position_2");
	tempo_switch_area = (ClutterRectangle*)clutter_container_find_child_by_name(CLUTTER_CONTAINER(tempo_group), "switch_area");
	tempo_switch = clutter_container_find_child_by_name(CLUTTER_CONTAINER(tempo_group), "tempo_switch_button");

	clutter_actor_set_reactive(tempo_switch, TRUE);
	g_signal_connect (tempo_switch, "button-press-event", G_CALLBACK (object_pressed), NULL);
	g_signal_connect (tempo_switch, "button-release-event", G_CALLBACK (object_released), NULL);
	g_signal_connect (tempo_switch, "motion-event", G_CALLBACK (motion_on_object), NULL);

	//  tempo_switch_positions[0] = (ClutterRectangle*)config_get_configured_actor("sequencer","tempo_switch_position_0");
	//  tempo_switch_positions[1] = (ClutterRectangle*)config_get_configured_actor("sequencer","tempo_switch_position_1");
	//  tempo_switch_positions[2] = (ClutterRectangle*)config_get_configured_actor("sequencer","tempo_switch_position_2");
	//  tempo_switch_area = (ClutterRectangle*)config_get_configured_actor("sequencer","tempo_switch_area");
	pitch_switch_positions[0] = (ClutterRectangle*)clutter_container_find_child_by_name(CLUTTER_CONTAINER(pitch_group), "switch_position_0");
	pitch_switch_positions[1] = (ClutterRectangle*)clutter_container_find_child_by_name(CLUTTER_CONTAINER(pitch_group), "switch_position_1");
	pitch_switch_positions[2] = (ClutterRectangle*)clutter_container_find_child_by_name(CLUTTER_CONTAINER(pitch_group), "switch_position_2");
	pitch_switch_area = (ClutterRectangle*)clutter_container_find_child_by_name(CLUTTER_CONTAINER(pitch_group), "switch_area");
	pitch_switch = clutter_container_find_child_by_name(CLUTTER_CONTAINER(pitch_group), "pitch_switch_button");
	//  pitch_switch_positions[1] = (ClutterRectangle*)config_get_configured_actor("sequencer","pitch_switch_position_1");
	//  pitch_switch_positions[2] = (ClutterRectangle*)config_get_configured_actor("sequencer","pitch_switch_position_2");
	//  pitch_switch_area = (ClutterRectangle*)config_get_configured_actor("sequencer","pitch_switch_area");
	clutter_actor_set_reactive(pitch_switch, TRUE);
	g_signal_connect (pitch_switch, "button-press-event", G_CALLBACK (object_pressed), NULL);
	g_signal_connect (pitch_switch, "button-release-event", G_CALLBACK (object_released), NULL);
	g_signal_connect (pitch_switch, "motion-event", G_CALLBACK (motion_on_object), NULL);

	//	  clutter_container_add_actor (CLUTTER_CONTAINER (stage), CLUTTER_ACTOR(general_container));
	//	  clutter_container_add_actor (CLUTTER_CONTAINER (general_container), CLUTTER_ACTOR(general_bg));

	clutter_container_add_actor(CLUTTER_CONTAINER(general_container), tempo_group);
	clutter_container_add_actor(CLUTTER_CONTAINER(general_container), pitch_group);
	//	  clutter_actor_show_all(tempo_group);
	//	  clutter_actor_show_all(pitch_group);

	//  clutter_container_add_actor(CLUTTER_CONTAINER(tempo_group), tempo_bg);
	//  clutter_container_add_actor(CLUTTER_CONTAINER(pitch_group), pitch_bg);
	//  clutter_actor_show (CLUTTER_ACTOR(tempo_bg));
	//  clutter_actor_show (CLUTTER_ACTOR(pitch_bg));

}
