#!/bin/sh
if [ $# = 0 ];
 then
 exit 0
fi

echo Compiling $1-plugin

#if we are using 64bit system we need -fPIC
CHECK64=`uname -m|grep x86_64|wc -l`
if [ "$CHECK64" -eq "1" ];
  then
  fPIC=" -fPIC " 
fi

#2009-10-05: Autobuilder for extras-devel doesn't handle this, so maybe we can live without -Wvla
#compiler of scratchbox2 doesn't have -Wvla flag, so do not add if uname is arm
#CHECK_ARM=`uname -m|grep armv5tel|wc -l`
#if [ "$CHECK_ARM" -eq "0" ];
#  then
#  Wvla=" -Wvla " 
#fi

#this is our target directory
mkdir libs 2> /dev/null
echo "{ global:" > libs/libgstjammo$1.ver
echo "gst_plugin_desc;" >> libs/libgstjammo$1.ver
echo "local: *; };" >> libs/libgstjammo$1.ver


cd "$1-plugin" && gcc -pthread -I/usr/include/gstreamer-0.10 -I/usr/include/glib-2.0 -I/usr/lib/glib-2.0/include -I/usr/include/libxml2 -Wall $Wvla -g -O2 -c -o "libgstjammo$1.o" "gstjammo$1.c" $fPIC

gcc -shared "libgstjammo$1.o"   /usr/lib/libgstbase-0.10.so -L/usr/lib /usr/lib/libgstcontroller-0.10.so /usr/lib/libgstreamer-0.10.so -ldl /usr/lib/libgobject-2.0.so /usr/lib/libgmodule-2.0.so /usr/lib/libgthread-2.0.so -lrt /usr/lib/libxml2.so /usr/lib/libglib-2.0.so -lm  -pthread -Wl,-soname -Wl,libgstjammo$1.so -Wl,-version-script -Wl,../libs/libgstjammo$1.ver -o ../libs/libgstjammo$1.so
