/*
 * jammo.c (=> main.c)
 *
 * This file is part of JamMo.
 *
 * (c) 2009 University of Oulu
 *
 * Authors: Henrik Hedberg <henrik.hedberg@oulu.fi>
 */

#include "jammo-chum.h"
#include "../meam/jammo-meam.h"
#include "tangle-viewer.h"

/*
 * Note! You need Tangle Toolkit that is available here:
 *
 * http://gitorious.org/tangle
 *
 * To compile:
 * - gcc -rdynamic -o jammo jammo.c jammo-*.c $(pkg-config --cflags --libs clutter-1.0 tangle) ../meam/libmeam.a
 *
 * Note that -rdynamic is important in order to dynamic signal handler binding to work!
 */

static TangleViewer* viewer;

void change_view(TangleView* view) {
	g_print("Change view\n");
	tangle_viewer_activate_view(viewer, view);
}	

int main(int argc, char** argv) {
	GError* error = NULL;
	
	jammo_meam_init(&argc, &argv);
	jammo_chum_init(&argc, &argv);

	viewer = tangle_viewer_get_default();
	tangle_viewer_load_script_from_file(viewer, "test.json");
	tangle_viewer_show_stage(viewer);
	tangle_viewer_activate_view_by_name(viewer, "main");
	
	clutter_main();

	return 0;
}
