/*
 * jammo-instrument-track.h
 *
 * This file is part of JamMo.
 *
 * (c) 2009 University of Oulu
 *
 * Authors: Aapo Rantalainen
 */
 
#ifndef __JAMMO_INSTRUMENT_TRACK_H__
#define __JAMMO_INSTRUMENT_TRACK_H__

#include <glib.h>
#include <glib-object.h>
#include "jammo-track.h"

#define JAMMO_TYPE_INSTRUMENT_TRACK (jammo_instrument_track_get_type ())
#define JAMMO_INSTRUMENT_TRACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), JAMMO_TYPE_INSTRUMENT_TRACK, JammoInstrumentTrack))
#define JAMMO_IS_INSTRUMENT_TRACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), JAMMO_TYPE_INSTRUMENT_GTRACK))
#define JAMMO_INSTRUMENT_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), JAMMO_TYPE_INSTRUMENT_TRACK, JammoInstrumentTrackClass))
#define JAMMO_IS_INSTRUMENT_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), JAMMO_TYPE_INSTRUMENT_TRACK))
#define JAMMO_INSTRUMENT_TRACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), JAMMO_TYPE_INSTRUMENT_TRACK, JammoInstrumentTrackClass))

typedef struct _JammoInstrumentTrackPrivate JammoInstrumentTrackPrivate;

typedef struct _JammoInstrumentTrack {
	JammoTrack parent_instance;
	JammoInstrumentTrackPrivate* priv;
} JammoInstrumentTrack;

typedef struct _JammoInstrumentTrackClass {
	JammoTrackClass parent_class;
} JammoInstrumentTrackClass;

GType jammo_instrument_track_get_type(void);

typedef enum {
		JAMMO_INSTRUMENT_TYPE_FLUTE,
		JAMMO_INSTRUMENT_TYPE_DRUMKIT,
		JAMMO_INSTRUMENT_TYPE_UD,
		JAMMO_INSTRUMENT_TYPE_SLIDER,
		JAMMO_INSTRUMENT_TYPE_DUMMY, //Keep this last
} JammoInstrumentType;
JammoInstrumentTrack* jammo_instrument_track_new(JammoInstrumentType instrument_type);

void jammo_instrument_track_set_note(JammoInstrumentTrack* instrument_track,char note, int octave);
void jammo_instrument_track_set_slider_frequency(JammoInstrumentTrack* instrument_track,int a);
void jammo_instrument_track_set_slider_state(JammoInstrumentTrack* instrument_track,gboolean b);

#endif
