/**main_menu.c is part of JamMo.
License: GPLv2, read more from COPYING

This is game selection screen.
*/

//#include <gtk/gtk.h>
#include <clutter/clutter.h>
#include "config.h"

#include "clutter_jammo.h"
#include "../chum/chum.h"
#include "preloader.h"

//Games
#include "composing_game.h"
#include "singing_game.h"
#include "instrument_testing.h" //For testing virtual instruments (and slider)


ClutterActor *house;                    /* Background image */
ClutterActor *select_singing;           /* Button for singing game */
ClutterActor *select_composing;         /* Button for composing game */
ClutterActor *select_loading;           /* Button for cupboard (loaded songs) */
ClutterActor *select_ud;                /* Button for testing ud */
ClutterActor *select_drum;              /* Button for testing drum */
ClutterActor *select_flute;             /* Button for testing flute */
ClutterActor *select_slider;            /* Button for testing slider */
ClutterActor *quit;                     /* Button for ending JamMo */
ClutterActor *easy_advanced;            /* Button for choosing easy VS advance */
ClutterActor *choose_easy;
ClutterActor *choose_advanced;

ClutterActor *mentor; /*For mentor*/
ClutterActor *quit_confirmation; /*Are you sure you want quit -button*/
ClutterActor *quit_cancel;       /*Are you sure you want quit -button*/

static void easy_advanced_callback();
static void quit_confirmed(){
   printf("quit confirmed\n");
   window_closed();
}

static void quit_canceled(){
   printf("quit canceled\n");
   clutter_actor_hide(quit_confirmation);
   clutter_actor_hide(quit_cancel);
}
static void quit_pressed(){
   clutter_actor_set_reactive(quit_confirmation,TRUE);
   clutter_actor_raise_top (quit_confirmation);
   clutter_actor_show(quit_confirmation);
   g_signal_connect (quit_confirmation, "button-release-event", G_CALLBACK (quit_confirmed),NULL);
 
   clutter_actor_set_reactive(quit_cancel,TRUE);
   clutter_actor_raise_top (quit_cancel);
   clutter_actor_show(quit_cancel);
   g_signal_connect (quit_cancel, "button-release-event", G_CALLBACK (quit_canceled),NULL);
}

static void compose_clicked(){
  chum_go_screen(SCREEN_THEME_SELECTION);
}


static void loading_clicked(){
  printf("cupboard clicked");
  //chum_go_screen();
}

static void singing_clicked(){
  clutter_actor_set_reactive(select_singing, FALSE);
  clutter_actor_set_reactive(select_composing, FALSE);
  clutter_actor_set_reactive(select_ud, FALSE);
  clutter_actor_set_reactive(select_drum, FALSE); 
  clutter_actor_set_reactive(select_flute, FALSE);
  clutter_actor_set_reactive(select_slider, FALSE);
  chum_go_screen(SCREEN_SONG_SELECTION);
}

static void easy_advanced_chosen(ClutterTexture *actor, ClutterEvent *event, gpointer data){
  int i = GPOINTER_TO_INT(data);
  g_print("pressed easy_advanced number: %d \n", i);
  //Hide all language buttons
  clutter_actor_hide (choose_easy);
  clutter_actor_hide (choose_advanced);

  gchar* filepath1;
  if (i==1) { //easy pressed
    filepath1 = g_strdup_printf("%s/easy_icon.png", DATA_DIR);
  }
  else  {//advanced
    filepath1 = g_strdup_printf("%s/advanced_icon.png", DATA_DIR);
  }
  clutter_texture_set_from_file (CLUTTER_TEXTURE (easy_advanced), filepath1, NULL);

}


static void easy_advanced_callback(){
  clutter_actor_raise_top (choose_easy);
  clutter_actor_show (choose_easy);
  clutter_actor_set_reactive(choose_easy, TRUE);
  g_signal_connect (choose_easy, "button-press-event", G_CALLBACK (easy_advanced_chosen),GINT_TO_POINTER(1));

  clutter_actor_raise_top (choose_advanced);
  clutter_actor_show (choose_advanced);
  clutter_actor_set_reactive(choose_advanced, TRUE);
  g_signal_connect (choose_advanced, "button-press-event", G_CALLBACK (easy_advanced_chosen),GINT_TO_POINTER(2));

}

#include "../meam/jammo-instrument-track.h" //because of INSTRUMENT_TYPES
static void init_actors() {
   ClutterActor* stage = main_getStage();

   house = config_get_configured_actor(NULL,"house");
   clutter_actor_set_name(house, "house");
   clutter_actor_hide (house);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), house);

   select_singing = config_get_configured_actor(NULL,"select_singing");
   clutter_actor_set_name(select_singing, "select_singing");
   clutter_actor_set_reactive(select_singing, TRUE);
   g_signal_connect (select_singing, "button-press-event", G_CALLBACK (singing_clicked),NULL);
   clutter_actor_hide (select_singing);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), select_singing);

   select_composing = config_get_configured_actor(NULL,"select_composing");
   clutter_actor_set_name(select_composing, "select_composing");
   clutter_actor_set_reactive(select_composing, TRUE);
   g_signal_connect (select_composing, "button-press-event", G_CALLBACK (compose_clicked),NULL); 
   clutter_actor_hide (select_composing);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), select_composing);

   select_loading = config_get_configured_actor(NULL,"select_loading");
   clutter_actor_set_name(select_composing, "select_loading");
   clutter_actor_set_reactive(select_loading, TRUE);
   g_signal_connect (select_loading, "button-press-event", G_CALLBACK (loading_clicked),NULL); 
   clutter_actor_hide (select_loading);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), select_loading);

   select_ud = config_get_configured_actor(NULL,"select_ud");
   clutter_actor_set_name(select_ud, "select_ud");
   clutter_actor_set_reactive(select_ud, TRUE);
   g_signal_connect (select_ud, "button-press-event", G_CALLBACK (start_test_instrument),GINT_TO_POINTER(JAMMO_INSTRUMENT_TYPE_UD));
   clutter_actor_hide (select_ud);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), select_ud);

   select_drum = config_get_configured_actor(NULL,"select_drum");
   clutter_actor_set_name(select_drum, "select_drum");
   clutter_actor_set_reactive(select_drum, TRUE);
   g_signal_connect (select_drum, "button-press-event", G_CALLBACK (start_test_instrument),GINT_TO_POINTER(JAMMO_INSTRUMENT_TYPE_DRUMKIT));
   clutter_actor_hide (select_drum);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), select_drum);

   select_flute = config_get_configured_actor(NULL,"select_flute");
   clutter_actor_set_name(select_flute, "select_flute");
   clutter_actor_set_reactive(select_flute, TRUE);
   g_signal_connect (select_flute, "button-press-event", G_CALLBACK (start_test_instrument),GINT_TO_POINTER(JAMMO_INSTRUMENT_TYPE_FLUTE));
   clutter_actor_hide (select_flute);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), select_flute);

   quit = config_get_configured_actor(NULL,"quit-button");
   clutter_actor_set_name(quit, "quit");
   clutter_actor_set_reactive(quit, TRUE);
   g_signal_connect (quit, "button-press-event", G_CALLBACK (quit_pressed),NULL);
   clutter_actor_hide (quit);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), quit);

   quit_confirmation = config_get_configured_actor(NULL,"quit-confirmation-button");
   clutter_actor_set_name(quit_confirmation, "quit_confirmation");
   clutter_actor_hide (quit_confirmation);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), quit_confirmation);

   quit_cancel = config_get_configured_actor(NULL,"quit-cancel-button");
   clutter_actor_set_name(quit_cancel, "quit_cancel");
   clutter_actor_hide (quit_cancel);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), quit_cancel);

   mentor = config_get_configured_actor(NULL,"button-2"); //this is mentor/help button FIXME:name
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), mentor);
   clutter_actor_hide (mentor);

   easy_advanced = config_get_configured_actor(NULL,"easy_advanced"); 
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), easy_advanced);
   clutter_actor_hide (easy_advanced);
   clutter_actor_set_reactive(easy_advanced, TRUE);
   g_signal_connect (easy_advanced, "button-press-event", G_CALLBACK (easy_advanced_callback),NULL);

   choose_easy = config_get_configured_actor(NULL,"easy"); 
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), choose_easy);
   clutter_actor_hide (choose_easy);
   choose_advanced = config_get_configured_actor(NULL,"advanced"); 
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), choose_advanced);
   clutter_actor_hide (choose_advanced);

   select_slider = config_get_configured_actor(NULL,"select_slider");
   clutter_actor_set_name(select_slider, "select_slider");
   clutter_actor_set_reactive(select_slider, TRUE);
   g_signal_connect (select_slider, "button-press-event", G_CALLBACK (start_slider),GINT_TO_POINTER(JAMMO_INSTRUMENT_TYPE_SLIDER));
   clutter_actor_hide (select_slider);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), select_slider);

}

gboolean main_menu_is_initialized() {
    return (select_slider != NULL); //Last initialized actor.
}

void show_game_selection() {

  if (!main_menu_is_initialized())
      preloader_init_this(SCREEN_GAME_SELECTION);

  clutter_actor_raise_top(house);
  clutter_actor_raise_top(select_singing);
  clutter_actor_raise_top(select_composing);
  clutter_actor_raise_top(select_loading);
  clutter_actor_raise_top(easy_advanced);
  clutter_actor_raise_top(select_ud);
  clutter_actor_raise_top(select_drum);
  clutter_actor_raise_top(select_flute);
  clutter_actor_raise_top(select_flute);
  clutter_actor_raise_top(select_slider);
  clutter_actor_raise_top(quit);
  clutter_actor_raise_top (mentor);

  clutter_actor_set_reactive(easy_advanced, TRUE);
  clutter_actor_set_reactive(select_singing, TRUE);
  clutter_actor_set_reactive(select_composing, TRUE);
  clutter_actor_set_reactive(select_loading, TRUE);
  clutter_actor_set_reactive(select_ud, TRUE);
  clutter_actor_set_reactive(select_drum, TRUE); 
  clutter_actor_set_reactive(select_flute, TRUE);
  clutter_actor_set_reactive(select_slider, TRUE);
  clutter_actor_set_reactive(quit,TRUE);

  clutter_actor_show (house);
  clutter_actor_show (select_singing);
  clutter_actor_show (select_composing);
  clutter_actor_show (select_loading);
  clutter_actor_show (easy_advanced);
  clutter_actor_show (select_ud);
  clutter_actor_show (select_drum);
  clutter_actor_show (select_flute);
  clutter_actor_show (select_slider);
  clutter_actor_show (quit);
  clutter_actor_show (mentor);
}

void main_menu_init() {
    init_actors(); 
}


