/**clutter_jammo.c is part of JamMo.
License: GPLv2, read more from COPYING

This is 'default' Graphical user interface for JamMo. It implements 
all functions in gui.h. This is base file for whole clutter-gui.

Read more about clutter: http://clutter-project.org/
*/
//This is because of getline
#define _GNU_SOURCE

#include <stdlib.h>
//#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <clutter/clutter.h>
#include <glib-object.h>
#include <string.h>
#include <pthread.h>


#include "../chum/chum.h"
#include "../chum/gui.h"
#include "../meam/jammo-meam.h"  //FIXME. get rid of this.

#include "clutter_jammo.h"
#include "config.h"
#include "object.h"
#include "button.h"
#include "jammo-texture.h"
#include "json_helper.h" //there are generate_json_for_theme

#include "preloader.h"
#include "password_screen.h"
#include "welcome_demo.h"
#include "main_menu.h"
//Games
#include "composing_game.h"
#include "singing_game.h"
//#include "instrument_testing.h" //For testing virtual instruments (and slider)
#include "midi_editor.h"
#include "sequencer.h"
ClutterActor* star_trace;

ClutterActor* get_real_star_trace(){
return star_trace;
}
void gui_start_main_loop(){
    //clutter_init();
		
		//This cogl-texture must be initialized in main thread.
		//actually it is that clutter_texture_set_cogl_texture.
    star_trace = g_object_new (CLUTTER_TYPE_TEXTURE, "disable-slicing", TRUE, NULL);
		g_object_set(G_OBJECT(star_trace), "load-async", TRUE, NULL);

    CoglHandle new_texture;
    CoglTextureFlags flags = COGL_TEXTURE_NO_SLICING; //NO_SLICING is important.
    new_texture = cogl_texture_new_with_size (WIDTH_OF_WINDOW,HEIGHT_OF_WINDOW,
                                              flags,
                                              COGL_PIXEL_FORMAT_RGBA_8888_PRE);

    clutter_texture_set_cogl_texture (CLUTTER_TEXTURE(star_trace), new_texture);
    cogl_handle_unref (new_texture);


    
    clutter_main();
}

ClutterColor trans_color = { 0, 0, 0, 0x00 };
ClutterColor dark_color =  { 0, 0, 0, 0xdd };
ClutterColor white_color = { 0, 0, 0, 0xbb };
ClutterColor blue_color =  { 0, 0, 0xff, 0xff };
ClutterColor green_color =  { 158, 219, 116, 0xff };


ClutterColor *get_transparency_color(){ return &trans_color; }
ClutterColor *get_white_color(){        return &white_color; }
ClutterColor *get_dark_color(){         return &dark_color;  }
ClutterColor *get_blue_color(){         return &blue_color;  }
ClutterColor *get_green_color(){         return &green_color;  }

ClutterActor* stage;
ClutterActor* main_getStage(){
  return stage;
}

void gui_visualize_playing(int state) {
  if (state==SCREEN_COMPOSING)
      composing_game_visualize_playing();
  else if (state==SCREEN_PLAY_RECORDED)
      printf("#####state is Screen_play_recorded and sequencer started\n");
  else
      printf("#####gui_visualize_playing: state is %d \n",state);
}

void gui_go_screen(int screen_number) {
  if (screen_number==SCREEN_PASSWORD_TYPING){
    show_password();              //password_screen.c
	} else if (screen_number==SCREEN_WELCOME){
    show_welcome();              //welcome_demo.c
  } else if (screen_number==SCREEN_GAME_SELECTION){
		main_menu_init();
    show_game_selection();        //main_menu.c
  } else if (screen_number==SCREEN_THEME_SELECTION){
		composing_game_init_theme_selection();
    show_theme_selection();       //composing_game.c
  } else if (screen_number==SCREEN_COMPOSING){
		composing_game_init_games(); 
    start_theme();               //composing_game.c
  } else if (screen_number==SCREEN_SONG_SELECTION){
		init_singing_game(); 
    start_mobikid_selection();   //singing_game.c
  } else if (screen_number==SCREEN_SONG_RECORDING){
    start_mobikid_recording();   //singing_game.c
  } else if (screen_number==SCREEN_PLAY_RECORDED){
    start_mobikid_play_recorded();      //singing_game.c
  } 

}


void window_closed(void) {
  printf("window is closed\n");
  clutter_main_quit();
  }

GdkPixbuf *create_pixbuf(const gchar * filename)
  {
    GdkPixbuf *pixbuf;
    GError *error = NULL;
    pixbuf = gdk_pixbuf_new_from_file(filename, &error);
    if(!pixbuf) {
	fprintf(stderr, "%s\n", error->message);
	g_error_free(error);
    }

    return pixbuf;
}


/*This can handle other events too.*/
static void event_handler (ClutterActor    *actor,
          ClutterEvent    *event,
          gpointer         data)
{
  switch (event->type)
    {
    case CLUTTER_DELETE:
      window_closed();
    default:
      break;
    }
}


void gui_init() {
      int i;
      gint number_of_themes =chum_get_number_of_themes();
      for (i=1;i<number_of_themes+1;i++){
        //printf("name of theme: %s\n",chum_get_theme_folder(i));
        generate_json_for_theme(chum_get_theme_folder(i));
      }

      clutter_init(NULL,NULL);
      //clutter_threads_init();

      //stage is global
      stage = clutter_stage_get_default();
      clutter_stage_set_title(CLUTTER_STAGE(stage),"JamMo");
      //clutter_stage_set_user_resizable (CLUTTER_STAGE(stage),TRUE);
      clutter_actor_set_size (stage, WIDTH_OF_WINDOW,HEIGHT_OF_WINDOW);

      g_signal_connect (stage, "event", G_CALLBACK (event_handler), "stage");

      #ifdef N900
      clutter_stage_set_fullscreen(CLUTTER_STAGE(stage),TRUE);

      #endif
      clutter_actor_show_all(stage);
      //preloader_start(); //this will start some threads and return immediatly.

      #ifdef START_JOYSTICK_THREAD
      /* temporaly disabled */
      pthread_t loop_thread;
      pthread_create(&loop_thread, NULL, start_reading_joystick, NULL);
      #endif
}

#ifdef clutter_gtk_way
/*This is way how to use clutter-gtk. JamMo doesn't need clutter-gtk.
  Add clutter-gtk to configure.ac and debian/control if you want use this.
*/
#include <clutter-gtk/clutter-gtk.h>
void gui_init() {
      int i;
      gint number_of_themes =chum_get_number_of_themes();
      for (i=1;i<number_of_themes+1;i++){
	//printf("name of theme: %s\n",chum_get_theme_folder(i));
	generate_json_for_theme(chum_get_theme_folder(i));
      }

	GtkWidget* window;
	GtkWidget* vbox;
	GtkWidget* embed;
	
	clutter_init(NULL,NULL);
	gtk_init(NULL,NULL);
	
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(window), "JamMo");
	gtk_window_resize( GTK_WINDOW(window), WIDTH_OF_WINDOW,HEIGHT_OF_WINDOW );
	gtk_window_set_icon(GTK_WINDOW(window), create_pixbuf("/usr/share/pixmaps/jammo.png"));

	vbox = gtk_vbox_new(FALSE, 8);
	gtk_container_add(GTK_CONTAINER(window), vbox);
	
	embed = gtk_clutter_embed_new();
	gtk_widget_set_size_request(embed, WIDTH_OF_WINDOW,HEIGHT_OF_WINDOW);
	gtk_box_pack_start(GTK_BOX(vbox), embed, FALSE, FALSE, 0);
	stage = gtk_clutter_embed_get_stage(GTK_CLUTTER_EMBED(embed));

	// Initializes main window to be drawable
	gtk_widget_set_app_paintable(window, TRUE);
	
	clutter_actor_show(stage);
	gtk_widget_show_all(window); //This causes "Unable to make the stage window 0x3c00020 the current GLX drawable", so it must be disable, if running in gdb. Window size is then wrong.
	//and it doesn't send "destroy" signal when closed.

	g_signal_connect(window, "destroy",G_CALLBACK(window_closed), NULL);

    pthread_t loop_thread;
    pthread_create(&loop_thread, NULL, start_reading_joystick, NULL);
}
#endif
