#!/bin/sh

#Developing version of JamMo is intended to be installed and used on subfolder.
PREFIX=`pwd`/usr

touch NEWS README AUTHORS ChangeLog

aclocal
automake -ac
autoconf
./configure --prefix=$PREFIX


mkdir $PREFIX/lib/jammo -p 2> /dev/null
mkdir $PREFIX/bin -p 2> /dev/null
echo "Building GST plugins"
cd src/meam/gst-jammo-plugins

./compile_plugin.sh sampler 
./compile_plugin.sh slider
./compile_plugin.sh pitchdetect
cp libs/libgstjammo*.so $PREFIX/lib/jammo

cd -

echo "Making start scripts"
echo "GST_PLUGIN_PATH=../lib/jammo/ ./jammo \$@" > $PREFIX/bin/jammo.sh
chmod a+x $PREFIX/bin/jammo.sh

echo "GST_PLUGIN_PATH=../lib/jammo/ ./jammoterminal \$@ reset" > $PREFIX/bin/jammoterminal.sh
chmod a+x $PREFIX/bin/jammoterminal.sh

echo "cd usr/bin/ && ./jammo.sh \$@" > jammo.sh
chmod a+x jammo.sh



echo
echo "Run 'make install' to compile and install"
echo "Run './jammo.sh' to start JamMo"

exit 0
