/**track.h is part of JamMo.
License: GPLv2, read more from COPYING
*/

#ifndef __TRACK_H__
#define __TRACK_H__

#include <gst/gst.h>
#include "pipeline.h"
#include "sample.h"

/* tablets can't save whole song in /tmp */
//#ifdef N810
#ifdef N900
   #define REC_TARGET "/home/user/.jammo/jammo_rec.wav"
#else
   #define REC_TARGET "/tmp/jammo_rec.wav"
#endif

/*
There are pitch-element which can be used to tune pitch and tempo. But comes from
gst-plugins-bad which is not available for every platform.
use
#define ENABLE_PITCH_ELEMENT
if you have that plugin installed and want use these functions:
void set_track_speed(guint trackNumber, double speedlevel);
void set_track_mute(guint trackNumber, gboolean state);

These are not used anyway because they are only whole track related.
*/


/*
About SlotInfo->info:
Each entry of this array corresponds one slot.
0 	: this slot is empty
x*10+y  : sample in this slot is x-slot wide
	: and this is slot number y of this sample

One slot wide sample occupie one slot and it is marked 11.
Two slot wide sample are marked 21 and 22.
Three slot wide are 31, 32, 33
etc.

*/
//FIXME, this is now limit how many slot one track can handle!
//It is maximun lenght of track!
#define SLOT_LIMIT 40

// Struct definition
typedef struct SlotInfo {
	unsigned char info;
	struct Sample *sample;
} SlotInfo;

// Type of track
enum {
  TRACK_SAMPLES,
  TRACK_BACKINGTRACK,
  TRACK_INSTRUMENT,
  TRACK_SINGING,
};

// Struct definition
typedef struct Track {
  gint type;
  GstElement *trackbin;		   /*This is container of all tracks elements*/
  GstElement *composition; 	   /* Samples are added here (only sample-tracks use this)*/
  guint tempo; /* beats per minute (e.g. 130) (only sample-tracks use this) */
  guint meter; /* time_signature. e.g. 4/4(only sample-tracks use this)  http://en.wikipedia.org/wiki/Meter_%28music%29 */

  GstElement *instrument_element;  /* This is jammoinstrument and notes are passed via this (only instrument-tracks)*/
  GList *samples;
  SlotInfo *slot_info[SLOT_LIMIT];  /*See above*/
#ifdef ENABLE_PITCH_ELEMENT
	GstElement *pitch;		/*pitch and speed. See above*/
#endif
	GstElement *volume;		/*Volume of this track.*/
} Track;

// Function prototypes
Track *create_new_empty_track(void);
Track *create_instrument_track(gint instrument_nro);
void create_new_singing_track(void);
Track *create_new_backing_track(gchar *filename); //DEBUG

void free_track(Track *trc);
void set_track_pitch(guint trackNumber, double pitchlevel);
void set_track_speed(guint trackNumber, double speedlevel);
void set_track_mute(guint trackNumber, gboolean state);
void remove_samples_from_all_tracks(void);
void remove_samples_from_track(guint track_number);
guint64 count_track_endtime(guint track_number,guint64 *value);

#endif /* __TRACK_H__ */
