/**pipeline.h is part of JamMo.
License: GPLv2, read more from COPYING
*/

#ifndef __PIPELINE_H__
#define __PIPELINE_H__

#include "track.h"
#include "duration.h"

// Struct definition
typedef struct {
	GstElement *pipeline;
	GstBus *bus;
	GList *tracks;
	GstElement *adder;
	GstElement *audiosink;
	guint64 pipelines_end_time;
} Pipeline;

// Function prototypes
gboolean pipeline_init(void);
void free_pipeline(void);
Pipeline* get_mainPipeline(void);


#endif /* __PIPELINE_H__ */
