/**meam.h is part of JamMo.
License: GPLv2, read more from COPYING
*/

#ifndef __MEAM_H__
#define __MEAM_H__

#include "sequencer/sequencer.h"

void meam_init();

void meam_seq_stop();
void meam_seq_play();

void meam_seq_remove_samples_from_track(int track);


Sample *meam_seq_add_new_sample_to_track(int track_number, const gchar srcLocation[], guint64 startTime);
Sample *meam_seq_add_new_sample_to_track_nth_slot(int track_number, const gchar srcLocation[], guint slot);
void meam_remove_sample_from_slot(guint track_number,int slot);

void meam_play_one_sample(char* filename);
void meam_stop_one_sample();

void meam_add_instrument_track(int type);
void meam_get_all_slot_info(int track_number);

void meam_state_of_note(gboolean state, char note);
void meam_toggle_note(char note);
void meam_toggle_note_on_octave(char note, int new_octave);
void meam_print_note_table();

void meam_octave_up();
void meam_octave_down();

void meam_get_duration_of_song(guint64 *value);

void meam_slider_state(gboolean b);
void meam_slider_freq(int a);
void meam_create_new_empty_track();

guint meam_get_meter_of_track(int track_number);
guint meam_get_tempo_of_track(int track_number);


#endif  /* __MEAM_H__ */
