/**welcome_demo.c is part of JamMo.
License: GPLv2, read more from COPYING

Welcome screen is opening door.
*/
#include <glib-object.h>
#include <gtk/gtk.h>
#include <clutter/clutter.h>
#include "config.h"


#include "clutter_jammo.h"
#include "../chum/chum.h" //THEMES_DIR


//////For welcome screen, animating door opening
#define angle_of_opened_door 110.0
gdouble door_rotating=0.0;
static gboolean rotate_actor (gpointer data){
  door_rotating-=0.8;
  clutter_actor_set_rotation(CLUTTER_ACTOR(data),CLUTTER_Y_AXIS,door_rotating,0,0,0);

  if (door_rotating>-angle_of_opened_door)
    return TRUE;

  //just be sure, that there aren't any sounds when going next step.
  chum_stop_one_sample();
  chum_go_next();
  return FALSE;
}

static void welcome_end (ClutterActor *actor, ClutterEvent *event, gpointer data){
  //if pressed already
  if (door_rotating<0.0)
    {
    door_rotating=-angle_of_opened_door;
    return;
    }

  g_timeout_add (50,rotate_actor,actor);
  chum_play_one_sample(g_strdup_printf("%s/door_opening.wav",DATA_DIR));
}


void show_welcome(){
  ClutterActor* stage =main_getStage();

  ClutterActor *s1 = config_get_configured_actor(NULL,"welcome");
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), s1);
  clutter_actor_show (s1);
  clutter_actor_set_reactive(s1, TRUE);
  clutter_actor_set_name(s1, "welcome");

  s1 = config_get_configured_actor(NULL,"door");
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), s1);

  clutter_actor_show (s1);
  clutter_actor_set_reactive(s1, TRUE);
  clutter_actor_set_name(s1, "door");
  g_signal_connect (s1, "button-release-event", G_CALLBACK (welcome_end),NULL);
}

