/**singing_game.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is the singing game. Like karaoke.
 First user sing with background music and then both 
 singing and music are played.
*/

#include <fcntl.h> //we check some files
#include <glib-object.h>
#include <gtk/gtk.h>
#include <clutter/clutter.h>
#include "config.h"

#include <math.h> //We use sqrt

#include "jammo-texture.h"
#include "clutter_jammo.h"
#include "../chum/chum.h" //THEMES_DIR
#include "object.h"
#include "preloader.h"

//This is list of actors we need.
ClutterActor *contour_star;	/*When capturing and analysing pitch*/
ClutterActor *display_freq;	/*Captured pitch in text (debug)*/
ClutterActor *clef;		/*when recorder singing is playing*/
ClutterActor *microphone;	/*when recording*/
ClutterActor *group_of_songs;	/*All songs (these are clickable)*/
ClutterActor *next;		/*For skipping stages*/
ClutterActor *back;		/*For going back*/
ClutterActor *background;	/*This is bottom of all*/
ClutterActor *big_image;	/*Currently played song*/
ClutterActor *singinggame_back_to_mainmenu=NULL; /*Button back to main_menu.*/

/*When microphone is recording, sequencer (pipeline.c) sends captured frequence to this function.
It sends -1.0 if it can't detect frequency (or if it doesn't hear anything).
*/
void gui_visualize_contour(float frequency) {
    if (contour_star==NULL)  //error case
      return;

    clutter_actor_set_position(contour_star,130,840-(frequency*2));

    gchar* buffer0;
    if (frequency==-1.0)
        buffer0="";
    else
        buffer0 = g_strdup_printf("[%3.1lf]",frequency);
    clutter_text_set_text (CLUTTER_TEXT(display_freq),buffer0);
}

/*Helper function to load image of asked song*/
static ClutterActor* load_song_image(int i){
  //printf("%d\n",i);
  ClutterActor* actor = clutter_texture_new ();
  gchar* filepath1;

  filepath1 = g_strdup_printf("%s/picture.png", chum_get_song_folder(i) );
  //printf("filepath=%s\n",filepath1);

  int fd = open(filepath1,O_RDONLY);
  if (fd == -1) //File not found
    {
    printf("file '%s' not found, using default\n",filepath1);
    actor = config_get_configured_actor(NULL,"default-picture");
    }
  else
    g_object_set(G_OBJECT(actor), "load-async", TRUE, NULL);
    clutter_texture_set_from_file (CLUTTER_TEXTURE (actor), filepath1, NULL);
  return actor;
}


static void picture_of_song_pressed(JammoTexture *actor, ClutterEvent *event, gpointer data) {
  int i = GPOINTER_TO_INT(data);
  //g_print("pressed song number: %d \n", i);
  chum_change_to_song(i);
  gui_go_screen(SCREEN_SONG_RECORDING);
}


static void from_song_selection_to_game_selection(){
chum_stop_sequencer();
chum_go_screen(SCREEN_GAME_SELECTION);
}

static void next_pressed(){
  chum_go_next();
}

static void back_pressed(){
  chum_go_back();
}


void init_singing_game(){
  printf("init singing_game\n");
  ClutterActor* stage =main_getStage();

  //This is background. We want cover all underlying stuff. 
  background =clutter_rectangle_new_with_color (get_blue_color());
  clutter_actor_set_size (background, WIDTH_OF_WINDOW,HEIGHT_OF_WINDOW);
  clutter_actor_set_position (background, 0, 0); 
  clutter_actor_hide (background);
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), background);

  //Text label of currently captured pitch
  display_freq=  clutter_text_new_with_text ("Liberty",""); //start with empty text
  clutter_text_set_font_name(CLUTTER_TEXT(display_freq),"Luxi Mono 18");
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), display_freq);
  clutter_actor_set_position (display_freq, 10, 30); 
  clutter_actor_hide (display_freq);


  //Star moving up and down
  contour_star = config_get_configured_actor(NULL,"contour_star");
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), contour_star);
  clutter_actor_hide (contour_star);

  //Image of clef. Showed when recorded singing is playing
  clef = config_get_configured_actor(NULL,"clef");
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), clef);
  clutter_actor_hide (clef);

  //Image of microphone. Showed when recorded singing is playing
  microphone = config_get_configured_actor(NULL,"microphone");
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), microphone);
  clutter_actor_hide (microphone);

  //Button for going next stage (this is button and defined in button.c). NOT AT THIS MOMENT!
  next = config_get_configured_actor(NULL,"mobikid-next");
  clutter_actor_set_reactive(next, TRUE);
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), next);
  clutter_actor_hide(next);
  g_signal_connect (next, "button-press-event", G_CALLBACK (next_pressed), GINT_TO_POINTER(1));

  //Button for going previous stage (this is button and defined in button.c) NOT AT THIS MOMENT!
  back = config_get_configured_actor(NULL,"mobikid-back");
  clutter_actor_set_reactive(back, TRUE);
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), back);
  clutter_actor_hide(back);
  g_signal_connect (back, "button-press-event", G_CALLBACK (back_pressed), GINT_TO_POINTER(2));

  //Make one clickable image for each song
  group_of_songs = clutter_group_new();
  int mobikid_marginal = (WIDTH_OF_WINDOW-HEIGHT_OF_WINDOW) /2; /* to make drawing area square.*/
  int mobikid_marginal_between_images = 25;  /*regardless of size of images*/

  GList *song_list=chum_get_all_songs();
  guint number_of_songs=g_list_length(song_list);

  //We have square area to place all images.
  double lenght_of_side = sqrt((double)number_of_songs);
  int side = (int) lenght_of_side;
  if (side*side<number_of_songs)
      side++;
  gint max_columns=side,max_rows=side;


  guint current_row = 0, current_column = 0;
  int i;
  for (i=0;i<number_of_songs;i++)
    {
    ClutterActor *actor= load_song_image(i); //gives image (real or default)
    if (actor==NULL) printf ("actor is NULL\n");

    int x=mobikid_marginal + (WIDTH_OF_WINDOW-2*mobikid_marginal)/max_columns*current_column;
    int y=HEIGHT_OF_WINDOW/max_rows*current_row;
    clutter_actor_set_position (actor,x,y+mobikid_marginal_between_images/2);
    //printf("actor number=%d, x=%d, y=%d\n",i,x,y);

    int size=(WIDTH_OF_WINDOW-2*mobikid_marginal)/max_columns -mobikid_marginal_between_images;
    clutter_actor_set_size (actor,size,size);

    current_column++;
    if( current_column >= max_columns ) 
         {
         current_column = 0;
         current_row++;
         }

    clutter_container_add_actor (CLUTTER_CONTAINER (group_of_songs), actor);
    clutter_actor_show (actor);
    clutter_actor_set_reactive(actor, TRUE);
    g_signal_connect (actor, "button-press-event", G_CALLBACK (picture_of_song_pressed), GINT_TO_POINTER(i));
    }

  clutter_actor_set_position (group_of_songs,0,0);
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), group_of_songs);
  clutter_actor_hide (group_of_songs);

  //Back to main-menu button.
  singinggame_back_to_mainmenu = config_get_configured_actor(NULL,"house");
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), singinggame_back_to_mainmenu);
  clutter_actor_set_position (singinggame_back_to_mainmenu, 720, 5); 
  clutter_actor_set_size (singinggame_back_to_mainmenu, 66, 60);
  clutter_actor_hide (singinggame_back_to_mainmenu);
  clutter_actor_set_name(singinggame_back_to_mainmenu, "singinggame_back_to_mainmenu");
  clutter_actor_set_reactive(singinggame_back_to_mainmenu, TRUE);
  g_signal_connect (singinggame_back_to_mainmenu, "button-press-event", G_CALLBACK (from_song_selection_to_game_selection),NULL);
}


void start_mobikid_play_recorded(){
    clutter_actor_hide (microphone);
    clutter_actor_hide (display_freq);
    clutter_actor_hide (contour_star);

    clutter_actor_show (clef);
    clutter_actor_raise_top(clef);

    chum_play_sequencer();
}

void start_mobikid_recording(){
  printf("start_mobikid_recording starts\n");
  ClutterActor* stage =main_getStage();

  clutter_actor_hide(group_of_songs);
  clutter_actor_hide(clef);

  //Image of currently playing song

  big_image = load_song_image(chum_get_current_song());
  int size= WIDTH_OF_WINDOW/2;
  clutter_actor_set_size(big_image,size,size);
  clutter_actor_set_position(big_image,size/2,(HEIGHT_OF_WINDOW-size)/2);
  clutter_actor_show (big_image);
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), big_image);

  clutter_actor_show (display_freq);
  clutter_text_set_text (CLUTTER_TEXT(display_freq),"");
  clutter_actor_raise_top (display_freq);

  clutter_actor_show (contour_star);
  clutter_actor_raise_top (contour_star);

  clutter_actor_show (microphone);
  clutter_actor_raise_top (microphone);

  clutter_actor_show (next);
  clutter_actor_raise_top (next);
  clutter_actor_set_reactive(next, TRUE);

  clutter_actor_raise_top (back);
  clutter_actor_show (back);
  clutter_actor_set_reactive(back, TRUE);

  printf("will start sequencer\n");
  chum_play_sequencer();
}

gboolean singing_game_is_initialized(){
  //printf("singing_game_is_initialized called. will return %d\n",singinggame_back_to_mainmenu!=NULL);
  return (singinggame_back_to_mainmenu!=NULL); //last actor
}

/*
We can come to this function
a) from game selection (main menu)
b) after one song is sung
c) when recording is cancelled
*/
void start_mobikid_selection(){
  if (!singing_game_is_initialized())
      preloader_init_this(SCREEN_SONG_SELECTION);

  chum_stop_sequencer();

  //First start with background
  clutter_actor_raise_top (background);
  clutter_actor_show (background);

  //Show all song-images
  clutter_actor_raise_top (group_of_songs);
  clutter_actor_show (group_of_songs);

  //clutter_actor_raise_top (back);
  //clutter_actor_show (back);

  clutter_actor_raise_top(singinggame_back_to_mainmenu);
  clutter_actor_show (singinggame_back_to_mainmenu);
    
  //If this isn't first round these can be visible. So hide them
  clutter_actor_hide (display_freq);
  clutter_actor_hide (contour_star);
  clutter_actor_hide (microphone);
  clutter_actor_hide (clef);
  clutter_actor_hide (next);
  clutter_actor_hide (back);
}
