/**main_menu.c is part of JamMo.
License: GPLv2, read more from COPYING

This is game selection screen.
*/

#include <gtk/gtk.h>
#include <clutter/clutter.h>
#include "config.h"

#include "clutter_jammo.h"
#include "../chum/chum.h"
#include "preloader.h"

//Games
#include "composing_game.h"
#include "singing_game.h"
#include "instrument_testing.h" //For testing virtual instruments (and slider)


ClutterActor *house;                    /* Background image */
ClutterActor *select_singing;           /* Button for singing game */
ClutterActor *select_composing;         /* Button for composing game */
ClutterActor *select_ud;                /* Button for testing ud */
ClutterActor *select_drum;              /* Button for testing drum */
ClutterActor *select_flute;             /* Button for testing flute */
ClutterActor *select_slider;            /* Button for testing slider */



static void compose_clicked(){
  chum_go_screen(SCREEN_THEME_SELECTION);
}

static void singing_clicked(){
  clutter_actor_set_reactive(select_singing, FALSE);
  clutter_actor_set_reactive(select_composing, FALSE);
  clutter_actor_set_reactive(select_ud, FALSE);
  clutter_actor_set_reactive(select_drum, FALSE); 
  clutter_actor_set_reactive(select_flute, FALSE);
  clutter_actor_set_reactive(select_slider, FALSE);
  chum_go_screen(SCREEN_SONG_SELECTION);
}


static void init_actors() {
   ClutterActor* stage = main_getStage();

   house = config_get_configured_actor(NULL,"house");
   clutter_actor_set_name(house, "house");
   clutter_actor_hide (house);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), house);

   select_singing = config_get_configured_actor(NULL,"select_singing");
   clutter_actor_set_name(select_singing, "select_singing");
   clutter_actor_set_reactive(select_singing, TRUE);
   g_signal_connect (select_singing, "button-release-event", G_CALLBACK (singing_clicked),NULL);
   clutter_actor_hide (select_singing);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), select_singing);

   select_composing = config_get_configured_actor(NULL,"select_composing");
   clutter_actor_set_name(select_composing, "select_composing");
   clutter_actor_set_reactive(select_composing, TRUE);
   g_signal_connect (select_composing, "button-press-event", G_CALLBACK (compose_clicked),NULL); 
   clutter_actor_hide (select_composing);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), select_composing);

   select_ud = config_get_configured_actor(NULL,"select_ud");
   clutter_actor_set_name(select_ud, "select_ud");
   clutter_actor_set_reactive(select_ud, TRUE);
   g_signal_connect (select_ud, "button-release-event", G_CALLBACK (start_test_instrument),GINT_TO_POINTER(2));
   clutter_actor_hide (select_ud);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), select_ud);

   select_drum = config_get_configured_actor(NULL,"select_drum");
   clutter_actor_set_name(select_drum, "select_drum");
   clutter_actor_set_reactive(select_drum, TRUE);
   g_signal_connect (select_drum, "button-release-event", G_CALLBACK (start_test_instrument),GINT_TO_POINTER(1));
   clutter_actor_hide (select_drum);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), select_drum);

   select_flute = config_get_configured_actor(NULL,"select_flute");
   clutter_actor_set_name(select_flute, "select_flute");
   clutter_actor_set_reactive(select_flute, TRUE);
   g_signal_connect (select_flute, "button-release-event", G_CALLBACK (start_test_instrument),GINT_TO_POINTER(0));
   clutter_actor_hide (select_flute);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), select_flute);

   select_slider = config_get_configured_actor(NULL,"select_loading"); //just use some image for slider
   clutter_actor_set_name(select_slider, "select_slider");
   clutter_actor_set_reactive(select_slider, TRUE);
   g_signal_connect (select_slider, "button-release-event", G_CALLBACK (start_slider),NULL);
   clutter_actor_set_size(select_slider,60,60);
   clutter_actor_set_position(select_slider,10,400);
   clutter_actor_hide (select_slider);
   clutter_container_add_actor (CLUTTER_CONTAINER (stage), select_slider);

}

gboolean main_menu_is_initialized() {
    return (select_slider != NULL); //Last initialized actor.
}

void show_game_selection() {

  if (!main_menu_is_initialized())
      preloader_init_this(SCREEN_GAME_SELECTION);

  clutter_actor_raise_top(house);
  clutter_actor_raise_top(select_singing);
  clutter_actor_raise_top(select_composing);
  clutter_actor_raise_top(select_ud);
  clutter_actor_raise_top(select_drum);
  clutter_actor_raise_top(select_flute);
  clutter_actor_raise_top(select_flute);
  clutter_actor_raise_top(select_slider);

  clutter_actor_set_reactive(select_singing, TRUE);
  clutter_actor_set_reactive(select_composing, TRUE);
  clutter_actor_set_reactive(select_ud, TRUE);
  clutter_actor_set_reactive(select_drum, TRUE); 
  clutter_actor_set_reactive(select_flute, TRUE);
  clutter_actor_set_reactive(select_slider, TRUE);

  clutter_actor_show (house);
  clutter_actor_show (select_singing);
  clutter_actor_show (select_composing);
  clutter_actor_show (select_ud);
  clutter_actor_show (select_drum);
  clutter_actor_show (select_flute);
  clutter_actor_show (select_slider);
}

void main_menu_init() {
    init_actors(); 
}


