/**gui.h is part of JamMo.
License: GPLv2, read more from COPYING

Graphical user interface must implement all these functions.
*/

#ifndef _GUI_H_
#define _GUI_H_

#define WIDTH_OF_WINDOW 800
#define HEIGHT_OF_WINDOW 480
//These are different state of Game.
enum {
  SCREEN_WELCOME = 0,
  SCREEN_GAME_SELECTION, //This is main-menu
  SCREEN_THEME_SELECTION,
  SCREEN_COMPOSING,
  SCREEN_SONG_SELECTION,
  SCREEN_SONG_RECORDING,
  SCREEN_PLAY_RECORDED,
  SCREEN_MIDI_EDITOR,
  NUMBER_OF_SCREENS, //Keep this entry last.
};

void gui_go_screen(int number);
void gui_init();
void gui_visualize_playing();
void gui_visualize_contour(float freq);

void gui_start_main_loop();

#endif /*  _GUI_H_  */
