/**sequencer.h is part of JamMo.
License: GPLv2, read more from COPYING
*/

#ifndef __SEQUENCER_H__
#define __SEQUENCER_H__

#include <glib.h>
#include <stdio.h>
#include <gst/gst.h>
#include "pipeline.h"

/* Function prototypes */
gboolean sequencer_init(void);
void sequencer_deinit(void);
void seq_play(void);
void seq_stop(void);
void seq_pause(void);
//void seq_quit(void);
const gchar * seq_get_element_state();
gboolean seq_loop_is_running();
void seq_seek_to_time (guint64 time_nanoseconds);
void seq_seek_to_time_seconds(guint64 time_seconds);

void set_timeout_callback (gboolean (*func_ptr)(void), guint interval);
Track *get_nth_track_from_pipeline(int track_number);

void seq_get_lenght_of_pipeline(guint64 *arg);
#endif /* __SEQUENCER_H__ */
