
#ifndef _CONFIGURE_H_
#define _CONFIGURE_H_

#include <glib.h>
void configure_init_directories(gboolean small_game);
void configure_release_directories();

const gchar* configure_get_jammo_directory();
const gchar* configure_get_singings_directory();
const gchar* configure_get_compositions_directory();

const gchar* configure_get_projects_directory();
const gchar* configure_get_finalized_directory();
const gchar* configure_get_log_directory();
const gchar* configure_get_temp_directory();
/**
 * Defines default folders.
 */
#define DATA_DIR "/opt/jammo" //There are image and miscellaneous files (NOT audio) TODO: there are some audio still


#define THEMES_DIR DATA_DIR "/themes"
#define SONGS_DIR DATA_DIR "/songs"




//AUDIO_DIR is only for audible-data

//N900 has not enough space on /opt for audio data -> put them to MyDocs
#ifdef N900
#define AUDIO_DIR "/home/user/MyDocs/jammo_data"
#else
#define AUDIO_DIR DATA_DIR //NOTE: same than DATA_DIR
#endif

//These are not heavily used
#define WIDTH_OF_WINDOW 800
#define HEIGHT_OF_WINDOW 480




#define _(string)    gettext(string)


// Enable TangleBufferer in N900
#ifdef N900
#define BUFFERER_ENABLED
#endif

#endif /* _CONFIGURE_H_ */
