#include "single_thread.h"
#include <stdio.h>
#include <tangle.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "../jammo.h"
#include "community_utilities.h"
#include "jammosongs.h"
#include "help.h"
#include "jammosounds.h"
#include "discuss.h"

static ClutterContainer *messageList = 0;
static int selected_index = 0;
static GList* messages;
static gchar *id;
static TextField text;

void start_thread_view(GList* listOfMessages, gchar *id_, gchar *params, int index){

	selected_index = index;

	int i = 0;
	id = id_;

	messages = listOfMessages; 

	ClutterActor* thread_view = NULL;

	puts("starting thread...");

	if(strcmp(id, "jammosongs") == 0)
	thread_view = jammo_get_actor_by_id("single-thread-view");	//if you want to use different layout for the threads view, modify this. Although it crashes for somereason is you change this

	if(strcmp(id, "discuss") == 0)
	thread_view = jammo_get_actor_by_id("single-thread-view");

	if(strcmp(id, "helpdesk") == 0)
	thread_view = jammo_get_actor_by_id("single-thread-view");

	if(thread_view){

		clutter_actor_show(thread_view);

		if(strcmp(id, "jammosongs") == 0){
			text.text = jammo_get_actor_by_id("answer-field");
			text.lineCount = 8;
			text.handler_id = g_signal_connect_swapped(text.text, "text-changed", (GCallback)limit_line_count, &text);

		}else if(strcmp(id, "discuss") == 0){
			text.text = jammo_get_actor_by_id("answer-field");
			text.lineCount = 8;
			text.handler_id = g_signal_connect_swapped(text.text, "text-changed", (GCallback)limit_line_count, &text);

		}else if(strcmp(id, "helpdesk") == 0){
			text.text = jammo_get_actor_by_id("answer-field");
			text.lineCount = 6;
			text.handler_id = g_signal_connect_swapped(text.text, "text-changed", (GCallback)limit_line_count, &text);
		}	

		clutter_text_set_text(CLUTTER_TEXT(text.text), "");	
		
		if(messages != NULL)
		{
		
			messages = g_list_first(messages);
						
			messageList = CLUTTER_CONTAINER(jammo_get_actor_by_id("single-thread-list-scrollable"));
				
			do{	
				if(i > 0)
				messages = messages->next;

				add_message_to_list(messages->data, index);
				i++;
				
			} while(messages->next != NULL);
		}
	}
	else
	puts("can't find single-thread-view");
	

}

void add_message_to_list(gpointer data, int i) 
{
	message *msg = data;

	if(msg->index == i)	//If the messages index is the same as i (question number, we selected) then add it to list.
	{
		int index = 0;
		int MAX = 500;
	
		ClutterActor* messageBackground = 0;
		ClutterContainer *listContainer = CLUTTER_CONTAINER(clutter_group_new());
	
		ClutterColor text_color = { 0, 0, 0, 255 };
		ClutterColor line_color = { 144, 148, 140, 255 };

		ClutterActor* message = clutter_text_new_full("Comic Sans MS 12", msg->msg, &text_color);
		clutter_text_set_line_wrap_mode(CLUTTER_TEXT(message), PANGO_WRAP_WORD_CHAR);

		ClutterActor* avatar = 0;
		ClutterActor* name = clutter_text_new_full("Comic Sans MS 14", msg->sender, &text_color);
		ClutterActor* date = clutter_text_new_full("Comic Sans MS 14", msg->time, &text_color);
		//ClutterActor* avatar_ = clutter_text_new_full("Comic Sans MS 12", msg->avatar, &text_color);

		avatar = clutter_texture_new_from_file("/opt/jammo/communitymenu/community_avatarbackground_small.png", NULL); //this is test avatar
	
		index = (index+1) % 3;

		if(strcmp(msg->title, "") != 0){
			ClutterActor* title = clutter_text_new_full("Comic Sans MS 16", msg->title, &text_color);
			clutter_actor_set_position(title, 80, 10);
			clutter_container_add_actor(listContainer, title);

			clutter_actor_set_position(name, 80, 40); 		
		}else{
			clutter_actor_set_position(name, 80, 20); 
		}

		clutter_actor_set_size(name,((35*10)+30), 41);
		clutter_text_set_max_length(CLUTTER_TEXT(name), 20);
		clutter_container_add_actor(listContainer, name);

		clutter_actor_set_size(date,((20*10)), 20);
		clutter_text_set_max_length(CLUTTER_TEXT(date), 16);
		clutter_actor_set_position(date, 600, 10);
		clutter_container_add_actor(listContainer, date);

		//clutter_actor_set_size(message,(88*7)+40, ((MAX/88)*27));
		clutter_actor_set_width(message, (88*7)+40);
		clutter_text_set_max_length(CLUTTER_TEXT(message), MAX);
		clutter_actor_set_position(message, 80, 80); 
		clutter_container_add_actor(listContainer, message);

		messageBackground = clutter_rectangle_new_with_color(&line_color);
		clutter_actor_set_size(messageBackground, 800, 2);

		int h = (clutter_actor_get_height(avatar) + pango_layout_get_line_count(clutter_text_get_layout(CLUTTER_TEXT(message)))*25);

		clutter_actor_set_position(avatar, 10, 1);
		clutter_container_add_actor(listContainer, avatar);

		clutter_actor_set_position(messageBackground, 0, h+10);
		clutter_container_add_actor(listContainer, messageBackground);

		clutter_container_add_actor(messageList, CLUTTER_ACTOR(listContainer));
	}
}

void add_comment(){

	message *msg;
	message *temp = g_list_first(messages)->data;

	time_type now;
	now = get_current_time();

	clear_container(messageList);

	msg = malloc(sizeof(message));
	msg->index = selected_index;	//asd
	msg->msg = malloc((strlen(clutter_text_get_text(CLUTTER_TEXT(text.text)))+1) * sizeof(gchar));

	strcpy(msg->msg, clutter_text_get_text(CLUTTER_TEXT(text.text)));
	strcpy(msg->avatar, "Avatar");
	strcpy(msg->title, temp->title);
	strcpy(msg->sender, "Sender");
	strcpy(msg->time, now.time); 

	messages = g_list_append(messages, (gpointer)msg);

	start_thread_view(messages, id, NULL, selected_index);

}

void end_single_thread(){

	messages = g_list_first(messages);

	//GList *returnableList = messages;

/*
	message *temp = 0;

	if(messages != NULL){
		
		temp = messages->data;

		if(temp->msg != NULL)
		free(temp->msg);

		if(messages->data != NULL)
		free(messages->data);
	
		while(messages->next != NULL)
		{
			messages = messages->next;
				
			temp = messages->data;

			if(temp->msg != NULL)
			free(temp->msg);
				
			if(messages->data != NULL)
			free(messages->data);				
		}
	
	}


	g_list_free(g_list_first(messages));	
*/
	clear_container(messageList);

	if(strcmp(id, "helpdesk") == 0 )
	helpdesk_return_from_threads_view(messages);	//Return the modified messagelist back to its caller.

	else if (strcmp(id, "jammosongs") == 0)
	start_jammosongs();

	else if (strcmp(id, "jammosounds") == 0)
	start_jammosounds();

	else if (strcmp(id, "discuss") == 0)
	start_discussionthreads();

	else {} //do nothing
}
