#include "jammo-chum.h"
#include <tangle.h>

#include "../configure.h" //e.g. DATA_DIR
#include "jammo-editing-track-view.h"
#include "jammo-miditrack-view.h"
#include "../meam/jammo-slider-track.h"
#include "../meam/jammo-backing-track.h"

#include "../cem/cem.h"

//These macros are there because there could be something extra in sequencer_widget which is passed as parameter.
//We do not do anything unless we are sure we have correct real JAMMO_TRACK.

//With first track, start only with linebreak, another add comma and then linebreak
#define FIRST_TRACK_STARTS_WITHOUT_COMMA \
	fprintf(ofp,first_track?"":",\n"); \
	first_track=FALSE;

#define WRITE_VOLUME_AND_MUTED \
	gboolean something_writted=FALSE; \
	if (jammo_playing_track_get_volume(JAMMO_PLAYING_TRACK(track))!= 1.0) {\
		gint buf_len = 10; \
		gchar buffer[buf_len]; \
		gchar* volume = g_ascii_dtostr (buffer, buf_len,jammo_playing_track_get_volume(JAMMO_PLAYING_TRACK(track))); \
		fprintf(ofp,",\n\t\"volume\" : %s\n",volume); \
		something_writted=TRUE; \
		}\
	if (jammo_playing_track_get_muted(JAMMO_PLAYING_TRACK(track))) {\
			fprintf(ofp,",\n\t\"muted\" : \"true\"\n"); \
			something_writted=TRUE; \
			} \
	if (!something_writted) {\
		fprintf(ofp,"\n"); \
	}

/*
-Final filename starts with JAMMO_DIRECTORY,COMPOSITIONS_DIRECTORY
-sequencer_widget must be TangleWdiget and contain track_views and miditrack_view, etc.

-user_metadata will be something differencies between 3-6 game and 7-12 game.
 3-6 game contains info about theme_name and variation
 7-12 game contains info about pitch and tempo

 Will return final filename (with fullpath). User must free it.
*/

gchar* save_composition(gchar* to_filename, ClutterActor* sequencer_widget, gchar* user_metadata) {
	printf("Saving composition.\n");

	//Generate filename based on timestamp
	char timestamp_now [80];
	cem_get_time(timestamp_now);

	guint miditrack_count=0;
	guint slidertrack_count=0;

	FILE* ofp;
	gchar* outputFilename;

	gchar* jammo_directory=configure_get_jammo_directory(); //freed end of this function
	outputFilename = g_strdup_printf("%s/last_composition.json", jammo_directory);

	ofp = fopen(outputFilename, "w");
	g_free(outputFilename);
	g_return_val_if_fail(ofp != NULL, g_strdup_printf("error")); //user want free this

	//'Header'
	fprintf(ofp,"{\n");

	//Metadata
	fprintf(ofp,"%s\n",user_metadata);

	fprintf(ofp,"\"Author\" : \"%s\",\n","author");   //TODO: add author
	fprintf(ofp,"\n");


	//Tracks
	fprintf(ofp,"\"tracks\" : [");
	JammoTrack* track;

	gboolean first_track = TRUE;
	GList* children_view;
	for (children_view = tangle_widget_get_children_readonly(TANGLE_WIDGET(sequencer_widget)); children_view; children_view = children_view->next) {

		ClutterActor* track_view = children_view->data;
		/* //There are something non-track_views on container. FIXME
		if (TANGLE_IS_SCROLLING_ACTOR(track_view)){
			fprintf(ofp,"(scroller)\n");
			continue;
		}
		*/


		if (JAMMO_IS_EDITING_TRACK_VIEW(track_view)){
			FIRST_TRACK_STARTS_WITHOUT_COMMA

			fprintf(ofp,"\n\t{\n");
			fprintf(ofp,"\t\"track-type\" : \"EditingTrack\",\n");

			g_object_get(track_view,"track",&track,NULL);

			JammoSampleType type;
			g_object_get(track_view,"sample-type", &type,NULL);

			GEnumClass* enum_class = G_ENUM_CLASS(g_type_class_ref(JAMMO_TYPE_SAMPLE_TYPE));
			GEnumValue* enum_value = g_enum_get_value(enum_class, type);
			g_type_class_unref(enum_class);
			if (enum_value) {
				const gchar* nick = enum_value->value_nick;
				fprintf(ofp,"\t\"editing-track-type\" : \"%s\",\n",nick);
			}

			fprintf(ofp,"\t\"samples\" : [\n");

			gfloat slot_size;
			g_object_get(track_view,"slot-width",&slot_size,NULL);
			printf("slot_size '%lf'\n",slot_size);

			GList* children;
			JammoSampleButton* jsb;
			gboolean first = TRUE;

			for (children = tangle_widget_get_children_readonly(TANGLE_WIDGET(track_view)); children; children = children->next)
				{
				if (!first)
					fprintf(ofp,",\n");
				first=FALSE;
				jsb = JAMMO_SAMPLE_BUTTON(children->data);
				//printf("x: '%lf' \n",clutter_actor_get_x(CLUTTER_ACTOR(jsb)));
				printf("slot: '%lf' \n",clutter_actor_get_x(CLUTTER_ACTOR(jsb))/slot_size);
				fprintf(ofp,"\t\t{\n");

				//Not saving anymore loop_id. composition_game_file_helper can read old 'format' still
				//gint loop_id;
				//g_object_get(jsb, "loop_id", &loop_id, NULL);
				//fprintf(ofp,"\t\t\"loop_id\" : %d,\n",loop_id);

				gchar* image_filename;
				g_object_get(jsb, "image-filename", &image_filename, NULL);
				fprintf(ofp,"\t\t\"image\" : \"%s\",\n",image_filename);

				gchar* audio_filename;
				g_object_get(jsb, "sample-filename", &audio_filename, NULL);
				fprintf(ofp,"\t\t\"audio\" : \"%s\",\n",audio_filename);

				gint slot = clutter_actor_get_x(CLUTTER_ACTOR(jsb))/slot_size;
				fprintf(ofp,"\t\t\"slot\" : %d\n",slot);
				fprintf(ofp,"\t\t}");
				}
		fprintf(ofp,"\n\t]");
		WRITE_VOLUME_AND_MUTED
		fprintf(ofp,"\t}");
		} //Jammo-Track-View ends


		else if (JAMMO_IS_MIDITRACK_VIEW(track_view)){
			 FIRST_TRACK_STARTS_WITHOUT_COMMA

			g_object_get(track_view,"track",&track,NULL);
			int type;
			g_object_get(track,"instrument-type",&type,NULL);

			fprintf(ofp,"\n\t{\n");
			fprintf(ofp,"\t\"track-type\" : \"VirtualInstrumentTrack\",\n");
			fprintf(ofp,"\t\"instrument\" : %d",type);

			GList* list= jammo_instrument_track_get_event_list(JAMMO_INSTRUMENT_TRACK(track));
			if (list) {
				//fullpath!
				gchar* compositions_directory = configure_get_compositions_directory();
				gchar* name_for_notes = g_strdup_printf("%s/%s%s-midi%d.txt",compositions_directory,to_filename,timestamp_now,miditrack_count);
				g_free(compositions_directory);
				miditrack_count++;
				jammomidi_glist_to_file(list, name_for_notes);

				fprintf(ofp,",\n\t\"note-file\" : \"%s\"",name_for_notes);
				g_free(name_for_notes);
			}
			WRITE_VOLUME_AND_MUTED
			fprintf(ofp,"\t}");
		}//Jammo-Midtrack-View ends

		else if (TANGLE_IS_WIDGET(track_view)){

			track = g_object_get_data(G_OBJECT(track_view), "track");

			if (JAMMO_IS_SLIDER_TRACK(track)) {
			FIRST_TRACK_STARTS_WITHOUT_COMMA
			int type;
			g_object_get(track,"slider-type",&type,NULL);

			fprintf(ofp,"\n\t{\n");
			fprintf(ofp,"\t\"track-type\" : \"SliderTrack\",\n");
			fprintf(ofp,"\t\"instrument\" : \"%d\"",type);

			GList* list= jammo_slider_track_get_event_list(JAMMO_SLIDER_TRACK(track));
			if (list) {
				//fullpath!
				gchar* compositions_directory = configure_get_compositions_directory();
				gchar* name_for_events = g_strdup_printf("%s/%s%s-slider%d.txt",compositions_directory,to_filename,timestamp_now,slidertrack_count);
				g_free(compositions_directory);
				slidertrack_count++;
				jammo_slider_event_glist_to_file(list, name_for_events);

				fprintf(ofp,",\n\t\"note-file\" : \"%s\"",name_for_events);
				g_free(name_for_events);
			}

			WRITE_VOLUME_AND_MUTED
			fprintf(ofp,"\t}");
			}//Jammo-Slider-Track ends

			else if (JAMMO_IS_BACKING_TRACK(track)) {
			FIRST_TRACK_STARTS_WITHOUT_COMMA
			gchar *filename;
			g_object_get(track,"filename",&filename,NULL);

			fprintf(ofp,"\n\t{\n");
			fprintf(ofp,"\t\"track-type\" : \"BackingTrack\",\n");
			fprintf(ofp,"\t\"audio-file\" : \"%s\"",filename);
			WRITE_VOLUME_AND_MUTED
			fprintf(ofp,"\t}");
			}//Jammo-Backing-Track ends


		}


	else {
		//There can be some scrollers or something
	}

}//Next track

	//'Footer'
	fprintf(ofp,"\n\n]\n}\n");
	fclose(ofp);

	//Saving to cupboard
	gchar* cmd;
	gchar* final_filename;
	gchar* compositions_directory = configure_get_compositions_directory();
	final_filename = g_strdup_printf("%s/%s%s.json",compositions_directory,to_filename,timestamp_now);
	g_free(compositions_directory);

	cmd = g_strdup_printf("mv %s/last_composition.json %s",jammo_directory,final_filename);
	g_free(jammo_directory);

	//printf("Executing: '%s'\n",cmd);
	if (system(cmd))
		printf("Error, can't call '%s'\n",cmd);

	g_free(cmd);

	return final_filename;
}



/*
 * JsonNode *sub_node is 'samples' -array
 * JammoEditingTrackView* track_view is target JammoEditingTrackView
 * gboolean reactive : reactivity of each new jammo_sample_button
 */
void load_this_sample_array_to_this_track_view(JsonNode *sub_node,JammoEditingTrackView* track_view, gboolean reactive) {
	//Array
	//sub_node = json_object_get_member (sub_object, "samples");
	if (sub_node!=NULL && JSON_NODE_TYPE (sub_node) == JSON_NODE_ARRAY){
		JsonArray* sample_array =  json_node_get_array (sub_node);

		guint length = json_array_get_length(sample_array);
		//printf("length %d\n",length);
		int i;
		for (i=0;i<length;i++) {
			JsonNode* sample_node;
			sample_node = json_array_get_element(sample_array,i);
			if (sample_node!=NULL && JSON_NODE_TYPE(sample_node) == JSON_NODE_OBJECT){
				JsonObject* sample_object = json_node_get_object(sample_node);
				gint slot=-1;
				gchar* image_file=NULL;
				gchar* audio_file=NULL;

				//string
				sub_node = json_object_get_member (sample_object, "image");
				if (sub_node!=NULL && JSON_NODE_TYPE (sub_node) == JSON_NODE_VALUE){
					image_file =(gchar*)  json_node_get_string (sub_node);
					printf("image: '%s'\n",image_file);
				}
				//string
				sub_node = json_object_get_member (sample_object, "audio");
				if (sub_node!=NULL && JSON_NODE_TYPE (sub_node) == JSON_NODE_VALUE){
					audio_file =(gchar*)  json_node_get_string (sub_node);
					printf("audio: '%s'\n",audio_file);
				}

				//int
				sub_node = json_object_get_member (sample_object, "slot");
				if (sub_node!=NULL && JSON_NODE_TYPE (sub_node) == JSON_NODE_VALUE){
					slot =  json_node_get_int (sub_node);
					//printf("slot: '%d'\n",slot);
				}
				if (track_view) {
					ClutterActor* sample_button=NULL;
					if (image_file && audio_file)
						sample_button = jammo_sample_button_new_from_files(image_file, audio_file);
					if (sample_button) {
						jammo_editing_track_view_add_jammo_sample_button(track_view,JAMMO_SAMPLE_BUTTON(sample_button),slot);
						clutter_actor_set_reactive(sample_button,reactive);
					} //sample_button!=NULL check
				} //track!=NULL check

			} //This sample-object is ready

		} //Foreach in sample-array ready

	} //sample-array is ready

}
