/*
License: GPLv2, read more from COPYING

This file contains the functionality of help menu.
 */
#include <tangle.h>
#include <string.h>
#include "communitymenu.h"
#include "startmenu.h"
#include "../jammo.h"
#include "mysongs.h"
#include "community_utilities.h"

static ClutterContainer *songlist = 0;
static gint listItemHeight = 0;

void start_mysongs()
{
	puts("Starting Mysongs\n");

	int numberOfLoops = 8;

	clutter_actor_hide(jammo_get_actor_by_id("communitymenu-view"));

	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");

	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* help_view = jammo_get_actor_by_id("mysongs-view");

	if(help_view)
	{
		clutter_actor_show(CLUTTER_ACTOR(help_view));

		if(numberOfLoops > 5)
			songlist = CLUTTER_CONTAINER(jammo_get_actor_by_id("mysongs-songs-list-scrollable"));	

		else
			songlist = CLUTTER_CONTAINER(jammo_get_actor_by_id("mysongs-songs-list-unscrollable"));	

		clutter_actor_lower(CLUTTER_ACTOR(songlist),jammo_get_actor_by_id("mysongs_down-index"));

		for(int i = 0; i < numberOfLoops; i++)
			mysongs_add_loop_to_list(NULL, i);	

		ClutterAction *listAction = tangle_actor_get_action_by_type(CLUTTER_ACTOR(songlist), TANGLE_TYPE_SCROLL_ACTION);
	
		g_signal_connect_swapped(listAction, "clamp-offset-y", G_CALLBACK(mysongs_autoscroll_to_correct_pos), songlist);


	}

	else 	puts("can't find 'mysongs-view' ");
}

void mysongs_goto_communitymenu(TangleButton *tanglebutton, gpointer none)
{
	clear_container(songlist);
	start_communitymenu();
}

void mysongs_goto_startmenu(TangleButton *tanglebutton, gpointer none)
{
	clear_container(songlist);
	startmenu_goto_startmenu(tanglebutton, none);
}

void mysongs_autoscroll_to_correct_pos(ClutterActor *listToScroll)
{
	gint slot;
	gfloat not_used, offset;

	ClutterAction *action = tangle_actor_get_action_by_type(listToScroll, TANGLE_TYPE_SCROLL_ACTION);
	
	tangle_scroll_action_get_offsets(TANGLE_SCROLL_ACTION(action), &not_used, &offset);

	slot = (gint)offset % (gint)listItemHeight < listItemHeight / 2 ? (gint)(offset) / listItemHeight  
							  		: (gint)(offset) / listItemHeight + 1;

	tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_OUT_QUAD, 300, "offset-y", (gfloat)(slot*listItemHeight), NULL);
}


gboolean mysongs_add_loop_to_list(char* loopName, int numberOfLoops)
{
	int type = 0;
	int i;

	ClutterActor *colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar12.png",NULL);
	ClutterActor *text = clutter_text_new_with_text("Courier 20", "Test");	
	ClutterActor *infoButton = NULL;

	for(i = 0; i < numberOfLoops; i++)
	{
		if(type == 0) {//TODO Type of the button is determined by the state of the song eg. work in process, video missing etc.
			infoButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
				"/opt/jammo/communitymenu/community_comment_icon.png", NULL));
		}
		else if(type == 1) {
			infoButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
				"/opt/jammo/communitymenu/community_mentor_icon.png", NULL));
			clutter_actor_set_height(infoButton, clutter_actor_get_height(colorbar));
		}
		else {
			infoButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
				"/opt/jammo/communitymenu/community_avatarbackground_small.png", NULL));
		}
		type++;
	}

	ClutterContainer *listContainer = clutter_group_new();

	if(colorbar == NULL || infoButton == NULL)
	{
		printf("Failed to load Colorbar or infoButton\n");
		return FALSE;	
	}

	if(listItemHeight == 0) listItemHeight = clutter_actor_get_height(colorbar);

	clutter_container_add_actor(listContainer, colorbar);		//Add components inside the container

	clutter_actor_set_position(text, 60, 23);			
	clutter_container_add_actor(listContainer, text);
	
	clutter_actor_set_position(infoButton, 690, 0);
	clutter_container_add_actor(listContainer, infoButton);

	g_signal_connect_swapped(CLUTTER_ACTOR(infoButton), "clicked", G_CALLBACK(mysongs_comment), 
						clutter_actor_get_parent(infoButton));

	clutter_container_add_actor(songlist, CLUTTER_ACTOR(listContainer));

	if(numberOfLoops <= 6)
		clutter_actor_set_height(CLUTTER_ACTOR(songlist), listItemHeight * numberOfLoops);	

	else
		clutter_actor_set_height(CLUTTER_ACTOR(songlist), listItemHeight * 6);		

	return TRUE;
}

void mysongs_comment(ClutterActor *actor)
{
	GList *children = clutter_container_get_children(songlist); //Get list of actors
	GList *node = children;

	int index = 0;
	int found = 0;
	
	while(node != NULL)
	{
		index++;

		if(actor == node->data)
		{
			printf("Found it. Index %d\n", index);
			found = 1;
			break;
		}

		node = node->next;
	}

	g_list_free(children);
}
