/*
License: GPLv2, read more from COPYING

This file contains the functionality of JamMo Songs menu.
 */
#include <tangle.h>
#include <glib-object.h>
#include "startmenu.h"
#include <string.h>
#include "community_utilities.h"
#include "../../meam/jammo-sample.h"
#include "jammosongs.h"
#include "../../meam/jammo-recording-track.h"
#include <meam/jammo-meam.h>
#include <meam/jammo-backing-track.h>
#include "single_thread.h"
#include "src/configure.h"


static void autoscroll_to_correct_pos(ClutterActor *listToScroll);
static void on_recording_stopped(JammoSequencer* sequencer, gpointer user_data);
static ClutterContainer *list = 0;
static gint listItemHeight = 0;
static gboolean isrecording_voice_comment = FALSE;
gchar* recording_filename;
JammoSequencer* sequencer;

void start_jammosongs(){

	int numberOfSongs = 6;  //this should contain the number of songs in the list

	printf("Starting JamMoSongs\n");
	
	//clutter_actor_hide(jammo_get_actor_by_id("communitymenu-view"));
	ClutterActor* mainview;
	
	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* jammosongs_view = jammo_get_actor_by_id("jammosongs-view");
				

	if(jammosongs_view){

		clutter_actor_show(CLUTTER_ACTOR(jammosongs_view));

		
		if(numberOfSongs > 5)
			list = CLUTTER_CONTAINER(jammo_get_actor_by_id("jammosongs-songs-list-scrollable"));	

		else
			list = CLUTTER_CONTAINER(jammo_get_actor_by_id("jammosongs-songs-list-unscrollable"));	


		for(int i = 0; i < numberOfSongs; i++){
			add_song_to_list(NULL, i);	
		}

	ClutterAction *listAction = tangle_actor_get_action_by_type(CLUTTER_ACTOR(list), TANGLE_TYPE_SCROLL_ACTION);

	
	g_signal_connect_swapped(listAction, "clamp-offset-y", G_CALLBACK(autoscroll_to_correct_pos), list);

	
	}
	else
		puts("can't find 'jammosongs-view' ");
}


static void autoscroll_to_correct_pos(ClutterActor *listToScroll){

	

	gint slot;
	gfloat not_used, offset;
	ClutterAction *action = tangle_actor_get_action_by_type(listToScroll, TANGLE_TYPE_SCROLL_ACTION);
	

	
	tangle_scroll_action_get_offsets(TANGLE_SCROLL_ACTION(action), &not_used, &offset);
	slot = (gint)offset % (gint)listItemHeight < listItemHeight/2  	? (gint)(offset) / listItemHeight  
							  		: (gint)(offset) / listItemHeight + 1;

	tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_OUT_QUAD, 300, "offset-y", 
				(gfloat)(slot*listItemHeight), NULL);
}


gboolean add_song_to_list(char* loopName, int numberOfSongs){

	ClutterActor *listImage = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar4.png", NULL); //TODO: image color depends on the song

	ClutterContainer *listContainer = CLUTTER_CONTAINER(clutter_group_new());

	ClutterActor *reviewButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
			"/opt/jammo/communitymenu/community_comment_icon.png", NULL));
			
			
	//TODO: add correct font for the text		

	ClutterActor *songName = tangle_button_new_with_background_actor(clutter_text_new_with_text("Times", "Name of the song"));

	if(listImage == NULL)
		return FALSE;	

	if(listItemHeight == 0)
		listItemHeight = clutter_actor_get_height(listImage);

	clutter_container_add_actor(listContainer, listImage);
	
	clutter_actor_set_position(songName, 200, listItemHeight/5*2);
	
	clutter_container_add_actor(listContainer, songName);
	
	//TODO: add following images only if there is a music video or label for the song
	
	ClutterActor *video = tangle_button_new_with_background_actor(clutter_texture_new_from_file("/opt/jammo/communitymenu/community_videocamera_icon_small.png", NULL));
	clutter_actor_set_position(video, 580, listItemHeight/3);
	clutter_container_add_actor(listContainer, video);
	

	ClutterActor *rec = tangle_button_new_with_background_actor
		(clutter_texture_new_from_file("/opt/jammo/sequencer/label_audio.png", NULL));


	clutter_actor_set_position(rec, 660, listItemHeight/3);
	clutter_actor_set_size(rec, 55, 28);
	clutter_container_add_actor(listContainer, rec);	

	ClutterActor *label = tangle_button_new_with_background_actor(clutter_texture_new_from_file("/opt/jammo/communitymenu/community_cdlabel_small.png", NULL));

	clutter_actor_set_position(label, 500, listItemHeight/3);
	clutter_container_add_actor(listContainer, label);
	

	clutter_actor_set_position(CLUTTER_ACTOR(reviewButton), 740, 15);

	clutter_container_add_actor(listContainer, CLUTTER_ACTOR(reviewButton));
	
	g_signal_connect_swapped(reviewButton, "clicked", G_CALLBACK(review_selected_song), 
				clutter_actor_get_parent(reviewButton));
				
	g_signal_connect_swapped(rec, "clicked", G_CALLBACK(rec_press_action), rec);

	g_signal_connect_swapped(songName, "button-press-event", G_CALLBACK(song_name_press_action), songName);
	g_signal_connect_swapped(songName, "button-release-event", G_CALLBACK(song_name_press_action), songName);			
	g_signal_connect_swapped(video, "clicked", G_CALLBACK(show_music_video), songName);
	g_signal_connect_swapped(label, "clicked", G_CALLBACK(show_song_label), songName);	

	clutter_container_add_actor(list, CLUTTER_ACTOR(listContainer));
	
	
	if(numberOfSongs <= 6)
		clutter_actor_set_height(CLUTTER_ACTOR(list), listItemHeight * numberOfSongs);	

	else
		clutter_actor_set_height(CLUTTER_ACTOR(list), listItemHeight * 6);		

	return TRUE;

}


void review_selected_song(ClutterActor *song){

	GList *children = clutter_container_get_children(list);
	GList *messages = NULL;
	
	//TODO: get messages to list
	message *msg;
	int i;
	time_t now;
	
	for(i = 0; i < 3 /*this should be the number of messages*/; i++){
		msg = malloc(sizeof (message));
		msg->msg = malloc(strlen("Message#1")+1);
		sprintf(msg->msg, "Message#%d", i+1);
		strcpy(msg->avatar, "x");
		strcpy(msg->title, "");
		strcpy(msg->sender, "Teppo");
		strcpy(msg->time, "21.1.2011 10:09");

		messages = g_list_append(messages, (gpointer)msg);
	}

	if(isrecording_voice_comment)
		stop_recording();
	
	int first = 0;
	
	if(children != NULL){
		
		do{
			if(first == 0)
				first++;
			else	
				children = children->next;
				
		
			if(song == children->data){
				puts("found it");
				clear_container(list);	
				ClutterActor* mainview = jammo_get_actor_by_id("main-views-widget");
				clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
				start_thread_view(messages, "jammosongs", NULL);
				
				break;
				}
		
		}while(children->next != NULL);
	
	}
	
	g_list_free(children);

}


void end_jammosongs(TangleButton *tanglebutton, gpointer none){

	clear_container(list);

	if(isrecording_voice_comment)
		stop_recording();
   
	if(strcmp(clutter_actor_get_name(CLUTTER_ACTOR(tanglebutton)), "gotocommunity") == 0)
		startmenu_goto_communitymenu(tanglebutton, none);
		
	else
	   startmenu_goto_startmenu(tanglebutton, none);

}


/*********************************
Voice comment recording functions
**********************************/

void record_voice_comment(){

	JammoBackingTrack* backing_track;
	JammoRecordingTrack* recording_track;
	
	gchar* jammo_directory = configure_get_jammo_directory();
	recording_filename = g_strdup_printf("%s/last_recorded.ogg",jammo_directory);
	//recording_filename = g_strdup_printf("/opt/jammo/last_recorded.ogg");
	
	jammo_meam_init(NULL, NULL, "jammo_test_duration_cache"); 	
	
	sequencer = jammo_sequencer_new();
	g_signal_connect(sequencer, "stopped", G_CALLBACK(on_recording_stopped), NULL);

	backing_track = jammo_backing_track_new("/opt/jammo/voice_comment_backing.wav"); // FOR TESTING
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(backing_track)); //max length 30s
	
	recording_track = jammo_recording_track_new_with_pitch_detect(recording_filename);
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(recording_track)); 

	g_free(jammo_directory);
	g_print("Recording...\n");
	g_print("Max length is 30 seconds.\n");

	isrecording_voice_comment = TRUE;

	jammo_sequencer_play(JAMMO_SEQUENCER(sequencer));
}

void stop_recording()
{
	isrecording_voice_comment = FALSE;
	jammo_sequencer_stop(JAMMO_SEQUENCER(sequencer));
}

static void on_recording_stopped(JammoSequencer* sequencer, gpointer user_data) 
{
	g_print("Stopped recording.\n");
	isrecording_voice_comment = FALSE;
}

void rec_press_action(){

	static gboolean isrecording = FALSE;

	if(isrecording == FALSE){
		isrecording = TRUE;
		record_voice_comment();
	}else{
		stop_recording();
		isrecording = FALSE;
	}
}
