/*
License: GPLv2, read more from COPYING

This file contains the functionality of help menu.
 */
#include <tangle.h>
#include <string.h>
#include "communitymenu.h"
#include "startmenu.h"
#include "../jammo.h"
#include "help.h"
#include "community_utilities.h"

static ClutterContainer *questionlist = 0;
static gint listItemHeight = 0;
static int selectedQuestion = 0;
static helpdesk_question_type questions[MAX_QUESTIONS];

TextField addquestion_titleTextField;
TextField addquestion_questionTextField;
TextField question_senderTextField;
TextField question_titleTextField;
TextField question_descriptionTextField;
TextField comment_titleTextField;
TextField comment_descriptionTextField;
TextField comment_replyTextField;

void start_helpdesk()
{
	puts("Starting Helpdesk\n");

	helpdesk_get_questions();
	helpdesk_show_helpdesk_view();
}

void helpdesk_goto_communitymenu(TangleButton *tanglebutton, gpointer none)
{
	clear_container(questionlist);
	start_communitymenu();
}

void helpdesk_goto_startmenu(TangleButton *tanglebutton, gpointer none)
{
	clear_container(questionlist);
	startmenu_goto_startmenu(tanglebutton, none);
}

gboolean helpdesk_mentor_clicked (TangleButton *tanglebutton, gpointer data)   
{
	printf("Mentor Clicked\n");
	return TRUE;
}

void helpdesk_add_comment_to_question(ClutterActor *actor)
{
 	helpdesk_find_selected_actor(actor);
	printf("Adding Comment To Question Number %d\n", selectedQuestion);
	helpdesk_show_comment_view();
}

void helpdesk_view_question(ClutterActor *actor)
{
 	helpdesk_find_selected_actor(actor);
	printf("Viewing Question Number %d\n", selectedQuestion);
	helpdesk_show_question_view();
}

/*****VIEW FUNCTIONS******/
void helpdesk_show_helpdesk_view(void)
{
	int num_of_questions = 0;	//number of questions we have.
	int i;

	for(i = 0; i < MAX_QUESTIONS; i++)
	{
		if(strcmp(questions[i].title, "NULL") != 0)	//Question is not null
		num_of_questions++;

		else break;
	}	

	printf("Founded %d Questions\n", num_of_questions);

	ClutterActor* mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);

	ClutterActor* help_view = jammo_get_actor_by_id("helpdesk-view");

	if(help_view)
	{
		clutter_actor_show(CLUTTER_ACTOR(help_view));

		if(num_of_questions > 0)
			clutter_actor_hide(jammo_get_actor_by_id("helpdesk-no-questions-textfield"));
		else
			clutter_actor_show(jammo_get_actor_by_id("helpdesk-no-questions-textfield"));

		if(num_of_questions > 4)
		{
			questionlist = CLUTTER_CONTAINER(jammo_get_actor_by_id("helpdesk-list-scrollable"));	
			ClutterAction *listAction = tangle_actor_get_action_by_type(CLUTTER_ACTOR(questionlist), TANGLE_TYPE_SCROLL_ACTION);
			g_signal_connect_swapped(listAction, "clamp-offset-y", G_CALLBACK(helpdesk_autoscroll_to_correct_pos), questionlist);
		}
		else	questionlist = CLUTTER_CONTAINER(jammo_get_actor_by_id("helpdesk-list-unscrollable"));

		for(int i = 0; i < num_of_questions; i++) 
			helpdesk_add_loop_to_list(NULL, i);	
	}

	else 	puts("can't find 'helpdesk-view' ");
}

void helpdesk_show_question_view(void)
{
	puts("Starting Question View\n");

	clear_container(questionlist);

	ClutterActor* mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* question_view = jammo_get_actor_by_id("helpdesk-question-view");	

	if(question_view)
	{
		char buf[400];
		clutter_actor_show(CLUTTER_ACTOR(question_view));

		sprintf(buf, "%s", questions[selectedQuestion].sender);
		clutter_text_set_text((ClutterText*)jammo_get_actor_by_id("helpdesk-questionview-textfield-sender"), buf);

		sprintf(buf, "%s", questions[selectedQuestion].title);
		clutter_text_set_text((ClutterText*)jammo_get_actor_by_id("helpdesk-questionview-textfield-title"), buf);

		sprintf(buf, "%s", questions[selectedQuestion].desc);
		clutter_text_set_text((ClutterText*)jammo_get_actor_by_id("helpdesk-questionview-textfield-description"), buf);
	}

	else 	puts("can't find 'helpdesk-question-view' ");
}

void helpdesk_show_comment_view(void)
{
	puts("Starting Comment View\n");

	clear_container(questionlist);

	ClutterActor* mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* comment_view = jammo_get_actor_by_id("helpdesk-comment-view");	

	if(comment_view) 
	{
		char buf[400];

		clutter_actor_show(CLUTTER_ACTOR(comment_view));

		sprintf(buf, "Commenting on question: '%s' sent by user: '%s'", questions[selectedQuestion].title, questions[selectedQuestion].sender);
		clutter_text_set_text((ClutterText*)jammo_get_actor_by_id("helpdesk-commentview-title-textfield"), buf);

		sprintf(buf, "%s", questions[selectedQuestion].desc);
		clutter_text_set_text((ClutterText*)jammo_get_actor_by_id("helpdesk-commentview-description-textfield"), buf);
	}

	else 	puts("can't find 'helpdesk-comment-view' ");
}

void helpdesk_show_addquestion_view(void)
{
	puts("Starting AddQuestion View\n");

	clear_container(questionlist);

	ClutterActor* mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* comment_view = jammo_get_actor_by_id("helpdesk-addquestion-view");	

	if(comment_view) 
	{
		clutter_actor_show(CLUTTER_ACTOR(comment_view));

		clutter_text_set_text((ClutterText*)jammo_get_actor_by_id("helpdesk-addquestion-title"), "Add Your Topic Here");
		clutter_text_set_text((ClutterText*)jammo_get_actor_by_id("helpdesk-addquestion-description"), "Add Your Question Here");

		addquestion_titleTextField.text = jammo_get_actor_by_id("helpdesk-addquestion-title");
		addquestion_titleTextField.lineCount = 3;
		addquestion_titleTextField.handler_id = g_signal_connect_swapped(addquestion_titleTextField.text,
							"text-changed", (GCallback)limit_line_count, &addquestion_titleTextField);		

		addquestion_questionTextField.text = jammo_get_actor_by_id("helpdesk-addquestion-description");
		addquestion_questionTextField.lineCount = 9;
		addquestion_questionTextField.handler_id = g_signal_connect_swapped(addquestion_questionTextField.text,
							"text-changed", (GCallback)limit_line_count, &addquestion_questionTextField);		
	}

	else 	puts("can't find 'helpdesk-addquestion-view' ");
}

void helpdesk_add_question(void)
{
	int i, added = 0;

	puts("Adding Question");


	for(i = 0; i < MAX_QUESTIONS; i++)
	{
		if(strcmp(questions[i].title, "NULL") == 0)	//Empty slot
		{
			strncpy(questions[i].sender, "AAAAAAAAAAAAAAAAAAAAAA", 20);
			questions[i].sender[19] = 0;

			strncpy(questions[i].title, clutter_text_get_text(CLUTTER_TEXT(addquestion_titleTextField.text)), 100);
			questions[i].title[99] = 0;

			strncpy(questions[i].desc, clutter_text_get_text(CLUTTER_TEXT(addquestion_questionTextField.text)), 300);
			questions[i].desc[299] = 0;

			added = 1;
			break;
		}
	}

	if(!added)
	printf("Cannot add questions\n");

	helpdesk_show_helpdesk_view();
}

void helpdesk_get_questions(void)
{
	//TODO: Create code for fetching helpdesk questions from remote server
	puts("Fetching Questions From Community Server");
	/*Initialize question array*/

	int i, j;

	for(i = 0; i < MAX_QUESTIONS; i++)
	{
		sprintf(questions[i].title, "NULL");
		sprintf(questions[i].sender, "NULL");
		sprintf(questions[i].desc, "NULL");
		for(j = 0; j < MAX_COMMENTS; j++)
		{
			sprintf(questions[i].comments[i].sender, "NULL");
			sprintf(questions[i].comments[i].answer, "NULL");
		}
		
	}

}

void helpdesk_autoscroll_to_correct_pos(ClutterActor *listToScroll)
{
	gint slot;
	gfloat not_used, offset;

	ClutterAction *action = tangle_actor_get_action_by_type(listToScroll, TANGLE_TYPE_SCROLL_ACTION);
	
	tangle_scroll_action_get_offsets(TANGLE_SCROLL_ACTION(action), &not_used, &offset);

	slot = (gint)offset % (gint)listItemHeight < listItemHeight / 2 ? (gint)(offset) / listItemHeight  
							  		: (gint)(offset) / listItemHeight + 1;

	tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_OUT_QUAD, 300, "offset-y", (gfloat)(slot*listItemHeight), NULL);
}

gboolean helpdesk_add_loop_to_list(char* loopName, int index)
{		
		ClutterActor *colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar13.png",NULL);
		ClutterActor *avatarImage = clutter_texture_new_from_file("/opt/jammo/communitymenu/community_avatarbackground_small.png", NULL);

		char topictitle[33];

		strncpy(topictitle, questions[index].title, 33);
		topictitle[29] = topictitle[30] = topictitle[31] = '.'; 
		topictitle[32] ='\0';    

		ClutterActor *text = clutter_text_new_with_text("Comic Sans 20", topictitle);	
		ClutterActor *questionButton = tangle_button_new_with_background_actor(text);

		ClutterActor *commentButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
						"/opt/jammo/communitymenu/community_comment_icon.png", NULL));
		ClutterContainer *listContainer = CLUTTER_CONTAINER(clutter_group_new());

		if(avatarImage == NULL || colorbar == NULL || commentButton == NULL)
		{	
			printf("NULL Pointer Detected!\n");
			return FALSE;	
		}

		if(listItemHeight == 0) listItemHeight = clutter_actor_get_height(avatarImage) + 1;

		clutter_actor_set_position(colorbar, 0, listItemHeight - 1);
		clutter_container_add_actor(listContainer, colorbar);		//Add components inside the container
		clutter_container_add_actor(listContainer, avatarImage);
	
		clutter_actor_set_position(questionButton, 60, 23);			
		clutter_container_add_actor(listContainer, questionButton);
	
		clutter_actor_set_position(commentButton, 690, 15);
		clutter_container_add_actor(listContainer, commentButton);

		g_signal_connect_swapped(CLUTTER_ACTOR(questionButton), "clicked", G_CALLBACK(helpdesk_view_question), 
							clutter_actor_get_parent(questionButton));

		g_signal_connect_swapped(CLUTTER_ACTOR(commentButton), "clicked", G_CALLBACK(helpdesk_view_question), 
							clutter_actor_get_parent(commentButton));

		clutter_container_add_actor(questionlist, CLUTTER_ACTOR(listContainer));

		if(index <= 5)
			clutter_actor_set_height(CLUTTER_ACTOR(questionlist), listItemHeight * (index+1));	

		else
			clutter_actor_set_height(CLUTTER_ACTOR(questionlist), listItemHeight * 6);		

		return TRUE;
}

void helpdesk_find_selected_actor(ClutterActor *actor)
{
	GList *children = clutter_container_get_children(questionlist); //Get list of actors
	GList *node = children;

	int index = 0;
	
	while(node != NULL)
	{
		if(actor == node->data)
		{
			selectedQuestion = index;
			break;
		}

		node = node->next;

		index++;
	}

	g_list_free(children);
}

void helpdesk_submit_button_pressed(void)
{
	printf("Submit button pressed. Adding comment to question %d\n", selectedQuestion);
}
