/*
License: GPLv2, read more from COPYING

This file contains the functionality of discuss menu.
 */
#include <tangle.h>
#include <glib-object.h>
#include <math.h>
#include <string.h>
#include <clutter/clutter.h>
#include "discuss.h"
#include "communitymenu.h"
#include "startmenu.h"
#include "single_thread.h"
#include "community_utilities.h"

static void autoscroll_to_correct_pos(ClutterActor *list_);

ClutterColor line_color = { 144, 148, 140, 255 };
ClutterColor text_color = { 237, 28, 36, 255 };
ClutterColor text_color2 = { 0, 0, 0, 255 };
ClutterContainer *list = 0;
ClutterContainer *threadslist = 0;
ClutterContainer *downmenu = 0;
GList* messages = NULL;
gchar *entries[] = {"MUSIC MAKING", "HOBBIES", "FRIENDS", "SCHOOL", "OTHER STUFF", "ABOUT JAMMO"}; // Testing
static gint item_height = 0;
static thread_type threads[MAX_THREADS];
static int entries_size = 6;
static int threads_size = 6;
static int messages_size = 6;


void start_discuss(){
	
	printf("Starting Discuss\n");	
	
	clutter_actor_hide(jammo_get_actor_by_id("communitymenu-view"));

	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");

	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);

	ClutterActor* discuss_view = jammo_get_actor_by_id("discuss-view");

	if(discuss_view){
		clutter_actor_show(CLUTTER_ACTOR(discuss_view));
		
		if(entries_size > 5){
			list = CLUTTER_CONTAINER(jammo_get_actor_by_id("discuss-view-container"));	
		}else{
			list = CLUTTER_CONTAINER(jammo_get_actor_by_id("discuss-view-container-unscrollable"));
		}

		for(int i = 0; i < (entries_size); i++){ 
			addDiscussion(entries[i], i);	
		}

		clutter_actor_raise( CLUTTER_ACTOR(jammo_get_actor_by_id("bg2")), CLUTTER_ACTOR(list) );
		clutter_actor_raise( CLUTTER_ACTOR(jammo_get_actor_by_id("discussview-gotocommunity")) , CLUTTER_ACTOR(jammo_get_actor_by_id("bg2")) );
		clutter_actor_raise( CLUTTER_ACTOR(jammo_get_actor_by_id("discussview-mentor")) , CLUTTER_ACTOR(jammo_get_actor_by_id("bg2")) );
		clutter_actor_raise( CLUTTER_ACTOR(jammo_get_actor_by_id("discussview-gohome")) , CLUTTER_ACTOR(jammo_get_actor_by_id("bg2")) );

		ClutterAction* action = tangle_actor_get_action_by_type(CLUTTER_ACTOR(list), TANGLE_TYPE_SCROLL_ACTION);
		g_signal_connect_swapped(action, "clamp-offset-y", G_CALLBACK(autoscroll_to_correct_pos), list);

	}else{
		puts("can't find 'discuss-view' ");
	}
}


gboolean addDiscussion(char* name, int number){
	
	ClutterActor *line;
	ClutterActor *cont = CLUTTER_ACTOR(clutter_group_new());
	ClutterActor *arrow = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
				"/opt/jammo/communitymenu/community_rightarrow.png", NULL));
	line = create_line(73, 800, 2, CLUTTER_CONTAINER(cont));
        
	ClutterActor *title = clutter_text_new_full("Comic Sans MS 16", name, &text_color);
	clutter_text_set_max_length(CLUTTER_TEXT(title), 15);
	clutter_actor_set_size(title, ((15*10)+30), 51); 

	ClutterActor *discussion = tangle_button_new_with_background_actor(title);	

	if(line == NULL || arrow == NULL || name == NULL)
		return 1;

	if(item_height == 0)
		item_height = 75;

        clutter_actor_set_position(arrow, 550, 12);
	clutter_container_add_actor(CLUTTER_CONTAINER(cont), arrow);
        
	clutter_container_add_actor(CLUTTER_CONTAINER(cont), discussion);
	clutter_actor_set_position(discussion, 320, 20);

	g_signal_connect_swapped(arrow, "clicked", G_CALLBACK(getDiscussion), clutter_actor_get_parent(arrow));
	g_signal_connect_swapped(CLUTTER_ACTOR(discussion), "clicked", G_CALLBACK(getDiscussion), clutter_actor_get_parent(discussion));
	
	clutter_container_add_actor(list, cont);
	
	if(number <= 6){
		clutter_actor_set_height(CLUTTER_ACTOR(list), item_height * number);
	}else{
		clutter_actor_set_height(CLUTTER_ACTOR(list), item_height * 6);
	}

	return 0;
}


gboolean addThread(char* name, int number){
	
	ClutterActor *line;
	ClutterActor *cont = CLUTTER_ACTOR(clutter_group_new());

	ClutterActor *avatarbg = tangle_button_new_with_background_actor(clutter_texture_new_from_file( 
			"/opt/jammo/communitymenu/community_avatarbackground_small.png", NULL)); 
		
	ClutterActor *comment = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
				"/opt/jammo/communitymenu/community_comment_icon.png", NULL)); 

	line = create_line(74, 640, 1, CLUTTER_CONTAINER(cont));

	ClutterActor *text = clutter_text_new_full("Comic Sans MS 16", name, &text_color2);
        clutter_actor_set_size(text, ((35*10)+30), 51);
	clutter_text_set_max_length(CLUTTER_TEXT(text), 35);
	
	ClutterActor *title = tangle_button_new_with_background_actor(text);	

	if(line == NULL || comment == NULL || avatarbg == NULL|| name == NULL)
		return 1;

	if(item_height == 0)
		item_height = 75;

        clutter_actor_set_position(comment, 690, 15);
	clutter_container_add_actor(CLUTTER_CONTAINER(cont), comment);

        clutter_actor_set_position(avatarbg, 10, 1);
	clutter_container_add_actor(CLUTTER_CONTAINER(cont), avatarbg);

	clutter_container_add_actor(CLUTTER_CONTAINER(cont), title);
	clutter_actor_set_position(title, 80, 20);

	g_signal_connect_swapped(CLUTTER_ACTOR(title), "clicked", G_CALLBACK(getThread), clutter_actor_get_parent(title));
	g_signal_connect_swapped(comment, "clicked", G_CALLBACK(getThread), clutter_actor_get_parent(comment));
	
	clutter_container_add_actor(threadslist, cont);
	
	if(number <= 6){
		clutter_actor_set_height(CLUTTER_ACTOR(threadslist), item_height * number);
	}else{
		clutter_actor_set_height(CLUTTER_ACTOR(threadslist), item_height * 6); 
	}

	return 0;
}


/***************************
Drawing functions
**************************/

ClutterActor *create_line(int y, int length, int size, ClutterContainer *cont) {

        ClutterActor *line = clutter_rectangle_new_with_color(&line_color);
        clutter_actor_set_size(line, length, size);
        clutter_actor_set_position(line, 0, y);

        clutter_container_add_actor(CLUTTER_CONTAINER(cont), line);
        clutter_actor_show(line);

        return line;
}

/***************************
Functions for json
**************************/


void discuss_community_clicked (TangleButton* tanglebutton, gpointer none){

	clear_container(CLUTTER_CONTAINER(list));
	clear_container(CLUTTER_CONTAINER(threadslist));	
	clear_container(CLUTTER_CONTAINER(downmenu));
	
	printf("\nclear_containered containers\n\n");

	startmenu_goto_communitymenu(NULL,NULL);
}

void discuss_home_clicked (TangleButton* tanglebutton, gpointer none){
	
	clear_container(CLUTTER_CONTAINER(list));
	clear_container(CLUTTER_CONTAINER(threadslist));
	clear_container(CLUTTER_CONTAINER(downmenu));
	printf("\nclear_containered containers\n\n");

	startmenu_goto_startmenu(NULL,NULL);
}


gboolean discuss_mentor_clicked (TangleButton *tanglebutton, gpointer data)   {
	printf("mentor clicked\n");

	return TRUE;
}

gboolean discuss_writenew_clicked (TangleButton *tanglebutton, gpointer data)   {
	printf("making new thread...\n");

	return TRUE;
}


/***************************
Callback functions
**************************/


static void autoscroll_to_correct_pos(ClutterActor *list_){

	gint slot;
	gfloat not_used, offset;
	
	ClutterAction *action = tangle_actor_get_action_by_type(list_, TANGLE_TYPE_SCROLL_ACTION);
	
	tangle_scroll_action_get_offsets(TANGLE_SCROLL_ACTION(action), &not_used, &offset);
	slot = (gint)offset % (gint)item_height < item_height/2  	? (gint)(offset) / item_height  
							  		: (gint)(offset) / item_height + 1;

	tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_OUT_QUAD, 300, "offset-y", 
				(gfloat)(slot*item_height), NULL);
}


void getDiscussion(ClutterActor *element){

	GList *children = clutter_container_get_children(list);
	int i = 0;
	int index = 0;
	
	if(children != NULL){
		
		do{
			if(i == 0){
				i++;
			}else{	
				children = children->next;
				index++;
			}
				
			if(element == children->data){
				printf("Clicked element: %s\n", entries[index]);
				discuss_change_to_discussion_threads_view(NULL, NULL);
				break;
			}
		
		}while(children->next != NULL);
	}
	g_list_free(children);
}


void getThread(ClutterActor *element){

	GList *children = clutter_container_get_children(threadslist);
	int i = 0;
	int index = 0;

	if(children != NULL){
		
		do{
			if(i == 0){
				i++;
			}else{	
				children = children->next;
				index++;
			}
				
			if(element == children->data){
				printf("Clicked element: %s\n", threads[index].title);

				getAllMessages(""); // ONLY TESTING
				
				clear_container(threadslist);
				clear_container(downmenu);
	
				ClutterActor* mainview = jammo_get_actor_by_id("main-views-widget");
				clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);

				start_thread_view(messages, "discuss", NULL); // Testing

				break;
			}
		
		}while(children->next != NULL);
	}
	g_list_free(children);

}

void add_new_thread(){

	static gboolean is_title_ok = FALSE;
	static gboolean is_msg_ok = FALSE;

	puts("Adding thread...");

	ClutterActor *title = jammo_get_actor_by_id("title");
	ClutterActor *description = jammo_get_actor_by_id("description");

	if(strlen(clutter_text_get_text(CLUTTER_TEXT(title))) < 3){
		//TO-DO: jokin varoitus että title on oltava!
		printf("Title must be at least 3 characters long!\n");

		is_title_ok = FALSE;
	}else{
		is_title_ok = TRUE;
		printf("Title ok.\n");
	}

	if(strlen(clutter_text_get_text(CLUTTER_TEXT(description))) < 10){
		//TO-DO: jokin varoitus että msg on oltava!
		printf("Message must be longer than 10 characters!\n");

		is_msg_ok = FALSE;
	}else{
		is_msg_ok = TRUE;
		printf("Msg ok.\n");	
	}

	if(is_title_ok == TRUE && is_msg_ok == TRUE){

		thread_type t;
		strcpy(t.title, clutter_text_get_text(CLUTTER_TEXT(title)) );
		//TO-DO: loput kentät

		threads_size++;
		threads[threads_size-1] = t;

		clutter_text_set_text (CLUTTER_TEXT(jammo_get_actor_by_id("title")),"");
		clutter_text_set_text (CLUTTER_TEXT(jammo_get_actor_by_id("description")),"");

		printf("Added thread.\n");
		start_discussionthreads();
	}else{
		printf("Cannot add thread.\n");
	}
}


void discuss_change_to_add_thread_view(){

	printf("changing view to add thread view\n");

	clear_container(threadslist);
	clear_container(downmenu);

	start_addthread_view();
}


gboolean discuss_change_to_discussion_threads_view(TangleActor *actor, gpointer data) {

	printf("changing view to discussion threads\n");

	clear_container(list);
	start_discussionthreads(); 

	return TRUE;
}


gboolean discuss_change_to_discussion_view(TangleActor *actor, gpointer data) {

	printf("changing view to discussion view\n");

	clear_container(threadslist);
	clear_container(downmenu);

	start_discuss(); 

	return TRUE;
}


void start_discussionthreads(){

	int numberOfThreads = 6;

	clutter_actor_hide(jammo_get_actor_by_id("discuss-view"));

	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");

	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL); 

	ClutterActor* discussion_threads_view = jammo_get_actor_by_id("threads-view");

	if(threads_size == 6)	
		getAllThreads(); 

	if(discussion_threads_view)
	{
		clutter_actor_show(CLUTTER_ACTOR(discussion_threads_view));

		if(numberOfThreads > 5)
			threadslist = CLUTTER_CONTAINER(jammo_get_actor_by_id("threads-view-list-scrollable"));	
		else
			threadslist = CLUTTER_CONTAINER(jammo_get_actor_by_id("threads-view-list-unscrollable"));

		clutter_actor_raise( CLUTTER_ACTOR(jammo_get_actor_by_id("threads_view_gotocommunity")) , CLUTTER_ACTOR(jammo_get_actor_by_id(
													"threads-view_down-index")) );
		clutter_actor_raise( CLUTTER_ACTOR(jammo_get_actor_by_id("threads_view-mentor")) , CLUTTER_ACTOR(jammo_get_actor_by_id(
													"threads-view_down-index")) );
		clutter_actor_raise( CLUTTER_ACTOR(jammo_get_actor_by_id("threads_view_gohome")) , CLUTTER_ACTOR(jammo_get_actor_by_id(
													"threads-view_down-index")) );

		clutter_actor_lower(jammo_get_actor_by_id("threads-view_right-index"),jammo_get_actor_by_id("threads-view_down-index"));
		clutter_actor_lower(CLUTTER_ACTOR(threadslist),jammo_get_actor_by_id("threads-view_down-index"));

		clutter_actor_raise(CLUTTER_ACTOR(jammo_get_actor_by_id("backtotopics")), CLUTTER_ACTOR(jammo_get_actor_by_id(
												"threads-view_down-index")) );

		clutter_actor_raise(CLUTTER_ACTOR(jammo_get_actor_by_id("threads_view_writing-tool")), CLUTTER_ACTOR(jammo_get_actor_by_id(
												"threads-view_down-index")) );
		
		int i = 0;

		for(i=0; i<threads_size; i++){
			addThread(threads[i].title, i); 
		}

		ClutterAction* action = tangle_actor_get_action_by_type(CLUTTER_ACTOR(threadslist), TANGLE_TYPE_SCROLL_ACTION);
		g_signal_connect_swapped(action, "clamp-offset-y", G_CALLBACK(autoscroll_to_correct_pos), CLUTTER_ACTOR(threadslist));


	}else{
		puts("can't find 'discuss-container-for-discussion-threads' ");
	}

}


void start_addthread_view(){

	ClutterActor* mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* view = jammo_get_actor_by_id("addthread-view");	

	if(view){
		clutter_actor_show(CLUTTER_ACTOR(view));
	}else {	
		puts("can't find 'addthread-view' ");
	}

}


/***************************
Database functions
**************************/

void getAllThreads(){

	int i;

	// FOR TESTING ONLY
	gchar *topics[] = {"I got stuck. HELP ME!","How do I find my finished songs...","How to import samples from the web","How to make pancakes","How to win in lottery","How to learn C and clutter"}; 

	thread_type temp;

	for(i=0; i<6; i++){
		strcpy(temp.title, topics[i]);
		threads[i] = temp;
	}
	
}


void getAllMessages(gchar *id){

	// JUST FOR TESTING
	gchar *names[] = {"Sami", "Paavo", "Esa", "Kalle", "Pertti", "Taavi"}; 
	gchar *topics[] = {"I got stuck. HELP ME!","How do I find my finished songs...","How to import samples from the web","How to make pancakes","How to win in lottery","How to learn C and clutter"}; 

	gchar *fakemsg = "Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Typi non habent claritatem insitam; est usus legentis in iis qui facit eorum claritatem. Investigationes demonstraverunt lectores legere me lius quod ii legunt saepius. Claritas est etiam processus dynamicus, qui sequitur mutationem consuetudium lectorum. Mirum est notare quam littera gothica, quam nunc putamus parum claram, anteposuerit litterarum formas humanitatis per seacula quarta decima et quinta decima. Eodem modo typi, qui nunc nobis videntur parum clari, fiant sollemnes in futurum.";

	message *msg;
	time_type tmp;


	//if(messages_param == NULL){
		
		for(int i = 0; i < messages_size ; i++){

			msg = malloc(sizeof(message));

			strcpy(msg->avatar, names[i]);
			strcpy(msg->sender, names[i]);
		
			//if(id != NULL){
				//strcpy(msg->title, id);
			
			strcpy(msg->title, topics[i]);
		
			tmp = get_current_time();
			strcpy(msg->time, tmp.time); 

			msg->msg = malloc((strlen(fakemsg)+1) *sizeof(gchar));
			strcpy(msg->msg, fakemsg); 

			messages = g_list_append(messages, (gpointer)msg);
		}	
	
}

void getAllTopics(){
	//do nothing
}
