#include "avatar_editor.h"
#include "startmenu.h"
#include "../jammo.h"
#include "communitymenu.h"
#include "community_utilities.h"
#include "string.h"

static void end_avatar_view();

ClutterContainer *partsList;
ClutterContainer *avatar = 0;
typedef enum{BLACK, BLOND, BLUE, BROWN, DARKBROWN, GRAY, ORANGE, VIOLET, WHITE}HAIR_COLOR;
typedef enum{BROWN_HEAD, DARK_HEAD, PINK_HEAD, YELLOW_HEAD}HEADS;
const int NUMBEROFCOLORS = 9;
const int NUMBEROFHEADS = 4;
HAIR_COLOR hairColor;
HEADS heads = YELLOW_HEAD;
char currentHairType[50];
gboolean hairsInList = FALSE;
ClutterActor *body = 0;
ClutterActor *hair = 0;
ClutterActor *head = 0;
ClutterActor *instrument = 0;
ClutterActor *instrumentBackground = 0;
TextField hobbiesTextField;
TextField nameTextField;
TextField genderTextField;

void avatar_text_inserted(ClutterActor*);

void start_avatar_editor(){

	printf("Starting avatar editor\n");

	ClutterActor* mainview;
	
	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* avatarView = jammo_get_actor_by_id("avatar-view");
	
	if(avatarView){
		
		clutter_actor_show(CLUTTER_ACTOR(avatarView)); 
		
		partsList = CLUTTER_CONTAINER(jammo_get_actor_by_id("avatar-parts-list"));

		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("avatar_hobbies_text")), _("HOBBIES:"));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("avatar_name_text")), _("NAME:"));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("avatar_gender_text")), _("GENDER:"));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("avatar_instrument_text")), _("FAVOURITE INSTRUMENT:"));
		
		
		
		hobbiesTextField.text = jammo_get_actor_by_id("avatar_hobbies_textfield");
		clutter_text_set_text(CLUTTER_TEXT(hobbiesTextField.text), _("<<YOUR HOBBIES HERE>>"));
		hobbiesTextField.lineCount = 2;
		hobbiesTextField.handler_id = g_signal_connect_swapped(hobbiesTextField.text, "text-changed", (GCallback)limit_line_count, &hobbiesTextField);
 
		
		nameTextField.text = jammo_get_actor_by_id("avatar_name_textfield");
		clutter_text_set_text(CLUTTER_TEXT(nameTextField.text), _("<<YOUR NAME HERE>>"));
		nameTextField.lineCount = 1;
		nameTextField.handler_id = g_signal_connect_swapped(nameTextField.text, "text-changed", (GCallback)limit_line_count, &nameTextField);		
		
		genderTextField.text = jammo_get_actor_by_id("avatar_gender_textfield");
		clutter_text_set_text(CLUTTER_TEXT(genderTextField.text), _("<<YOUR GENDER HERE>>"));
		genderTextField.lineCount = 1;
		genderTextField.handler_id = g_signal_connect_swapped(genderTextField.text, "text-changed", (GCallback)limit_line_count, &genderTextField);					
	
		set_avatar();
	
	}


}


//this function should get existing user avatar, otherwise it sets default avatar visible
void set_avatar(){

	if(instrumentBackground == 0){

	}

	if(body == 0)
		body = clutter_texture_new_from_file("/opt/jammo/communitymenu/AVATAR_PARTS/bodys/body_blue.png", NULL);
	
	if(head == 0)
		head = clutter_texture_new_from_file("/opt/jammo/communitymenu/AVATAR_PARTS/heads/head_yellow.png", NULL);
	

	if(avatar == 0){
		avatar = CLUTTER_CONTAINER(jammo_get_actor_by_id("avatar-widgets")); 

	}
	
	
	clutter_container_add_actor(avatar, head);
	clutter_actor_set_position(head, 92, 85);
	
	clutter_container_add_actor(avatar, body);
	clutter_actor_set_position(body, 65, 170);
	
	if(instrument != 0){

		if(instrumentBackground == 0){
			instrumentBackground = clutter_texture_new_from_file("/opt/jammo/communitymenu/community_avatar_avatarbackground.png", NULL);
			clutter_actor_set_size(instrumentBackground, 110, 110);
			clutter_actor_set_position(instrumentBackground, 503, 238);
			clutter_container_add_actor(avatar, instrumentBackground);
		}		
		
		clutter_actor_set_position(instrument, 510, 245);
		clutter_container_add_actor(avatar, instrument);
	}
	
	
	if(hair != 0){
	
		clutter_container_add_actor(avatar, hair);
		
	
		//this must be done since each hair image requires own coordinates
		
		if(strstr(clutter_actor_get_name(hair), "hair_bush.png"))
			clutter_actor_set_position(hair, 85, 70);
		if(strstr(clutter_actor_get_name(hair), "hair_centerspread.png"))
			clutter_actor_set_position(hair, 70, 80);		
		if(strstr(clutter_actor_get_name(hair), "hair_centerspread2.png"))
			clutter_actor_set_position(hair, 80, 70);
		if(strstr(clutter_actor_get_name(hair), "hair_centerspread3.png"))
			clutter_actor_set_position(hair, 83, 72);
		if(strstr(clutter_actor_get_name(hair), "hair_centerspread4.png"))
			clutter_actor_set_position(hair, 90, 79);
		if(strstr(clutter_actor_get_name(hair), "hair_centerspread5.png"))
			clutter_actor_set_position(hair, 92, 81);
		if(strstr(clutter_actor_get_name(hair), "hair_emo.png"))
			clutter_actor_set_position(hair, 89, 78);
		if(strstr(clutter_actor_get_name(hair), "hair_long.png"))
			clutter_actor_set_position(hair, 80, 69);
		if(strstr(clutter_actor_get_name(hair), "hair_longcurly.png"))
			clutter_actor_set_position(hair, 78, 73);
		if(strstr(clutter_actor_get_name(hair), "hair_longcurly2.png"))
			clutter_actor_set_position(hair, 80, 72);
		if(strstr(clutter_actor_get_name(hair), "hair_mohawk.png"))
			clutter_actor_set_position(hair, 106, 60);
		if(strstr(clutter_actor_get_name(hair), "hair_ponytails.png"))
			clutter_actor_set_position(hair, 75, 75);
		if(strstr(clutter_actor_get_name(hair), "hair_punk.png"))
			clutter_actor_set_position(hair, 80, 64);
		if(strstr(clutter_actor_get_name(hair), "hair_punk2.png"))	
			clutter_actor_set_position(hair, 50, 35);
		if(strstr(clutter_actor_get_name(hair), "hair_top.png"))	
			clutter_actor_set_position(hair, 100, 80);
		
	}
	
	clutter_actor_raise(body, head);
	if(hair != 0)
		clutter_actor_raise(hair, head);

}

void pressed(ClutterActor *actor){

	char *temp;

	if(strstr(clutter_actor_get_name(actor), "/opt/jammo/communitymenu/AVATAR_PARTS/bodys")){
		hairsInList = FALSE;
		DESTROY_ACTOR(body);
		body = clutter_texture_new_from_file(clutter_actor_get_name(actor), NULL);
		
		}
		
	if(strstr(clutter_actor_get_name(actor), "/opt/jammo/communitymenu/AVATAR_PARTS/hairs")){
	
		DESTROY_ACTOR(hair);
			
		hair = clutter_texture_new_from_file(clutter_actor_get_name(actor), NULL);
		temp = strstr(clutter_actor_get_name(actor), "hairs/");
		temp = strpbrk(temp, "/");
		temp++;
		temp = strpbrk(temp, "/");
		temp++;
		strcpy(currentHairType, temp);
		clutter_actor_set_name(hair, clutter_actor_get_name(actor));
		}	

	if(strstr(clutter_actor_get_name(actor), "/opt/jammo/wheel_game")){
	
		hairsInList = FALSE;
	
		DESTROY_ACTOR(instrument);
		instrument = clutter_texture_new_from_file(clutter_actor_get_name(actor), NULL);

		}

	set_avatar();

}

void change_body_color(){

	puts("changing body color");
	
	clear_container(partsList);
	
	const char path[100] = "/opt/jammo/communitymenu/AVATAR_PARTS/bodys/";
	
	
	if(!add_images_from_directory(path, partsList, (GCallback)pressed, 100, 100)){
		puts("can't open directory containing avatar parts");
		
	}
	

		
}

void change_hair_color(){
	
	char path[150] = "/opt/jammo/communitymenu/AVATAR_PARTS/hairs/";
	
	puts("changing hair color");
	

	hairColor = (hairColor+1) % NUMBEROFCOLORS;
	
	strcat(path, hairColor == BLACK ? "black/" :
			     hairColor == BLOND ? "blond/" :
			     hairColor == BLUE ? "blue/" :
			     hairColor == BROWN ? "brown/" :
			     hairColor == DARKBROWN ? "darkbrown/" :
			     hairColor == GRAY ? "gray/" :
			     hairColor == ORANGE ? "orange/" :
			     hairColor == VIOLET ? "violet/" :
			     hairColor == WHITE ? "white/" : "");
			     
	if(hair != 0){
		strcat(path, currentHairType);	     
	
		DESTROY_ACTOR(hair);
		hair = clutter_texture_new_from_file(path, NULL);
		clutter_actor_set_name(hair, path);
		set_avatar();

	}
	
	if(hairsInList)
		change_hair_type();
}

void change_hair_type(){

	puts("changing hair type");
	
	hairsInList = TRUE;

	clear_container(partsList);
	
	char path[100];
	
	if(hairColor == BLACK) strcpy(path, "/opt/jammo/communitymenu/AVATAR_PARTS/hairs/black/");
	if(hairColor == BLOND) strcpy(path, "/opt/jammo/communitymenu/AVATAR_PARTS/hairs/blond/");
	if(hairColor == BLUE) strcpy(path,"/opt/jammo/communitymenu/AVATAR_PARTS/hairs/blue/");
	if(hairColor == BROWN) strcpy(path, "/opt/jammo/communitymenu/AVATAR_PARTS/hairs/brown/");
	if(hairColor == DARKBROWN) strcpy(path, "/opt/jammo/communitymenu/AVATAR_PARTS/hairs/darkbrown/");
	if(hairColor == GRAY) strcpy(path,"/opt/jammo/communitymenu/AVATAR_PARTS/hairs/gray/");
	if(hairColor == ORANGE) strcpy(path, "/opt/jammo/communitymenu/AVATAR_PARTS/hairs/orange/");
	if(hairColor == VIOLET) strcpy(path,"/opt/jammo/communitymenu/AVATAR_PARTS/hairs/violet/");
	if(hairColor == WHITE) strcpy(path,"/opt/jammo/communitymenu/AVATAR_PARTS/hairs/white/");

	
	if(!add_images_from_directory(path, partsList, (GCallback)pressed, 100, 100))
		puts("can't open directory containing avatar parts");
		
	

}

void change_head(){

	char path[150] = "/opt/jammo/communitymenu/AVATAR_PARTS/heads/";
	
	hairsInList = FALSE;

	puts("changing head");
	
	clear_container(partsList);
	
	heads = (heads+1)%NUMBEROFHEADS;	

	strcat(path, heads == DARK_HEAD ? "head_dark.png" :
		     heads == BROWN_HEAD ? "head_brown.png" :
		     heads == YELLOW_HEAD ? "head_yellow.png" :
		     heads == PINK_HEAD ? "head_pink.png" : "");
		     
	DESTROY_ACTOR(head);
	head = clutter_texture_new_from_file(path, NULL);
		     
	set_avatar();
	
}


void change_instrument(){

	puts("changing instrument");
	
	clear_container(partsList);
	
	ClutterActor* button = 0;

	
	//exemplary hard-coding, maybe there should be instrument directory in communitymenu...
	
	add_single_button(button, partsList, "/opt/jammo/wheel_game/accordion.png", 100, 100, (GCallback)pressed);	
	add_single_button(button, partsList, "/opt/jammo/wheel_game/acoustic_drumkit.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/acoustic_guitar.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/banjo.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/brass.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/cahon.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/cello.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/clavinet.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/darabouka.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/double_bass.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/electric_bass.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/electric_bass2.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/electric_drums.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/electric_guitar.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/electric_piano.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/ethnic_percussion.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/flute.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/glockenspiel.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/harp.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/mandolin.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/marimba.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/oboe.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/organ.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/oud.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/piano.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/saxophone.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/shaker.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/strings.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/synthesizer.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/synthlead.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/tambourine.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/trombone.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/trumpet.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/vibraphone.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/violin.png", 100, 100, (GCallback)pressed);
	add_single_button(button, partsList, "/opt/jammo/wheel_game/xylophone.png", 100, 100, (GCallback)pressed);


}


//For cleanupping
static void end_avatar_view() {
	
	clear_container(partsList);
	
	DESTROY_ACTOR(body);
	DESTROY_ACTOR(hair);
	DESTROY_ACTOR(head);
	DESTROY_ACTOR(instrument);
	DESTROY_ACTOR(instrumentBackground);
	
	partsList = 0;
	avatar = 0;	
}

void avatar_goto_communitymenu(TangleButton *tanglebutton, gpointer none)
{
	end_avatar_view();
	start_communitymenu();
}

void avatar_goto_startmenu(TangleButton *tanglebutton, gpointer none)
{
	end_avatar_view();
	startmenu_goto_startmenu(tanglebutton, none);
}
