 /*
License: GPLv2, read more from COPYING

This file contains the functionality of Help menu.
 */

#ifndef HELP_H_
#define HELP_H_

#include <glib-object.h>

void start_helpdesk();
void helpdesk_get_questions(void);

void helpdesk_goto_communitymenu(TangleButton *tanglebutton, gpointer none);
void helpdesk_goto_startmenu(TangleButton *tanglebutton, gpointer none);

//Functions for creating and moving loops
gboolean helpdesk_add_loop_to_list(char* loopName, int numberOfLoops);
void helpdesk_autoscroll_to_correct_pos(ClutterActor *listToScroll);
void helpdesk_find_selected_actor(ClutterActor *actor);

//Signal functions
void helpdesk_add_comment_to_question(ClutterActor *actor);
void helpdesk_add_question(void);
void helpdesk_view_question(ClutterActor *actor);
void helpdesk_submit_button_pressed(void);

void helpdesk_show_question_view(void);
void helpdesk_show_comment_view(void);
void helpdesk_show_helpdesk_view(void);

typedef struct {
	char sender[20];
	char answer[150];
}comment_type;

typedef struct {
	char sender[20];
	char title[50];
	char desc[300];
	comment_type comments[10];
}helpdesk_question_type;
	


#endif 
