/*
License: GPLv2, read more from COPYING

This file contains the functionality of help menu.
 */
#include <tangle.h>
#include <string.h>
#include "communitymenu.h"
#include "startmenu.h"
#include "../jammo.h"
#include "help.h"
#include "community_utilities.h"

static ClutterContainer *questionlist = 0;
static gint listItemHeight = 0;
static int selectedQuestion = 0;
static int numberOfLoops = 8;
static helpdesk_question_type questions[10];

void start_helpdesk()
{
	puts("Starting Helpdesk\n");
	clutter_actor_hide(jammo_get_actor_by_id("communitymenu-view"));
	helpdesk_show_helpdesk_view();
}

void helpdesk_goto_communitymenu(TangleButton *tanglebutton, gpointer none)
{
	clear_container(questionlist);
	start_communitymenu();
}

void helpdesk_goto_startmenu(TangleButton *tanglebutton, gpointer none)
{
	clear_container(questionlist);
	startmenu_goto_startmenu(tanglebutton, none);
}

gboolean helpdesk_mentor_clicked (TangleButton *tanglebutton, gpointer data)   
{
	printf("Mentor Clicked\n");
	return TRUE;
}

void helpdesk_find_selected_actor(ClutterActor *actor)
{
	GList *children = clutter_container_get_children(questionlist); //Get list of actors
	GList *node = children;

	int index = 0;
	
	while(node != NULL)
	{
		index++;

		if(actor == node->data)
		{
			selectedQuestion = index;
			break;
		}

		node = node->next;
	}

	g_list_free(children);
}

void helpdesk_add_comment_to_question(ClutterActor *actor)
{
	puts("Adding Comment\n");
 	helpdesk_find_selected_actor(actor);
	helpdesk_show_comment_view();
}

void helpdesk_view_question(ClutterActor *actor)
{
	puts("Viewing Question\n");
 	helpdesk_find_selected_actor(actor);
	helpdesk_show_question_view();
}

void helpdesk_show_helpdesk_view(void)
{
	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");

	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);

	ClutterActor* help_view = jammo_get_actor_by_id("helpdesk-view");

	//buildMessageContainer();	

	if(help_view)
	{
		clutter_actor_show(CLUTTER_ACTOR(help_view));

		if(numberOfLoops > 5)
			questionlist = CLUTTER_CONTAINER(jammo_get_actor_by_id("helpdesk-list-scrollable"));	

		else
			questionlist = CLUTTER_CONTAINER(jammo_get_actor_by_id("helpdesk-list-unscrollable"));	

		clutter_actor_lower(jammo_get_actor_by_id("helpdesk-right-index"),jammo_get_actor_by_id("helpdesk-down-index"));
		clutter_actor_lower(CLUTTER_ACTOR(questionlist),jammo_get_actor_by_id("helpdesk-down-index"));
		clutter_actor_raise_top(jammo_get_actor_by_id("helpdesk-view-button-container"));

		for(int i = 0; i < numberOfLoops; i++)
			helpdesk_add_loop_to_list(NULL, i);	

		ClutterAction *listAction = tangle_actor_get_action_by_type(CLUTTER_ACTOR(questionlist), TANGLE_TYPE_SCROLL_ACTION);
	
		g_signal_connect_swapped(listAction, "clamp-offset-y", G_CALLBACK(helpdesk_autoscroll_to_correct_pos), questionlist);
	}

	else 	puts("can't find 'help-view' ");
}

void helpdesk_show_question_view(void)
{
	puts("Starting Question View\n");

	clear_container(questionlist);

	clutter_actor_hide(jammo_get_actor_by_id("helpdesk-view"));
	clutter_actor_hide(jammo_get_actor_by_id("helpdesk-comment-view"));

	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");

	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* question_view = jammo_get_actor_by_id("helpdesk-question-view");	

	if(question_view)
	{
		char buf[300];
		clutter_actor_show(CLUTTER_ACTOR(question_view));

		sprintf(buf, "Sender: %s", questions[selectedQuestion].sender);
		clutter_text_set_text((ClutterText*)jammo_get_actor_by_id("helpdesk-questionview-textfield-sender"), buf);

		sprintf(buf, "Title: %s", questions[selectedQuestion].title);
		clutter_text_set_text((ClutterText*)jammo_get_actor_by_id("helpdesk-questionview-textfield-topic"), buf);

		sprintf(buf, "Description: %s", questions[selectedQuestion].desc);
		clutter_text_set_text((ClutterText*)jammo_get_actor_by_id("helpdesk-questionview-textfield-desc"), buf);
	}

	else 	puts("can't find 'helpdesk-question-view' ");
}

void helpdesk_show_comment_view(void)
{
	puts("Starting Comment View\n");

	clear_container(questionlist);

	clutter_actor_hide(jammo_get_actor_by_id("helpdesk-view"));
	clutter_actor_hide(jammo_get_actor_by_id("helpdesk-question-view"));

	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");

	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* comment_view = jammo_get_actor_by_id("helpdesk-comment-view");	

	if(comment_view) 
	{
		char buf[300];

		clutter_actor_show(CLUTTER_ACTOR(comment_view));
		clutter_actor_lower(jammo_get_actor_by_id("helpdesk-comment_right-index"),jammo_get_actor_by_id("helpdesk-comment_down-index"));

		sprintf(buf, "You are commenting on question: '%s' which was sent by user: '%s'", 
			questions[selectedQuestion].title, questions[selectedQuestion].sender);
		clutter_text_set_text((ClutterText*)jammo_get_actor_by_id("helpdesk-comment-topic-textfield"), buf);

		sprintf(buf, "Description: %s", questions[selectedQuestion].desc);
		clutter_text_set_text((ClutterText*)jammo_get_actor_by_id("helpdesk-comment-desc-textfield"), buf);
	}

	else 	puts("can't find 'helpdesk-comment-view' ");
}

void helpdesk_add_question(void)
{
	puts("Asking Question\n");
}

void helpdesk_get_questions(void)
{
	//TODO: Create code for fetching helpdesk questions from remote server
	puts("Fetching Questions From Community Server\n");
}

void helpdesk_autoscroll_to_correct_pos(ClutterActor *listToScroll)
{
	gint slot;
	gfloat not_used, offset;

	ClutterAction *action = tangle_actor_get_action_by_type(listToScroll, TANGLE_TYPE_SCROLL_ACTION);
	
	tangle_scroll_action_get_offsets(TANGLE_SCROLL_ACTION(action), &not_used, &offset);

	slot = (gint)offset % (gint)listItemHeight < listItemHeight / 2 ? (gint)(offset) / listItemHeight  
							  		: (gint)(offset) / listItemHeight + 1;

	tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_OUT_QUAD, 300, "offset-y", (gfloat)(slot*listItemHeight), NULL);
}

gboolean helpdesk_add_loop_to_list(char* loopName, int index)
{
	sprintf(questions[index].sender,"Sender here");
	sprintf(questions[index].title,"Title here");
	sprintf(questions[index].desc,"Question number %d", index);

	ClutterActor *avatarImage = clutter_texture_new_from_file("/opt/jammo/communitymenu/community_avatarbackground_small.png", NULL);
	ClutterActor *colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar13.png",NULL);
	
	ClutterText *text = clutter_text_new_with_text("Courier 20", questions[index].desc);	
	ClutterActor *questionButton = tangle_button_new_with_background_actor(text);

	ClutterActor *mentorButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
					"/opt/jammo/communitymenu/community_mentor_icon.png", NULL));
	ClutterActor *commentButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
					"/opt/jammo/communitymenu/community_comment_icon.png", NULL));

	ClutterContainer *listContainer = clutter_group_new();

	if(avatarImage == NULL || colorbar == NULL)
		return FALSE;	

	if(listItemHeight == 0) listItemHeight = clutter_actor_get_height(avatarImage);

	clutter_container_add_actor(listContainer, colorbar);		//Add components inside the container
	clutter_container_add_actor(listContainer, avatarImage);
	
	clutter_actor_set_position(questionButton, 60, 23);			
	clutter_container_add_actor(listContainer, questionButton);
	
	clutter_actor_set_position(commentButton, 690, 15);
	clutter_container_add_actor(listContainer, commentButton);

	g_signal_connect_swapped(CLUTTER_ACTOR(mentorButton), "clicked", G_CALLBACK(helpdesk_view_question), 
						clutter_actor_get_parent(mentorButton));

	g_signal_connect_swapped(CLUTTER_ACTOR(questionButton), "clicked", G_CALLBACK(helpdesk_view_question), 
						clutter_actor_get_parent(questionButton));

	g_signal_connect_swapped(CLUTTER_ACTOR(commentButton), "clicked", G_CALLBACK(helpdesk_view_question), 
						clutter_actor_get_parent(commentButton));

	clutter_container_add_actor(questionlist, CLUTTER_ACTOR(listContainer));

	if(index <= 6)
		clutter_actor_set_height(CLUTTER_ACTOR(questionlist), listItemHeight * index);	

	else
		clutter_actor_set_height(CLUTTER_ACTOR(questionlist), listItemHeight * 6);		

	return TRUE;
}

void helpdesk_submit_button_pressed(void)
{
	printf("Submit button pressed. Adding comment to question %d\n", selectedQuestion);
}
