/*
License: GPLv2, read more from COPYING

This file contains the functionality of discuss menu.
 */
#include <tangle.h>
#include <glib-object.h>
#include <math.h>
#include <string.h>
#include <clutter/clutter.h>
#include "discuss.h"
#include "communitymenu.h"
#include "startmenu.h"

ClutterColor line_color = { 144, 148, 140, 255 };
ClutterColor text_color = { 237, 28, 36, 255 };
ClutterColor text_color2 = { 0, 0, 0, 255 };
ClutterColor text_shadow = { 0, 0, 0, 90 };
ClutterContainer *list = 0;
ClutterContainer *threadslist = 0;
ClutterContainer *downmenu = 0;
static gint item_height = 0;
gchar *entries[] = {"MUSIC MAKING", "HOBBIES", "FRIENDS", "SCHOOL", "OTHER STUFF", "ABOUT JAMMO"}; // Testing
gchar *threads[] = {"I got stuck. HELP ME!", "How do I find my finished songs...", "How to import samples from the web", // Testing
			"How to make pancakes", "How to win in lottery", "How to learn C and clutter"}; 
int entries_size;
int threads_size;


void start_discuss(){
	
	printf("Starting Discuss\n");	
	
	clutter_actor_hide(jammo_get_actor_by_id("communitymenu-view"));

	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");

	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);

	ClutterActor* discuss_view = jammo_get_actor_by_id("discuss-view");

	if(discuss_view){
		clutter_actor_show(CLUTTER_ACTOR(discuss_view));

		getDatabaseElements(); // Testing
		
		if(entries_size > 5){
			list = CLUTTER_CONTAINER(jammo_get_actor_by_id("discuss-view-container"));	
		}else{
			list = CLUTTER_CONTAINER(jammo_get_actor_by_id("discuss-view-container-unscrollable"));
		}

		for(int i = 0; i < (entries_size); i++){ 
			addDiscussion(entries[i], i);	
		}

		clutter_actor_raise( CLUTTER_ACTOR(jammo_get_actor_by_id("bg2")), CLUTTER_ACTOR(list) );
		clutter_actor_raise( CLUTTER_ACTOR(jammo_get_actor_by_id("discussview-gotocommunity")) , CLUTTER_ACTOR(jammo_get_actor_by_id("bg2")) );
		clutter_actor_raise( CLUTTER_ACTOR(jammo_get_actor_by_id("discussview-mentor")) , CLUTTER_ACTOR(jammo_get_actor_by_id("bg2")) );
		clutter_actor_raise( CLUTTER_ACTOR(jammo_get_actor_by_id("discussview-gohome")) , CLUTTER_ACTOR(jammo_get_actor_by_id("bg2")) );

		ClutterAction* action = tangle_actor_get_action_by_type(list, TANGLE_TYPE_SCROLL_ACTION);
		g_signal_connect_swapped(action, "clamp-offset-y", G_CALLBACK(autoscroll_to_correct_pos), list);

	}else{
		puts("can't find 'discuss-view' ");
	}
}


gboolean addDiscussion(char* name, int number){
	
	ClutterActor *line;
	ClutterActor *cont = CLUTTER_ACTOR(clutter_group_new());
	ClutterActor *arrow = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
				"/opt/jammo/communitymenu/community_rightarrow.png", NULL));
	
	line = create_line(73, 800, 2, cont);
	create_title(321, 21, 15, cont, text_shadow, name);
	create_title(320, 20, 15, cont, text_color, name);	


	if(line == NULL || arrow == NULL || name == NULL)
		return 1;

	if(item_height == 0)
		item_height = 75;

        clutter_actor_set_size(arrow, 27, 51);
        clutter_actor_set_position(arrow, 550, 12);
	clutter_container_add_actor(cont, arrow);

	g_signal_connect_swapped(arrow, "clicked", G_CALLBACK(getDiscussion), clutter_actor_get_parent(arrow));

	//ClutterAction* action = tangle_actor_get_action_by_type(jammo_get_actor_by_id("discussion-threads"),TANGLE_TYPE_SCROLL_ACTION);
	//g_signal_connect_swapped(action, "clamp-offset-x", G_CALLBACK(tangle_widget_clamp_child_boundaries), 
	//jammo_get_actor_by_id("discussion-threads"));
	
	clutter_container_add_actor(list, cont);
	
	if(number <= 6){
		clutter_actor_set_height(list, item_height * number);
	}else{
		clutter_actor_set_height(list, item_height * 6);
	}

	return 0;
}


gboolean addThread(char* name, int number){
	
	ClutterActor *line;
	ClutterActor *cont = CLUTTER_ACTOR(clutter_group_new());

	ClutterActor *avatarbg = tangle_button_new_with_background_actor(clutter_texture_new_from_file( // Testing
			"/opt/jammo/communitymenu/community_avatarbackground_small.png", NULL)); 
		
	ClutterActor *comment = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
				"/opt/jammo/communitymenu/community_comment_icon.png", NULL)); 

	line = create_line(74, 640, 1, cont);

	create_title(81, 21, 40, cont, text_shadow, name);
	create_title(80, 20, 40, cont, text_color2, name);	

	if(line == NULL || comment == NULL || avatarbg == NULL|| name == NULL)
		return 1;

	if(item_height == 0)
		item_height = 75;

        clutter_actor_set_position(comment, 690, 15);
	clutter_container_add_actor(cont, comment);
	//clutter_actor_raise(comment, CLUTTER_ACTOR(jammo_get_actor_by_id("threads-view_right-index")));

        clutter_actor_set_position(avatarbg, 10, 1);
	clutter_container_add_actor(cont, avatarbg);

	g_signal_connect_swapped(comment, "clicked", G_CALLBACK(getThread), clutter_actor_get_parent(comment));

	//ClutterAction* action = tangle_actor_get_action_by_type(jammo_get_actor_by_id("discussion-threads"),TANGLE_TYPE_SCROLL_ACTION);
	//g_signal_connect_swapped(action, "clamp-offset-x", G_CALLBACK(tangle_widget_clamp_child_boundaries), 
	//jammo_get_actor_by_id("discussion-threads"));
	
	clutter_container_add_actor(threadslist, cont);
	
	if(number <= 6){
		clutter_actor_set_height(threadslist, item_height * number);
	}else{
		clutter_actor_set_height(threadslist, item_height * 6); 
	}

	return 0;
}


void clear(ClutterActor *param_list){
	
	printf("List cleared\n");

	int i = 0;

	if(param_list != NULL){
	 	
		GList *items;
		items = clutter_container_get_children(param_list);
	
		if(items != NULL){
		
			do{
				if(i > 0)
					items = items->next;
				
				clutter_container_remove_actor(CLUTTER_CONTAINER(param_list), CLUTTER_ACTOR(items->data));
				i++;
	
			}while(items->next != NULL);
		}
	
	g_list_free(items);
	}
	
}


/***************************
Drawing functions// Testing
**************************/

ClutterActor *create_line(int y, int length, int size, ClutterContainer *cont) {

        ClutterActor *line = clutter_rectangle_new_with_color(&line_color);
        clutter_actor_set_size(line, length, size);
        clutter_actor_set_position(line, 0, y);

        clutter_container_add_actor(CLUTTER_CONTAINER(cont), line);
        clutter_actor_show(line);

        return line;
}


ClutterActor *create_title(int x, int y, int max, ClutterContainer *cont, ClutterColor color, const gchar *arg) {

        ClutterActor *title = clutter_text_new_full("Comic Sans MS 16", arg, &color);
        clutter_actor_set_size(title, ((max*10)+100), 51);
        clutter_actor_set_position(title, x, y);
	clutter_text_set_max_length(title, max);

        clutter_container_add_actor(CLUTTER_CONTAINER(cont), title);
        clutter_actor_show(title);

        return title;
}


/***************************
Functions for json
**************************/


void discuss_community_clicked (TangleButton* tanglebutton, gpointer none){

	clear(CLUTTER_ACTOR(list));
	clear(CLUTTER_ACTOR(threadslist));	
	clear(CLUTTER_ACTOR(downmenu));
	printf("\nCleared containers\n\n");

	startmenu_goto_communitymenu(NULL,NULL);
}

void discuss_home_clicked (TangleButton* tanglebutton, gpointer none){
	
	clear(CLUTTER_ACTOR(list));
	clear(CLUTTER_ACTOR(threadslist));
	clear(CLUTTER_ACTOR(downmenu));
	printf("\nCleared containers\n\n");

	startmenu_goto_startmenu(NULL,NULL);
}


gboolean discuss_mentor_clicked (TangleButton *tanglebutton, gpointer data)   {
	printf("mentor clicked\n");

	return TRUE;
}


/***************************
Callback functions
**************************/


static void autoscroll_to_correct_pos(ClutterActor *list_){

	gint slot;
	gfloat not_used, offset;
	
	ClutterAction *action = tangle_actor_get_action_by_type(list_, TANGLE_TYPE_SCROLL_ACTION);
	
	tangle_scroll_action_get_offsets(TANGLE_SCROLL_ACTION(action), &not_used, &offset);
	slot = (gint)offset % (gint)item_height < item_height/2  	? (gint)(offset) / item_height  
							  		: (gint)(offset) / item_height + 1;

	tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_OUT_QUAD, 300, "offset-y", 
				(gfloat)(slot*item_height), NULL);
}


static void getDiscussion(ClutterActor *element){

	GList *children = clutter_container_get_children(list);
	int i = 0;
	int index = 0;
	
	if(children != NULL){
		
		do{
			if(i == 0){
				i++;
			}else{	
				children = children->next;
				index++;
			}
				
			if(element == children->data){
				printf("Clicked element: %s\n", entries[index]);
				discuss_change_to_discussion_threads_view(NULL, NULL); // Testing
				break;
			}
		
		}while(children->next != NULL);
	}

	// TO-DO: erillinen thread-view!!!
	// aloitusfunktio saa parametrinaan klikatun elementin nimen
	


	//current_levelview=levelview;
	//cem_add_to_log("Sequencer GUI starts",J_LOG_INFO);

	//g_signal_connect(current_levelview, "show-completed", G_CALLBACK(levelview_loaded), NULL); //Continue after animated show
	//clutter_actor_show(current_levelview);

		

	//printf("changing view to discuss");
	//ClutterActor* scrolling_view = jammo_get_actor_by_id("discuss-container-for-discussion-threads");

	// ClutterAction* action = tangle_actor_get_action_by_type(scrolling_view,TANGLE_TYPE_SCROLL_ACTION);
	// tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_CIRC, 400, "offset-y", 480.0, NULL);
		

	g_list_free(children);

}


static void getThread(ClutterActor *element){

	GList *children = clutter_container_get_children(threadslist);
	int i = 0;
	int index = 0;
	
	if(children != NULL){
		
		do{
			if(i == 0){
				i++;
			}else{	
				children = children->next;
				index++;
			}
				
			if(element == children->data){
				printf("Clicked element: %s\n", threads[index]);
				// What to do?
				break;
			}
		
		}while(children->next != NULL);
	}
	g_list_free(children);

}


gboolean discuss_change_to_discussion_threads_view(TangleActor *actor, gpointer data) {

	printf("changing view to discussion threads\n");

	clear(list);
	start_discussionthreads(); // TESTING


	//clutter_actor_hide(jammo_get_actor_by_id("discuss-view"));

	/*ClutterActor* discussion_threads_view = jammo_get_actor_by_id("discuss-container-for-discussion-threads");

	if (discussion_threads_view == NULL){
		printf("no actor 'discussion_threads_view'");
		return TRUE;
	}

	ClutterAction* action = tangle_actor_get_action_by_type(discussion_threads_view, TANGLE_TYPE_SCROLL_ACTION);
	tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_CIRC, 400, "offset-x", 800.0, NULL);*/

	//clutter_actor_hide(jammo_get_actor_by_id("discuss-view"));

	return TRUE;
}


gboolean discuss_change_to_discussion_view(TangleActor *actor, gpointer data) {

	printf("changing view to discussion view\n");

	clear(threadslist);
	clear(downmenu);
	start_discuss(); // TESTING

	/*ClutterActor* discussion_view = jammo_get_actor_by_id("discuss-view-container");

	if (discussion_view == NULL){
		printf("no actor 'discussion_view'");
		return TRUE;
	}*/

	//ClutterAction* action = tangle_actor_get_action_by_type(discussion_view, TANGLE_TYPE_SCROLL_ACTION);
	//tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_CIRC, 0, "offset-y", 0.0, NULL);

	

	return TRUE;
}


/***************************
TESTING
**************************/


void start_discussionthreads(){

	// JUST FOR TESTING!

	int numberOfThreads = 6;

	clutter_actor_hide(jammo_get_actor_by_id("discuss-view"));

	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");

	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);

	ClutterActor* discussion_threads_view = jammo_get_actor_by_id("threads-view");

	if(discussion_threads_view)
	{
		clutter_actor_show(CLUTTER_ACTOR(discussion_threads_view));

		if(numberOfThreads > 5)
			threadslist = CLUTTER_CONTAINER(jammo_get_actor_by_id("threads-view-list-scrollable"));	
		else
			threadslist = CLUTTER_CONTAINER(jammo_get_actor_by_id("threads-view-list-unscrollable"));

		//downmenu = CLUTTER_CONTAINER(jammo_get_actor_by_id("downmenu"));

		//clutter_actor_raise(CLUTTER_ACTOR(jammo_get_actor_by_id("threads-view_right-index")),threadslist);

  		//clutter_actor_lower(CLUTTER_ACTOR(jammo_get_actor_by_id("bg")), threadslist);

		clutter_actor_raise( CLUTTER_ACTOR(jammo_get_actor_by_id("threads_view_gotocommunity")) , CLUTTER_ACTOR(jammo_get_actor_by_id(
													"threads-view_down-index")) );
		clutter_actor_raise( CLUTTER_ACTOR(jammo_get_actor_by_id("threads_view-mentor")) , CLUTTER_ACTOR(jammo_get_actor_by_id(
													"threads-view_down-index")) );
		clutter_actor_raise( CLUTTER_ACTOR(jammo_get_actor_by_id("threads_view_gohome")) , CLUTTER_ACTOR(jammo_get_actor_by_id(
													"threads-view_down-index")) );

		clutter_actor_lower(jammo_get_actor_by_id("threads-view_right-index"),jammo_get_actor_by_id("threads-view_down-index"));
		clutter_actor_lower(CLUTTER_ACTOR(threadslist),jammo_get_actor_by_id("threads-view_down-index"));


	       /* ClutterActor *backtotopics_img;
		backtotopics_img = clutter_texture_new_from_file("/opt/jammo/communitymenu/community_discussion_threads_backtotopics.png", NULL);

		ClutterActor *backtotopics = tangle_button_new_with_background_actor(backtotopics_img);

       		clutter_actor_set_size(backtotopics, 102, 55);
        	clutter_actor_set_position(backtotopics, 25, 60);

        	clutter_container_add_actor(CLUTTER_CONTAINER(downmenu), backtotopics);
        	clutter_actor_show(backtotopics);*/

		clutter_actor_raise(CLUTTER_ACTOR(jammo_get_actor_by_id("backtotopics")), CLUTTER_ACTOR(jammo_get_actor_by_id(
												"threads-view_down-index")) );

		//clutter_actor_raise(CLUTTER_ACTOR(jammo_get_actor_by_id("downmenu")),CLUTTER_ACTOR(jammo_get_actor_by_id("threads-view_down-index")));

		//g_signal_connect_swapped(backtotopics,"clicked",G_CALLBACK(discuss_change_to_discussion_view),clutter_actor_get_parent(backtotopics));

		for(int i = 0; i < (threads_size); i++){ 
			addThread(threads[i], i);	
		}

		ClutterAction* action = tangle_actor_get_action_by_type(threadslist, TANGLE_TYPE_SCROLL_ACTION);
		g_signal_connect_swapped(action, "clamp-offset-y", G_CALLBACK(autoscroll_to_correct_pos), threadslist);


	}else{
		puts("can't find 'discuss-container-for-discussion-threads' ");
	}

}


/***************************
Database functions
**************************/

void getDatabaseElements(){
	
	//tähän elementtien hakemiseen liittyvät funktiot 

	//haettavien elementtien määrä?

	//taulukon dynaaminen allokointi...

	//tietojen tallentaminen taulukkoon

	//taulukon palautus?

	//Testing
	entries_size = 6; // Poista tämä myöhemmin
	threads_size = 6; // Poista tämä myöhemmin

	/*
	for(int i=0; i < num; i++){
		//laita tietoja taulukkoon
	}*/

	//Testing
	//entries[1] = "MUSIC MAKING";
	//entries[2] = "HOBBIES";
	//entries[3] = "FRIENDS";
	//entries[4] = "SCHOOL";
	//entries[5] = "OTHER STUFF";
	//entries[5] = "ABOUT JAMMO";
	
}
