/*
 * gems_security.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu, Lappeenranta University of Technology
 *
 * Authors: Jussi Laakkonen <jussi.laakkonen@lut.fi>
 */

#include <openssl/sha.h>
#include <arpa/inet.h>
#include <string.h>
#include "gems_security.h"

gems_message* gems_security_create_envelope(gint16 type,gems_connection* element, gems_message* original)
{
	gems_message* envelope = (gems_message*)g_malloc(sizeof(gems_message));
	guint position = 0;
	
	envelope->length = sizeof(gint16) + sizeof(gint32) + JAMMO_MESSAGE_DIGEST_SIZE + 1 + original->length;
	
	envelope->message = (gchar*)g_malloc(sizeof(gchar*) * envelope->length);
	
	memset(envelope->message,'\0', envelope->length);
	
	// Packet type 16 bits
	*(gint16*)&envelope->message[position] = htons(type);
	position = position + sizeof(gint16);
	
	// Length 32 bits
	*(gint32*)&envelope->message[position] = htonl(envelope->length);
	position = position + sizeof(gint32);
	
	// Hash /*Casting by Aapo, because of compile time warnings!*/
	unsigned char* hash = SHA1((const unsigned char*)(original->message),(guint32)(original->length),NULL);
	g_strlcat(&envelope->message[position],(char*)hash,envelope->length);
	position = position + JAMMO_MESSAGE_DIGEST_SIZE + 1;
	
	// Copy original message
	memcpy(&envelope->message[position],original->message,original->length);
	
	return envelope;
}

gint gems_security_extract_envelope(gems_connection* element)
{
	// [id:2|lenght:4|hash|srvid:2|length:4|cmd:2|...]
	gint32 length = ntohl(gems_connection_get_32(element,sizeof(gint16)));
	
	//gchar* hash =
	gems_connection_get_data(element,sizeof(gint16)+sizeof(gint32),JAMMO_MESSAGE_DIGEST_SIZE);
	
	memmove(&element->nwbuffer[0],
		&element->nwbuffer[sizeof(gint16) + sizeof(gint32) + JAMMO_MESSAGE_DIGEST_SIZE + 1],
		(length - sizeof(gint16) - sizeof(gint32) - JAMMO_MESSAGE_DIGEST_SIZE - 1));
		
	// TODO compare hashes
	
	return SECURITY_OK;
}
