/*
License: GPLv2, read more from COPYING

This file contains the functionality of JamMo Sounds menu.
 */
#include <tangle.h>
#include <glib-object.h>
#include "jammosounds.h"
#include "../jammo.h"
#include "../../meam/jammo-sample.h"
#include "startmenu.h"
#include <string.h>

static ClutterContainer *list = 0;
static gint listItemHeight = 0;


void start_jammosounds(){

	int numberOfLoops = 6; //this should contain the number of loops in the list

	printf("Starting JamMoSounds\n");
	
	clutter_actor_hide(CLUTTER_ACTOR(jammo_get_actor_by_id("communitymenu-view")));
	ClutterActor* mainview;
	
	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* jammosounds_view = jammo_get_actor_by_id("jammosounds-view");
	if(jammosounds_view){

		clutter_actor_show(CLUTTER_ACTOR(jammosounds_view));

		
		if(numberOfLoops > 5)
			list = CLUTTER_CONTAINER(jammo_get_actor_by_id("jammosounds-songs-list-scrollable"));	

		else
			list = CLUTTER_CONTAINER(jammo_get_actor_by_id("jammosounds-songs-list-unscrollable"));	

		clutter_actor_lower(jammo_get_actor_by_id("jammosounds-right-index"), jammo_get_actor_by_id("jammosounds-down-index"));
;
		clutter_actor_lower(CLUTTER_ACTOR(list), jammo_get_actor_by_id("jammosounds-down-index"));


		for(int i = 0; i < numberOfLoops; i++){
			add_loop_to_list(NULL, i);	
		}
			

	ClutterAction *listAction = tangle_actor_get_action_by_type(CLUTTER_ACTOR(list), TANGLE_TYPE_SCROLL_ACTION);

	
	g_signal_connect_swapped(listAction, "clamp-offset-y", G_CALLBACK(autoscroll_to_correct_pos), list);

	
	}
	else
		puts("can't find 'jammosounds-view' ");
}




static void autoscroll_to_correct_pos(ClutterActor *listToScroll){


	gint slot;
	gfloat not_used, offset;
	ClutterAction *action = tangle_actor_get_action_by_type(listToScroll, TANGLE_TYPE_SCROLL_ACTION);
	

	
	tangle_scroll_action_get_offsets(TANGLE_SCROLL_ACTION(action), &not_used, &offset);
	slot = (gint)offset % (gint)listItemHeight < listItemHeight/2  	? (gint)(offset) / listItemHeight  
							  		: (gint)(offset) / listItemHeight + 1;

	tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_OUT_QUAD, 300, "offset-y", 
				(gfloat)(slot*listItemHeight), NULL);


}




gboolean add_loop_to_list(char* name, int numberOfLoops){

	ClutterActor* listImage = clutter_texture_new_from_file("/opt/jammo/communitymenu/community_jammosounds_bar.png", NULL);


	ClutterContainer *listContainer = CLUTTER_CONTAINER(clutter_group_new());

	ClutterActor *importButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
			"/opt/jammo/communitymenu/community_icon_toloopgame.png", NULL));
			
	ClutterActor *arrowImage = clutter_texture_new_from_file("/opt/jammo/communitymenu/community_rightarrow.png", NULL);

	if(listImage == NULL || arrowImage == NULL)
		return FALSE;	

	if(listItemHeight == 0)
		listItemHeight = clutter_actor_get_height(listImage);


	clutter_container_add_actor(listContainer, listImage);
	//clutter_container_add_actor(listContainer, listImage);
	
	//TODO: add instrument icon depending on the instrument

	ClutterActor *instrument = clutter_texture_new_from_file("/opt/jammo/wheel_game/piano.png", NULL);  
	clutter_actor_set_position(instrument, 130, 0);
	clutter_actor_set_height(instrument, listItemHeight);
	clutter_container_add_actor(listContainer, instrument);
	
	
	//TODO: add correct font
	
	ClutterActor *loopName = tangle_button_new_with_background_actor(clutter_text_new_with_text("Times", "Loop name here"));	
	clutter_actor_set_position(loopName, 230, listItemHeight/5*2);
	clutter_container_add_actor(listContainer, loopName);	
	
		
	clutter_actor_set_position(arrowImage, 655, 15);
	
	clutter_container_add_actor(listContainer, arrowImage);

	clutter_actor_set_position(CLUTTER_ACTOR(importButton), 690, 15);

	clutter_container_add_actor(listContainer, CLUTTER_ACTOR(importButton));
	
	g_signal_connect_swapped(importButton, "clicked", G_CALLBACK(import_selected_loop), 
				clutter_actor_get_parent(importButton));
	
	g_signal_connect_swapped(loopName, "button-release-event", G_CALLBACK(play_selected_loop), loopName);
	
	clutter_container_add_actor(list, CLUTTER_ACTOR(listContainer));
	
	
	if(numberOfLoops <= 6)
		clutter_actor_set_height(CLUTTER_ACTOR(list), listItemHeight * numberOfLoops);	

	else
		clutter_actor_set_height(CLUTTER_ACTOR(list), listItemHeight * 6);		

	return TRUE;

}


static void import_selected_loop(ClutterActor *loop){

	GList *children = clutter_container_get_children(list);
	int first = 0;
	
	if(children != NULL){
		
		do{
			if(first == 0)
				first++;
			else	
				children = children->next;
				
		
			if(loop == children->data){
				puts("found it");
				break;
				}
		
		}while(children->next != NULL);
	
	}
	
	ClutterActor *text = clutter_text_new_with_text("Times", "TEST");
	
	clutter_container_add_actor(children->data, text);
	
	//clutter_container_remove_actor(list, children->data); // JUST TESTING

	puts("importing..");

	g_list_free(children);

}


void play_selected_loop(ClutterActor *loopName){
	
	//TODO: add correct loop, this one is just to test the button
	static JammoSample *sample = NULL;
	
	if(sample == NULL){
		//songName = "/home/teppo/jammo10-jammo-data/data/jammo7-12_all/backingtracks/Sa_LaBamba_110_A.ogg";
		puts("Starting loop");
		sample = jammo_sample_new_from_file("/home/teppo/jammo10-jammo-data/data/jammo7-12_all/backingtracks/Sa_LaBamba_110_A.ogg");
	
		jammo_sample_play(sample);

	}
	
	else{
		puts("loop stop");
		jammo_sample_stop(sample);
		sample = NULL;

	
	}
	

}



void end_jammosounds(TangleButton *tanglebutton, gpointer none){

	clear_container(list);
   
	if(strcmp(clutter_actor_get_name(CLUTTER_ACTOR(tanglebutton)), "gotocommunity") == 0)
		startmenu_goto_communitymenu(tanglebutton, none);
		
	else
	   startmenu_goto_startmenu(tanglebutton, none);

}


void clear_container(ClutterContainer *listToClear){
	

	int i = 0;
	GList *listItems;
	
	if(listToClear != NULL){
	 	
		listItems = clutter_container_get_children(listToClear);
		
		if(listItems != NULL){

		
			do{
			
				if(i > 0)
					listItems = listItems->next;
				
				
				clutter_container_remove_actor(CLUTTER_CONTAINER(listToClear), CLUTTER_ACTOR(listItems->data));
				i++;
	
			}while(listItems->next != NULL);
	
	
		g_list_free(listItems);

		}


	}

}


