/*
License: GPLv2, read more from COPYING

This file contains the functionality of JamMo Songs menu.
 */
#include <tangle.h>
#include <glib-object.h>
#include "jammosongs.h"
#include "../../meam/jammo-sample.h"
#include "jammosounds.h" //to get clear_container

static ClutterContainer *list = 0;
static gint listItemHeight = 0;

void start_jammosongs(){

	int numberOfSongs = 6;  //this should contain the number of songs in the list

	printf("Starting JamMoSongs\n");
	
	clutter_actor_hide(jammo_get_actor_by_id("communitymenu-view"));
	ClutterActor* mainview;
	
	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* jammosongs_view = jammo_get_actor_by_id("jammosongs-view");
				

	if(jammosongs_view){

		clutter_actor_show(CLUTTER_ACTOR(jammosongs_view));

		
		if(numberOfSongs > 5)
			list = CLUTTER_CONTAINER(jammo_get_actor_by_id("jammosongs-songs-list-scrollable"));	

		else
			list = CLUTTER_CONTAINER(jammo_get_actor_by_id("jammosongs-songs-list-unscrollable"));	

		clutter_actor_lower(jammo_get_actor_by_id("jammosongs-right-index"), jammo_get_actor_by_id("jammosongs-down-index"));
				
		clutter_actor_raise(jammo_get_actor_by_id("jammosongs-mentor"), jammo_get_actor_by_id("jammosongs-down-index"));
		
		clutter_actor_raise(jammo_get_actor_by_id("jammosongsview-gotocommunity"), jammo_get_actor_by_id("jammosongs-down-index"));
		
		clutter_actor_lower(CLUTTER_ACTOR(list), jammo_get_actor_by_id("jammosongs-down-index"));


		for(int i = 0; i < numberOfSongs; i++){
			add_song_to_list(NULL, i);	
		}

	ClutterAction *listAction = tangle_actor_get_action_by_type(list, TANGLE_TYPE_SCROLL_ACTION);

	
	g_signal_connect_swapped(listAction, "clamp-offset-y", G_CALLBACK(autoscroll_to_correct_pos), list);

	
	}
	else
		puts("can't find 'jammosongs-view' ");
}


static void autoscroll_to_correct_pos(ClutterActor *listToScroll){

	

	gint slot;
	gfloat not_used, offset;
	ClutterAction *action = tangle_actor_get_action_by_type(listToScroll, TANGLE_TYPE_SCROLL_ACTION);
	

	
	tangle_scroll_action_get_offsets(TANGLE_SCROLL_ACTION(action), &not_used, &offset);
	slot = (gint)offset % (gint)listItemHeight < listItemHeight/2  	? (gint)(offset) / listItemHeight  
							  		: (gint)(offset) / listItemHeight + 1;

	tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_OUT_QUAD, 300, "offset-y", 
				(gfloat)(slot*listItemHeight), NULL);
}


gboolean add_song_to_list(char* loopName, int numberOfSongs){

	ClutterActor *listImage = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar4.png", NULL); //TODO: image color depends on the song

	ClutterContainer *listContainer = clutter_group_new();

	TangleButton *reviewButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
			"/opt/jammo/communitymenu/community_comment_icon.png", NULL));
			
			
	//TODO: add correct font for the text		

	ClutterActor *songName = clutter_text_new_with_text("Times", "Name of the song");

	if(listImage == NULL)
		return FALSE;	

	if(listItemHeight == 0)
		listItemHeight = clutter_actor_get_height(listImage);

	clutter_container_add_actor(listContainer, listImage);
	
	clutter_actor_set_position(songName, 200, listItemHeight/5*2);
	
	clutter_container_add_actor(listContainer, songName);
	
	//TODO: add following images only if there is a music video or label for the song
	
	ClutterActor *video = clutter_texture_new_from_file("/opt/jammo/communitymenu/community_videocamera_icon_small.png", NULL);
	clutter_actor_set_position(video, 580, listItemHeight/3);
	clutter_container_add_actor(listContainer, video);
	
	
	ClutterActor *label = clutter_texture_new_from_file("/opt/jammo/communitymenu/community_cdlabel_small.png", NULL);
	clutter_actor_set_position(label, 500, listItemHeight/3);
	clutter_container_add_actor(listContainer, label);


	clutter_actor_set_position(CLUTTER_ACTOR(reviewButton), 690, 15);

	clutter_container_add_actor(listContainer, CLUTTER_ACTOR(reviewButton));
	
	g_signal_connect_swapped(reviewButton, "clicked", G_CALLBACK(import_selected_song), 
				clutter_actor_get_parent(reviewButton));
	
	clutter_container_add_actor(list, listContainer);
	
	
	if(numberOfSongs <= 6)
		clutter_actor_set_height(list, listItemHeight * numberOfSongs);	

	else
		clutter_actor_set_height(list, listItemHeight * 6);		

	return TRUE;

}


static void import_selected_song(ClutterActor *song){

	GList *children = clutter_container_get_children(list);
	int first = 0;
	
	if(children != NULL){
		
		do{
			if(first == 0)
				first++;
			else	
				children = children->next;
				
		
			if(song == children->data){
				puts("found it");
				break;
				}
		
		}while(children->next != NULL);
	
	}
	
	
	
	JammoSample *sample = jammo_sample_new_from_file("/home/teppo/jammo10-jammo-data/data/jammo7-12_all/backingtracks/Sa_LaBamba_110_A.ogg");
	
	jammo_sample_play(sample);

	
	
	//following lines are just for test
	
	ClutterActor *text = clutter_text_new_with_text("Times", "TEST");
	
	clutter_container_add_actor(children->data, text);
	
	//clutter_container_remove_actor(list, children->data); // JUST TESTING

	puts("importing..");

	g_list_free(children);

}


void end_jammosongs(TangleButton *tanglebutton, gpointer none){

	clear_container(list);
   
	if(strcmp(clutter_actor_get_name(CLUTTER_ACTOR(tanglebutton)), "gotocommunity") == 0)
		startmenu_goto_communitymenu(tanglebutton, none);
		
	else
	   startmenu_goto_startmenu(tanglebutton, none);

}



