#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include <glib/gprintf.h>
#include <clutter/clutter.h>
#include <string.h>
#include "../../gems/gems_profile_manager.h"
#include "config.h"
#include "screens.h"
#include "../jammo.h"

gint countChar(gchar *string, gchar c, int length)
{
	int retval = 0;
	for (int i = 0; i < length; i ++)
	{
		if (c == string [i])
			retval ++;
	}
	if (retval>1)	
		return 0;
	else
		return 1;
}

gchar convert_to_char(int i)
{
	switch(i)
	{
		case 1:
			return '1';
		case 2:
			return '2';
		case 3:
			return '3';
		case 4:
			return '4';
		case 5:
			return '5';
		case 6:
			return '6';
		case 7:
			return '7';
		case 8:
			return '8';
		case 9:
			return '9';
		default:
			return '0';		
	}
}

gchar *pg_convert_points_to_string(int *array, int array_len)
{	
		
	int i;
	int j;	
	int k=0;
	
	gchar *password=g_malloc((array_len+1) * sizeof(gchar));
	//buff_char =pg_itoa(array[1],buff_char,10);

	for (i=0; i<array_len; i++)
	{
		j=array[i];			
		password[i]=convert_to_char(j);		
		k++;			
	}		
	password[k]='\0';	
	return password;
}


gboolean pg_save_passwd (gchar *passwd)
{
	FILE *passwd_F;
	gchar *filepath = g_build_filename(configure_get_jammo_directory(), "/pg-passwords", NULL);
	passwd_F = fopen(filepath, "w");
  	if(passwd_F ==NULL) {
    		g_print("Cannot open passwords file..\n");
    		exit(EXIT_FAILURE);
	}	
	g_fprintf(passwd_F, "%s",passwd);
	fclose(passwd_F);
	return TRUE;
}

gchar *pg_read_passwd_from_file()
{
	FILE *passwd_F;
	gchar *filepath = g_build_filename(configure_get_jammo_directory(), "/pg-passwords", NULL);
	passwd_F=fopen(filepath,"rt");
	if ( passwd_F != NULL ) 
	{
		gchar string[100];
		gchar *buffer = g_malloc(40*sizeof(gchar));
		gchar* result = fgets(string, 20, passwd_F);  //fgets declared with attribute warn_unused_result
		result=result; //because of 'warning: unused variable'
		//printf("Fgets returns: '%s' \n",result);

		fclose(passwd_F);		
		buffer=string;		
		return buffer;		
	} else {
		 perror (filepath);
		return "error cannot read file";
	}
}

gboolean pg_validate_gesture(gchar *password)
{
	gint i=0;
	gint j=0;		 
	i=strlen(password);
	//i=i-1;// REMOVE THE NULL AT THE END OF THE STRING
	gchar *c_array= g_malloc(i*sizeof(gchar));
	g_print("password length: %d\n",i);
	if ((i<4) || (i>8))
	{
		g_print("password wrong size\n");
		return FALSE;
	}
	else 
	{	
		gint k;		
		for (j=0; j<i; j++)
		{
			c_array[j]=password[j];
			//g_print("ARRAY: %c --\n",c_array[j]);	
			k=countChar(password, c_array[j], i);
			if(k==0)
			{
				g_print("double char");				
				return FALSE;
			}
		}
	}
	g_print("valid gesture\n");
	return TRUE;	
}

gboolean pg_validate_passwd (ClutterActor *stage, gchar *password, int is_new)
{
	//is_new 0 for reset password, 1 for existing password
	if (is_new==1) {
		//VALIDATE PASSWORD MISSING 
		if(pg_validate_gesture(password))
		{
			pg_save_passwd (password);		
			pg_set_reset_success_screen(stage, PG_RESET_PASSWORD_SUCCESS);
			return TRUE;
		}
		else
		{		
			pg_set_error_screen(stage, PG_RESET_PASSWORD_ERROR);
			return TRUE;
		}
		
	}else //if(is_new==1)
	{
		gchar *user_passwd;//=g_malloc(40*sizeof(gchar));				
		user_passwd=pg_read_passwd_from_file();		
		if (strcmp(password,user_passwd)==0) {
			 clutter_actor_show(jammo_get_actor_by_id("main-menu-view"));
 			clutter_actor_hide(jammo_get_actor_by_id("pen-gesture-view"));				
		}
		else
		{
			pg_set_error_screen(stage, PG_PASSWORD_ERROR);
		}
		return TRUE;	
	}
	
}


int *get_user_passwd()
{
	//Should read passwords as strings from profiler


	int user_id;
	gchar *username="Guest";
	gchar *passworddata="password";
	gint dummy_login;
	user_id = gems_profile_manager_get_userid(NULL);
	dummy_login=gems_profile_manager_login(user_id, username,passworddata);
	if(dummy_login)
	{
		//g_print("DUMMY LOGIN BAD\n");
	} else {
		//g_print("DUMMY LOGIN GOOD\n");
	}
	int *pass_arr;
	pass_arr=malloc(4*sizeof*pass_arr);
	pass_arr[0]=1;
	pass_arr[1]=2;
	pass_arr[2]=3;
	pass_arr[3]=6;
	return pass_arr;
}

