#include "profile_viewer.h"
#include "community_utilities.h"
#include "jammosongs.h"
#include <string.h>
#include "avatar_editor.h"
#include "../../cem/cem.h"
#include "avatar.h"

profile_view_params *params;
static Avatar avatar = {0,0,0,0};
static ClutterContainer* avatarBackground = 0;
static ClutterActor* instrumentBackground = 0;
user_type * usr = 0;

/**
 * Builds profile viewer
**/
void start_profile_view(profile_view_params *pvp){

	params = pvp;
	guint32 avatar_id = 0;	
	//gems_peer_profile *profile = gems_profile_manager_get_profile_of_user(params->user_id);

	cem_add_to_log("Starting profileviewer", J_LOG_DEBUG);
	
	if(strcmp(params->parent_view, "jammosongs") == 0)
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("jammosongs-view")));
		
	if(strcmp(params->parent_view, "single-thread") == 0)
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("single-thread-view")));

	if(strcmp(params->parent_view, "helpdesk") == 0)
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("helpdesk-view")));			
	
	if(strcmp(params->parent_view, "discuss") == 0)
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("threads-view")));		
	
	ClutterActor* profile_view = jammo_get_actor_by_id("profile-view");
				

	if(!profile_view){
		cem_add_to_log("can't find 'profile-view' ", J_LOG_FATAL);
	}

		clutter_actor_show(CLUTTER_ACTOR(profile_view));
		
		//avatar_id = gems_profile_manager_get_avatar_id(profile);
		avatar_id = pvp->user_id;		


		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_name_text")), _("NAME: "));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_gender_text")), _("GENDER: "));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_age_text")), _("AGE: "));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_hobbies_text")), _("HOBBIES: "));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_instrument_text")), _("FAVOURITE INSTRUMENT: "));
		
		//age = g_strdup_printf("%d", gems_profile_manager_get_age(profile)); //?? //age is now guint

		char * user_json_file = g_strdup_printf("%s/user_%d.json",configure_get_temp_directory(), pvp->user_id);

		//Default values:
		gchar* username =g_strdup_printf("<<YOUR NAME HERE>>");
		gchar* hobbies = g_strdup_printf("<<YOUR HOBBIES HERE>>");
		gchar* gender = g_strdup_printf("<<YOUR GENDER HERE>>");
		guint32 serialized_image=260;
		guint32 age=0;

		avatar_parse_json(user_json_file,&username,&hobbies,&gender,&serialized_image,&age);

		//printf("username '%s', hobbies '%s', gender '%s', serialized_image '%d', age '%d'\n",username, hobbies, gender,  serialized_image, age);

		avatar_unserialize_image(&avatar, serialized_image);
		set_avatar(&avatar, CLUTTER_ACTOR(avatarBackground), instrumentBackground, "user-profile-widgets");

		gchar* age_string = g_strdup_printf("%d",age);

		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_name_textfield")), username);
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_gender_textfield")), gender);
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_hobbies_textfield")), hobbies);
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_age_textfield")), age_string);
		
		g_free(username);
		g_free(hobbies);
		g_free(gender);
		g_free(age_string);

		g_free(user_json_file);
}

/**
 * Ends profile viewer and frees all allocated memory
**/
gboolean end_profile_view(TangleActor* actor, gpointer data){

	DESTROY_ACTOR(avatar.body);
	DESTROY_ACTOR(avatar.hair);
	DESTROY_ACTOR(avatar.head);
	DESTROY_ACTOR(avatar.instrument);
	community_utilities_clear_container_recursively(avatarBackground);
	DESTROY_ACTOR(instrumentBackground);

	if (usr) {
	if(usr->username != NULL)
		free(usr->username);
			
	if(usr->gender != NULL)
		free(usr->gender);

	if(usr->hobbies != NULL)
		free(usr->hobbies);
	
	if(usr != NULL)
		free(usr); 
	}

	if(strcmp(params->parent_view, "single-thread") == 0){
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("profile-view")));
		clutter_actor_show(jammo_get_actor_by_id("single-thread-view"));
	}
	if(strcmp(params->parent_view, "jammosongs") == 0){
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("profile-view")));
		clutter_actor_show(jammo_get_actor_by_id("jammosongs-view"));
	}	
	if(strcmp(params->parent_view, "helpdesk") == 0){
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("profile-view")));
		clutter_actor_show(jammo_get_actor_by_id("helpdesk-view"));
	}
	if(strcmp(params->parent_view, "discuss") == 0){
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("profile-view")));
		clutter_actor_show(jammo_get_actor_by_id("threads-view"));
	}		

	return TRUE;
}

