#include "profile_viewer.h"
#include "community_utilities.h"
#include "jammosongs.h"
#include <string.h>
#include "avatar_editor.h"
#include "../../cem/cem.h"

profile_view_params *params;
static Avatar avatar = {0,0,0,0};
static ClutterContainer* avatarBackground = 0;
static ClutterActor* instrumentBackground = 0;
user_type * usr = 0;

/**
 * Builds profile viewer
**/
void start_profile_view(profile_view_params *pvp){

	params = pvp;
	gchar *age;
	guint32 avatar_id = 0;	
	gems_peer_profile *profile = gems_profile_manager_get_profile_of_user(params->user_id);

	cem_add_to_log("Starting profileviewer", J_LOG_DEBUG);
	
	if(strcmp(params->parent_view, "jammosongs") == 0)
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("jammosongs-view")));
		
	if(strcmp(params->parent_view, "single-thread") == 0)
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("single-thread-view")));

	if(strcmp(params->parent_view, "helpdesk") == 0)
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("helpdesk-view")));			
	
	if(strcmp(params->parent_view, "discuss") == 0)
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("threads-view")));		
	
	ClutterActor* profile_view = jammo_get_actor_by_id("profile-view");
				

	if(profile_view){
		clutter_actor_show(CLUTTER_ACTOR(profile_view));
		
		//avatar_id = gems_profile_manager_get_avatar_id(profile);
		avatar_id = pvp->user_id;		

			if (avatar_id == 0)
				avatar_id = 260; //default avatar	
			
		community_get_avatar(&avatar, avatar_id);				
		set_avatar(&avatar, CLUTTER_ACTOR(avatarBackground), instrumentBackground, "user-profile-widgets");
		
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_name_text")), _("NAME: "));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_gender_text")), _("GENDER: "));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_age_text")), _("AGE: "));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_hobbies_text")), _("HOBBIES: "));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_instrument_text")), _("FAVOURITE INSTRUMENT: "));
		
		age = g_strdup_printf("%d", gems_profile_manager_get_age(profile)); //??

		char * user_json_file = g_strdup_printf("%s/user_%d.json",configure_get_temp_directory(), pvp->user_id);

		if(!parse_user_profile_from_file(user_json_file))
			return;
		
		//clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_name_textfield")), gems_profile_manager_get_username(profile));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_name_textfield")), usr->username);
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_gender_textfield")), usr->gender);
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_hobbies_textfield")), usr->hobbies);
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_age_textfield")), age);
		
		g_free(age);
		g_free(user_json_file);
	}else
		cem_add_to_log("can't find 'profile-view' ", J_LOG_ERROR);
	

}

/**
 * Ends profile viewer and frees all allocated memory
**/
gboolean end_profile_view(TangleActor* actor, gpointer data){

	DESTROY_ACTOR(avatar.body);
	DESTROY_ACTOR(avatar.hair);
	DESTROY_ACTOR(avatar.head);
	DESTROY_ACTOR(avatar.instrument);
	clear_container(avatarBackground);
	DESTROY_ACTOR(instrumentBackground);

	if(usr->username != NULL)
		free(usr->username);
			
	if(usr->gender != NULL)
		free(usr->gender);

	if(usr->hobbies != NULL)
		free(usr->hobbies);
	
	if(usr != NULL)
		free(usr); 

	if(strcmp(params->parent_view, "single-thread") == 0){
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("profile-view")));
		clutter_actor_show(jammo_get_actor_by_id("single-thread-view"));
	}
	if(strcmp(params->parent_view, "jammosongs") == 0){
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("profile-view")));
		clutter_actor_show(jammo_get_actor_by_id("jammosongs-view"));
	}	
	if(strcmp(params->parent_view, "helpdesk") == 0){
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("profile-view")));
		clutter_actor_show(jammo_get_actor_by_id("helpdesk-view"));
	}
	if(strcmp(params->parent_view, "discuss") == 0){
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("profile-view")));
		clutter_actor_show(jammo_get_actor_by_id("threads-view"));
	}		

	return TRUE;
}

/**
 * Loads profile information from json file given as parameter
**/
gboolean parse_user_profile_from_file(gchar* filename) 
{	
	JsonParser *parser;
	JsonNode *root;
	JsonObject *object;
	JsonNode *node;
	
	parser = json_parser_new();
	g_assert (JSON_IS_PARSER(parser));
	GError *error = NULL;
	
	if (!json_parser_load_from_file (parser, filename, &error)){
		g_print ("Error: %s\n", error->message);
		g_error_free (error);
		g_object_unref (parser);
		return FALSE;
	}
	if(json_parser_get_root(parser) != NULL){
		root = json_parser_get_root (parser);
	}else{
		return FALSE;
	}
	if(JSON_NODE_TYPE(root) != JSON_NODE_OBJECT)
		return FALSE;

	object = json_node_get_object (root);
	if(object == NULL)
		return FALSE;

	node = json_object_get_member (object, "user_properties");

	if (node != NULL && (JSON_NODE_TYPE(node) == JSON_NODE_OBJECT)){
			
			JsonObject* sub_object = json_node_get_object(node);
			JsonNode *sub_node;
			
			gchar* username = "";
			gchar* hobbies =  "";
			gchar* gender =  "";

			printf("\nFound user profile!\n");
			
			sub_node = json_object_get_member(sub_object, "username"); 
			if (sub_node != NULL && JSON_NODE_TYPE(sub_node) == JSON_NODE_VALUE){
				username = (gchar*)json_node_get_string(sub_node);
			}		
			sub_node = json_object_get_member(sub_object, "hobbies");
			if (sub_node != NULL && JSON_NODE_TYPE(sub_node) == JSON_NODE_VALUE){
				hobbies = json_node_get_string(sub_node);
			}
			sub_node = json_object_get_member(sub_object, "gender"); 
			if (sub_node != NULL && JSON_NODE_TYPE(sub_node) == JSON_NODE_VALUE){ 
				gender = json_node_get_string(sub_node);			
			}	
			usr = malloc(sizeof(user_type));	
			
			usr->username = malloc(strlen(username)+sizeof(gchar));
			strcpy(usr->username, username);	

			usr->hobbies = malloc(strlen(hobbies)+sizeof(gchar));
			strcpy(usr->hobbies, hobbies);

			usr->gender = malloc(strlen(gender)+sizeof(gchar));
			strcpy(usr->gender, gender);
			
		} //User profile is ready

	g_object_unref(parser);

	return TRUE;
}
