/*
License: GPLv2, read more from COPYING

This file contains the functionality of discuss menu.
 */

#ifndef DISCUSS_H_
#define DISCUSS_H_

#include <glib.h>
#include <glib-object.h>

typedef struct {
	gchar *id;	
	gint  index;
	guint32 user_id;
	gchar title[50];	
	gchar *json;
	gchar date[17];
}discussion_type;

void start_discuss();
void start_discussionthreads();
void start_addthread_view();
gboolean addDiscussion(gpointer data, int num);
gboolean addThread(gpointer data, int number);
void end_discuss();
void clear_discussions(GList* list_);
void add_new_thread();
void getThread(ClutterActor *element);
gboolean getAllDiscussionThreads();
gboolean getAllMessages(const gchar* messages_file);
gboolean load_threads_from_server(gchar* currentThread);
gboolean sendJammoThread(gchar* thread_path, gchar* messages_path);
gboolean discuss_change_to_threads_view(ClutterActor * element);
gboolean discuss_change_to_discussion_view(TangleActor *actor, gpointer data);
gboolean discuss_change_to_add_thread_view(TangleActor *actor, gpointer data);
gboolean parse_discussions_from_file(gchar* filename, int type);
gboolean discuss_send_thread(gint index, guint32 userid, gchar* sender, gchar* title, gchar* msg, gchar* filepath, gchar* time, int msgtype);
gboolean send_discussthread(gint dthread_index, guint32 userid, gchar* dthread_title, gchar* json_path, gchar* date);
ClutterActor *create_line(int y, int length, int size, ClutterContainer *cont);

#endif 
