#include "single_thread.h"
#include <stdio.h>
#include <tangle.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <meam/jammo-meam.h>
#include <meam/jammo-sample.h>
#include "../jammo.h"
#include "../../cem/cem.h"
#include "community_utilities.h"
#include "jammosongs.h"
#include "help.h"
#include "jammosounds.h"
#include "discuss.h"
#include "mysongs.h"
#include "profile_viewer.h"

static ClutterContainer *messageList = 0;
static int selected_index = 0;
static GList* messages;
extern GList* paramsList;
static gchar *id;
static TextField text;
gchar filepath [150];

void start_thread_view(GList* listOfMessages, gchar *id_, gchar *params, int index_parameter)
{
	GList *l = 0; //Iterator

	selected_index = index_parameter;
	messages 	= listOfMessages;
	id 		= id_;

	cem_add_to_log("starting thread...", J_LOG_DEBUG);

	ClutterActor* thread_view = jammo_get_actor_by_id("single-thread-view");

	if(thread_view)
	{
		clutter_actor_show(thread_view);

		if(strcmp(id, "jammosongs") == 0){
			clutter_actor_hide(jammo_get_actor_by_id("text-answer-widgets"));
			clutter_actor_show(jammo_get_actor_by_id("select-comment-type"));

		}else if((strcmp(id, "discuss") == 0) || (strcmp(id, "mysongs") == 0)){
			text.text = jammo_get_actor_by_id("answer-field");
			text.lineCount = 8;
			text.max_characters = 500;
			text.handler_id = g_signal_connect_swapped(text.text, "text-changed", (GCallback)limit_line_count, &text);
			clutter_text_set_text(CLUTTER_TEXT(text.text), "");

		}else if(strcmp(id, "helpdesk") == 0){
			text.text = jammo_get_actor_by_id("answer-field");
			text.lineCount = 6;
			text.max_characters = 500;
			text.handler_id = g_signal_connect_swapped(text.text, "text-changed", (GCallback)limit_line_count, &text);
			clutter_text_set_text(CLUTTER_TEXT(text.text), "");
		}	
		
		if(messages != NULL)
		{
			messages = g_list_first(messages);
			
			messageList = CLUTTER_CONTAINER(jammo_get_actor_by_id("single-thread-list-scrollable"));		
				
			for(l = messages; l; l = l->next)
			add_message_to_list(l->data, index_parameter);
		}
	}
	else
	cem_add_to_log("can't find single-thread-view", J_LOG_ERROR);
}

gboolean text_comment_view(TangleActor* actor, gpointer data) {
	clutter_actor_hide(jammo_get_actor_by_id("select-comment-type"));
	clutter_actor_show(jammo_get_actor_by_id("text-answer-widgets"));
	text.text = jammo_get_actor_by_id("answer-field");
	text.lineCount = 6;
	text.max_characters = 500;
	text.handler_id = g_signal_connect_swapped(text.text, "text-changed", (GCallback)limit_line_count, &text);
	clutter_text_set_text(CLUTTER_TEXT(text.text), "");

	return TRUE;
}


void add_message_to_list(gpointer data, int i) 
{
	message *msg = data;

	if(msg->index == i)	//If the messages index is the same as i (question number, we selected) then add it to list.
	{
		int index_counter = 0;
		int MAX = 500;
		int h = 80;
		
		profile_view_params *params = malloc(sizeof(profile_view_params));
		
		paramsList = g_list_append(paramsList, params);
		
		params->user_id = msg->user_id;
		strcpy(params->parent_view, "single-thread");
		
		Avatar avatar = {0,0,0,0};
		guint32 avatar_id;
		avatar_id = gems_profile_manager_get_avatar_id(gems_profile_manager_get_profile_of_user(msg->user_id));
		
		if(avatar_id == 0)
			avatar_id = 260; //default avatar
		
		community_get_avatar(&avatar, avatar_id);
		
		ClutterActor* messageBackground = 0;
		ClutterContainer *listContainer = CLUTTER_CONTAINER(clutter_group_new());
	
		ClutterColor text_color = { 0, 0, 0, 255 };
		ClutterColor line_color = { 144, 148, 140, 255 };

		ClutterActor* avatarBackground = clutter_group_new();
		gchar* avatarbg_filename = g_strdup_printf("%s/communitymenu/community_avatarbackground_small.png", DATA_DIR);		

		clutter_container_add_actor(CLUTTER_CONTAINER(avatarBackground), tangle_texture_new(avatarbg_filename));
		ClutterActor* writer = tangle_button_new_with_background_actor(avatarBackground);
		
		ClutterActor* name = clutter_text_new_full(TEXT_NORMAL, msg->sender, &text_color);
		ClutterActor* date = clutter_text_new_full(TEXT_NORMAL, msg->time, &text_color);
		//ClutterActor* avatar_ = clutter_text_new_full(TEXT_SMALL, msg->avatar, &text_color);
		community_shrink_and_set_avatar(&avatar, CLUTTER_CONTAINER(avatarBackground));
		clutter_container_add_actor(CLUTTER_CONTAINER(listContainer), writer);
		
		index_counter = (index_counter+1) % 3;

		if(strcmp(msg->title, "") != 0){
			ClutterActor* title = clutter_text_new_full(TEXT_LARGE, msg->title, &text_color);
			clutter_actor_set_position(title, 80, 10);
			clutter_container_add_actor(listContainer, title);

			clutter_actor_set_position(name, 80, 40); 		
		}else{
			clutter_actor_set_position(name, 80, 20); 
		}
		g_free(avatarbg_filename);

		clutter_actor_set_size(name,((35*10)+30), 41);
		clutter_text_set_max_length(CLUTTER_TEXT(name), 20);
		clutter_container_add_actor(listContainer, name);

		clutter_actor_set_size(date,((20*10)), 20);
		clutter_text_set_max_length(CLUTTER_TEXT(date), 16);
		clutter_actor_set_position(date, 600, 10);
		clutter_container_add_actor(listContainer, date);
		
		g_signal_connect_swapped(writer, "clicked", G_CALLBACK(start_profile_view), (gpointer)params);

		if(msg->type == TEXT_COMMENT){
			ClutterActor* message_actor = clutter_text_new_full(TEXT_SMALL, msg->msg, &text_color);
			clutter_text_set_line_wrap_mode(CLUTTER_TEXT(message_actor), PANGO_WRAP_WORD_CHAR);
				//clutter_actor_set_size(message_actor,(88*7)+40, ((MAX/88)*27));
			clutter_actor_set_width(message_actor, (88*7)+40);
			clutter_text_set_max_length(CLUTTER_TEXT(message_actor), MAX);
			clutter_actor_set_position(message_actor, 80, 80);
			clutter_container_add_actor(listContainer, message_actor);
			h = (clutter_actor_get_height(avatarBackground) + pango_layout_get_line_count(clutter_text_get_layout(CLUTTER_TEXT(message_actor)))*25);	
		}

		if(msg->type == VOICE_COMMENT){
			
			strcpy(filepath, msg->filepath);
			
			gchar* play_button_filename = g_strdup_printf("%s/buttons/play-button.png", DATA_DIR);
			ClutterActor* play_button = 0;
			play_button = tangle_button_new_with_background_actor(tangle_texture_new(play_button_filename)); 
			clutter_actor_set_position(play_button, 400, 1);
			clutter_container_add_actor(listContainer, play_button);

			g_signal_connect_swapped(CLUTTER_ACTOR(play_button), "clicked", G_CALLBACK(play_selected_loop), filepath);
			g_free(play_button_filename);

		}

		messageBackground = clutter_rectangle_new_with_color(&line_color);
		clutter_actor_set_size(messageBackground, 800, 2);

		clutter_actor_set_position(avatarBackground, 10, 1);
		clutter_container_add_actor(listContainer, avatarBackground);

		clutter_actor_set_position(messageBackground, 0, h+10);
		clutter_container_add_actor(listContainer, messageBackground);

		clutter_container_add_actor(messageList, CLUTTER_ACTOR(listContainer));
	}
}

gboolean add_comment(TangleActor* actor, gpointer data) {
	message *msg;
	time_type now;
	now = get_current_time();

	if(clutter_text_get_text(CLUTTER_TEXT(text.text)) == NULL || (strcmp(clutter_text_get_text(CLUTTER_TEXT(text.text)), "") == FALSE))
	{
		cem_add_to_log("No text entered\n", J_LOG_DEBUG);
		return FALSE;
	}

	clear_container(messageList);

	msg = malloc(sizeof(message));
	msg->index = selected_index;	//asd
	msg->msg = malloc((strlen(clutter_text_get_text(CLUTTER_TEXT(text.text)))+1) * sizeof(gchar));
	msg->user_id = 0;
	strcpy(msg->msg, clutter_text_get_text(CLUTTER_TEXT(text.text)));
	strcpy(msg->title, messages == 0 ? "" : ((message*)g_list_first(messages)->data)->title);
	strcpy(msg->sender, "Sender");
	strcpy(msg->time, now.time); 
	msg->filepath = 0;
	msg->type = TEXT_COMMENT;

	messages = g_list_append(messages, (gpointer)msg);

	start_thread_view(messages, id, NULL, selected_index);

	return TRUE;
}

gboolean add_voice_comment (TangleActor* actor, gpointer data) {
	static gboolean isrecording = FALSE;
	message *msg;
	time_type now;

	if(!isrecording){
		isrecording = TRUE;
		record_voice_comment();
	}else{
		stop_recording();
		isrecording = FALSE;

		clear_container(messageList);

		msg = malloc(sizeof(message));

		now = get_current_time();
		msg->type = VOICE_COMMENT;

		strcpy(msg->sender, "Sender");
		strcpy(msg->title, "");
		msg->user_id = 0;
		strcpy(msg->time, now.time); 
		msg->filepath = malloc(strlen(g_strdup_printf("%s/last_recorded.ogg",configure_get_jammo_directory()))+1);
		msg->filepath = g_strdup_printf("%s/last_recorded.ogg",configure_get_jammo_directory());
		msg->msg = 0;
		msg->index = 0;

		messages = g_list_append(messages, (gpointer)msg);

		start_thread_view(messages, id, NULL, selected_index);		
	}

	return TRUE;
}

gboolean end_single_thread(TangleActor* actor, gpointer data){
	community_clear_paramslist(paramsList);
	paramsList = 0;

	clear_messagelist(messages);

	g_list_free(g_list_first(messages));	

	clear_container(messageList);

	if(strcmp(id, "helpdesk") == 0 )
	start_helpdesk();

	else if (strcmp(id, "jammosongs") == 0)
	start_jammosongs();

	else if (strcmp(id, "jammosounds") == 0)
	start_jammosounds();

	else if (strcmp(id, "discuss") == 0)
	start_discussionthreads();
	
	else if(strcmp(id, "mysongs") == 0)
	start_mysongs();

	else {} //do nothing

	return TRUE;
}
