/*
License: GPLv2, read more from COPYING

This file contains the functionality of help menu.
 */
#include <tangle.h>
#include <string.h>
#include "communitymenu.h"
#include "startmenu.h"
#include "../jammo.h"
#include "help.h"
#include "community_utilities.h"
#include "profile_viewer.h"
#include "single_thread.h"
#include "src/configure.h"
#include <libintl.h>
#include "../../cem/cem.h"

static list_type questionslist = {0, 0};

static int selectedQuestion = 0;
static GList *helpdesk_messages = 0;
static GList *paramsList = 0;

static TextField addquestion_titleTextField;
static TextField addquestion_questionTextField;

void start_helpdesk(void)
{
	cem_add_to_log(_("Starting Helpdesk"), J_LOG_DEBUG);
	helpdesk_messages = 0;
	helpdesk_get_questions();
	helpdesk_show_helpdesk_view();
}

gboolean helpdesk_goto_communitymenu(TangleButton *tanglebutton, gpointer none)
{
	end_helpdesk();
	start_communitymenu();
	return TRUE;
}

gboolean helpdesk_goto_startmenu(TangleButton *tanglebutton, gpointer none)
{
	end_helpdesk();
	startmenu_goto_startmenu(tanglebutton, none);
	return TRUE;
}

gboolean helpdesk_mentor_clicked (TangleButton *tanglebutton, gpointer data)   
{
	cem_add_to_log(_("Mentor Clicked"), J_LOG_DEBUG);
	return TRUE;
}

void helpdesk_get_questions(void)
{
	//TODO: Create code for fetching helpdesk questions from remote server
	cem_add_to_log(_("Fetching Questions From Community Server"), J_LOG_DEBUG);
}

void end_helpdesk(void)
{
	
	community_clear_paramslist(paramsList);
	
	paramsList = 0;

	clear_container(questionslist.list);
	clear_messagelist(helpdesk_messages);
	g_list_free(helpdesk_messages);
}

GList* helpdesk_get_number_of_questions(void)
{
	GList *l = 0; //Iterator
	GList *temp = 0;

	helpdesk_messages = g_list_first(helpdesk_messages);

	int index_counter = -1;

	if(g_list_length(helpdesk_messages) != 0)
	{
		for(l = helpdesk_messages; l; l = l->next)
		{
			message *temp_msg = l->data;

			if(temp_msg->index > index_counter)
			{
				index_counter = temp_msg->index;
				temp = g_list_append(temp, (gpointer)temp_msg);
			}
		}

		g_list_first(temp);
		return temp;
	}
	else	return NULL;
}

void helpdesk_show_helpdesk_view(void)
{
	GList *questions = helpdesk_get_number_of_questions();
	GList *l = 0; //Iterator

	int number_of_questions = g_list_length(questions);

	ClutterActor* mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	ClutterActor* help_view = jammo_get_actor_by_id("helpdesk-view");

	if(help_view)
	{
		clutter_actor_show(CLUTTER_ACTOR(help_view));
		clutter_actor_show(jammo_get_actor_by_id("helpdesk-no-questions-textfield"));

		if(number_of_questions >= 5)
		{
			questionslist.list = CLUTTER_CONTAINER(jammo_get_actor_by_id("helpdesk-list-scrollable"));	
			ClutterAction *listAction = tangle_actor_get_action_by_type(CLUTTER_ACTOR(questionslist.list), TANGLE_TYPE_SCROLL_ACTION);
			g_signal_connect_swapped(listAction, "clamp-offset-y", G_CALLBACK(community_autoscroll_to_correct_pos), &questionslist);
		}
		else	questionslist.list = CLUTTER_CONTAINER(jammo_get_actor_by_id("helpdesk-list-unscrollable"));

		if(number_of_questions != 0)
		{	
			clutter_actor_hide(jammo_get_actor_by_id("helpdesk-no-questions-textfield"));
			
			for(l = questions; l; l = l->next)
			helpdesk_add_question_to_list(l->data, 0);
		}
		if(number_of_questions <= 5)
			clutter_actor_set_height(CLUTTER_ACTOR(questionslist.list), questionslist.listItemHeight * number_of_questions);	
		
		else	clutter_actor_set_height(CLUTTER_ACTOR(questionslist.list), questionslist.listItemHeight * 5);	

	}
	else 	cem_add_to_log(_("Can't find 'helpdesk-view'"), J_LOG_DEBUG);

	g_list_free(questions);
}

void helpdesk_show_question_view(ClutterActor *actor)
{
 	helpdesk_find_selected_actor(actor);

	clear_container(questionslist.list);	

	ClutterActor* mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);

	///TRANSLATORS: Leave %d as is because it is needed
	cem_add_to_log(_("Showing Question: %d"), selectedQuestion);

	start_thread_view(helpdesk_messages, "helpdesk", NULL, selectedQuestion);
}

gboolean helpdesk_show_addquestion_view(TangleActor* actor, gpointer data) {
	cem_add_to_log(_("Starting AddQuestion View"), J_LOG_DEBUG);

	clear_container(questionslist.list);

	ClutterActor* mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* comment_view = jammo_get_actor_by_id("helpdesk-addquestion-view");	

	if(comment_view) 
	{
		clutter_actor_show(CLUTTER_ACTOR(comment_view));

		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("helpdesk-addquestion-title")), _("Add Your Topic Here"));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("helpdesk-addquestion-description")), _("Add Your Question Here"));

		addquestion_titleTextField.text = jammo_get_actor_by_id("helpdesk-addquestion-title");
		addquestion_titleTextField.lineCount = 3;
		addquestion_titleTextField.max_characters = 100;
		addquestion_titleTextField.handler_id = g_signal_connect_swapped(addquestion_titleTextField.text,
							"text-changed", (GCallback)limit_line_count, &addquestion_titleTextField);		

		addquestion_questionTextField.text = jammo_get_actor_by_id("helpdesk-addquestion-description");
		addquestion_questionTextField.lineCount = 11;
		addquestion_questionTextField.lineCount = 300;
		addquestion_questionTextField.handler_id = g_signal_connect_swapped(addquestion_questionTextField.text,
							"text-changed", (GCallback)limit_line_count, &addquestion_questionTextField);		
	}
	else 	
		cem_add_to_log("can't find 'helpdesk-addquestion-view' ", J_LOG_ERROR);

	return TRUE;
}

void helpdesk_add_question(void)
{
	cem_add_to_log(_("Adding Question"), J_LOG_DEBUG);

	int index_counter = 0;

	helpdesk_messages = g_list_first(helpdesk_messages);

	if(g_list_length(helpdesk_messages) != 0)
	{
		while(helpdesk_messages->next != NULL)
		{
			helpdesk_messages = helpdesk_messages->next;

			message *temp = helpdesk_messages->data;

			if(temp->index > index_counter)
			index_counter = temp->index;
		}

		index_counter++;
	}

	//Next we add the message to helpdesk_messages list

	message *msg = 0;
	time_type now;

	now = get_current_time();

	msg = calloc(sizeof (message), 1);
	msg->index = index_counter;
	msg->msg = malloc(strlen(clutter_text_get_text(CLUTTER_TEXT(addquestion_questionTextField.text)))+1);
	strcpy(msg->msg, clutter_text_get_text(CLUTTER_TEXT(addquestion_questionTextField.text)));
	msg->user_id = 0; //TODO: this must be the user_id of the writer of the question
	strncpy(msg->title, clutter_text_get_text(CLUTTER_TEXT(addquestion_titleTextField.text)), 100);
	msg->title[99] = 0;
	strncpy(msg->sender, "Sender",20);
	msg->sender[19] = 0;
	strcpy(msg->time, now.time); 
	msg->type = TEXT_COMMENT;
	helpdesk_messages = g_list_append(helpdesk_messages, (gpointer)msg);

	helpdesk_show_helpdesk_view();
}

gboolean helpdesk_goto_helpdesk_clicked(TangleActor *actor, gpointer data){
	helpdesk_show_helpdesk_view();
	return TRUE;
}

gboolean helpdesk_add_question_clicked(TangleActor *actor, gpointer data){
	helpdesk_add_question();
	return TRUE;
}


gboolean helpdesk_add_question_to_list(gpointer data, guint user_id)
{	
	gchar* colorbar_path = g_strdup_printf("%s/communitymenu/colorbar13.png", DATA_DIR);
	gchar* avatarBackground_path = g_strdup_printf("%s/communitymenu/community_avatarbackground_small.png", DATA_DIR);

	ClutterContainer *listContainer = CLUTTER_CONTAINER(clutter_group_new());

	ClutterActor *colorbar = tangle_texture_new(colorbar_path);
	ClutterActor *avatarBackground = clutter_group_new();
	ClutterActor *composer = tangle_button_new_with_background_actor(avatarBackground);
	ClutterActor *commentButton = tangle_button_new_with_background_actor(tangle_texture_new(
					"communitymenu/community_comment_icon.png"));
	clutter_container_add_actor(CLUTTER_CONTAINER(avatarBackground), tangle_texture_new(avatarBackground_path));

	message *msg = data;

	char topictitle[25];
	strncpy(topictitle, msg->title, 25);

	ClutterActor *text = clutter_text_new_with_text(TEXT_CAPTION, topictitle);	
	ClutterActor *questionButton = tangle_button_new_with_background_actor(text);

	profile_view_params *params = malloc(sizeof(profile_view_params));
	strcpy(params->parent_view, "helpdesk");
	params->user_id = user_id;

	paramsList = g_list_append(paramsList, params);

	guint32 avatar_id = gems_profile_manager_get_avatar_id(gems_profile_manager_get_profile_of_user(user_id));

	if (avatar_id == 0)
		avatar_id = 260; //default avatar

	Avatar avatar = {0,0,0,0};

	community_get_avatar(&avatar, avatar_id);
	community_shrink_and_set_avatar(&avatar, CLUTTER_CONTAINER(avatarBackground));	

	clutter_container_add_actor(listContainer, composer);

	if(colorbar == NULL || commentButton == NULL)
	{	
		cem_add_to_log("NULL Pointer Detected!", J_LOG_DEBUG);
		return FALSE;	
	}

	if(questionslist.listItemHeight == 0) questionslist.listItemHeight = clutter_actor_get_height(composer) + 1;

	clutter_actor_set_position(colorbar, 0, questionslist.listItemHeight - 1);
	clutter_container_add_actor(listContainer, colorbar);		//Add components inside the container

	clutter_actor_set_position(questionButton, 60, 23);			
	clutter_container_add_actor(listContainer, questionButton);

	clutter_actor_set_position(commentButton, 690, 15);
	clutter_container_add_actor(listContainer, commentButton);

	g_signal_connect_swapped(CLUTTER_ACTOR(questionButton), "clicked", G_CALLBACK(helpdesk_show_question_view), 
						clutter_actor_get_parent(questionButton));

	g_signal_connect_swapped(CLUTTER_ACTOR(commentButton), "clicked", G_CALLBACK(helpdesk_show_question_view), 
						clutter_actor_get_parent(commentButton));
	g_signal_connect_swapped(CLUTTER_ACTOR(composer), "clicked", G_CALLBACK(start_profile_view), (gpointer)params);

	clutter_container_add_actor(questionslist.list, CLUTTER_ACTOR(listContainer));	
	g_free(colorbar_path);
	g_free(avatarBackground_path);

	return TRUE;
}

void helpdesk_find_selected_actor(ClutterActor *actor)
{
	GList *children = clutter_container_get_children(questionslist.list); //Get list of actors
	GList *l; //Iterator

	int index_counter = 0;

	for(l = children; l; l = l->next)
	{
		if(actor == l->data)
		{
			selectedQuestion = index_counter;
			break;
		}

		index_counter++;
	}

	g_list_free(children);
}
