#include <tangle.h>
#include "config.h"
#include "../jammo.h"
#include "../7-12gui/community_utilities.h"
#include "../7-12gui/avatar_editor.h"
#include "../../gems/gems_utils.h"
#include "../../gems/gems.h"
#include "login_screen.h"
#include <glib.h>
#include <stdlib.h>

static gint is_reset_passwd=0; 
ClutterActor *pg_login_screen_container;

#ifdef USER_SELECTION_LOGIN

#define A_WIDTH 100
#define A_HEIGHT 160
#define EXIT_BUTTON_SIDE 80
#define BORDER 10

#define GUESTACCOUNT "Guest"

guint listpos = 0;
static Avatar avtr = {0,0,0,0};

void change_username(ClutterText* text)
{
	guint listsize = 0;
	gchar** list = gems_list_saved_profiles(&listsize);
	
	if((list) && (listsize > 0))
	{
		if (listpos < listsize) clutter_text_set_text(text,list[listpos]);
		else if (listpos == listsize) clutter_text_set_text(text,GUESTACCOUNT);
	}
	
}

static gboolean left_clicked(ClutterActor* actor, ClutterEvent* event, gpointer user_data)
{
	guint listsize = 0;
	if(gems_list_saved_profiles(&listsize))
	{
		if ((listpos > 0) && (listsize > 0)) listpos--;
		else if (listpos == 0) listpos = listsize ;
		
		change_username((ClutterText*)user_data);
	}
	return TRUE;
}

static gboolean right_clicked(ClutterActor* actor, ClutterEvent* event, gpointer user_data)
{
	guint listsize = 0;
	if(gems_list_saved_profiles(&listsize))
	{
		if(listpos < listsize) listpos++;
		else listpos = 0;
		change_username((ClutterText*)user_data);
	}
	return TRUE;
}

static gboolean avatar_clicked(ClutterActor* actor, ClutterEvent* event, gpointer user_data)
{
	guint listsize = 0;
	gchar** list = gems_list_saved_profiles(&listsize);
	
	// Login as quest ?
	if(g_strcmp0(clutter_text_get_text((ClutterText*)user_data), GUESTACCOUNT) == 0) 
	{
		login_screen_set_login_name(GUESTACCOUNT);
	}
	else
	{
		gems_set_login_username(list[listpos],FALSE);
		login_screen_set_login_name(gems_get_login_username());
	}
	
	clutter_actor_hide(pg_login_screen_container);
	return TRUE;
}

#endif

gint get_is_reset_password ()
{
	return is_reset_passwd;
}

static gboolean
pg_on_main_exit (ClutterRectangle *rect, ClutterEvent *event, gpointer data)
{  
	clutter_main_quit();  
	return TRUE; 
}

#ifndef USER_SELECTION_LOGIN
static gboolean
pg_on_reset_password (ClutterRectangle *rect, ClutterEvent *event, gpointer data)
{
	is_reset_passwd=1;	
	clutter_actor_hide(pg_login_screen_container);
 	return TRUE; 
}
#endif

static gboolean
pg_on_error_screen_exit_release (ClutterRectangle *rect, ClutterEvent *event, gpointer data)
{

	extern int i_plus;
	g_print("mouse pressed\n");
	gfloat x = 0;
	gfloat y = 0;
	clutter_event_get_coords (event, &x, &y);
	i_plus = 0;
	clutter_actor_hide(CLUTTER_ACTOR(rect));
	return FALSE;
}

static gboolean
pg_on_error_screen_exit_enter(ClutterRectangle *rect, ClutterEvent *event, gpointer data)
{
	return TRUE;
}


static gboolean
pg_on_reset_success_screen_exit (ClutterRectangle *rect, ClutterEvent *event, gpointer data)
{	
	gfloat x = 0;
 	gfloat y = 0;
  	clutter_event_get_coords (event, &x, &y);		
	clutter_actor_hide(CLUTTER_ACTOR(rect));
	clutter_actor_show(jammo_get_actor_by_id("main-menu-view"));
	clutter_actor_hide (jammo_get_actor_by_id("pen-gesture-view"));
	
	return TRUE; 
}

#ifndef USER_SELECTION_LOGIN
static gboolean
pg_on_continue_login (ClutterRectangle*actor, ClutterEvent *event, gpointer data)
{
  gfloat x = 0;
  gfloat y = 0;
  clutter_event_get_coords (event, &x, &y);
  clutter_actor_hide(pg_login_screen_container);

  return TRUE; 
}
#endif

#ifndef USER_SELECTION_LOGIN
static gboolean
pg_on_skip_passwd (ClutterRectangle*actor, ClutterEvent *event, gpointer data)
{
	
	clutter_actor_show(jammo_get_actor_by_id("main-menu-view"));
	clutter_actor_hide(jammo_get_actor_by_id("pen-gesture-view"));
	return TRUE;
}
#endif

void pg_set_reset_success_screen(ClutterActor *stage, gchar *filename)
{
	//A container	
	ClutterColor pg_black_color = { 0x00, 0x00, 0x00, 0xff };
	ClutterActor *container = clutter_group_new();
  	clutter_actor_set_position (container, 0, 0);
	clutter_actor_set_size(container,800,480);
  	clutter_container_add_actor (CLUTTER_CONTAINER (stage), container);	
	clutter_actor_set_reactive (container, TRUE);


	//A Layer to achieve black opacity
	ClutterActor *b_layer = clutter_rectangle_new_with_color (&pg_black_color);
 	clutter_actor_set_size (b_layer, 800, 480);
	clutter_actor_set_position (b_layer, 0, 0);
	clutter_actor_set_opacity(b_layer,200);
  	clutter_container_add_actor (CLUTTER_CONTAINER (container), b_layer);
  	

	//Loading an error image
	gchar* pg_directory_path = PG_IMAGES_DIR;	
	gchar* path = g_build_filename (pg_directory_path, filename, NULL);
	ClutterActor *reset_success_screen = tangle_texture_new (path);
	clutter_actor_set_size (reset_success_screen, 300, 200);
	clutter_actor_set_position (reset_success_screen, 250, 100);	
	clutter_actor_show (reset_success_screen);
	clutter_container_add_actor (CLUTTER_CONTAINER (container), reset_success_screen);
	clutter_actor_set_reactive (reset_success_screen, TRUE);
	g_signal_connect (container, "button-press-event", G_CALLBACK (pg_on_reset_success_screen_exit), NULL);

}

void
pg_set_error_screen(ClutterActor *stage, gchar *filename)
{
	// A container
	ClutterColor pg_black_color = { 0x00, 0x00, 0x00, 0xff };
	ClutterActor *container = clutter_group_new();
  	clutter_actor_set_position (container, 0, 0);
	clutter_actor_set_size(container,800,480);
  	clutter_container_add_actor (CLUTTER_CONTAINER (stage), container);	
	clutter_actor_set_reactive (container, TRUE);
	clutter_actor_set_name(container, "overlay");

	// A Layer to achieve black opacity
	ClutterActor *b_layer = clutter_rectangle_new_with_color (&pg_black_color);
 	clutter_actor_set_size (b_layer, 800, 480);
	clutter_actor_set_position (b_layer, 0, 0);
	clutter_actor_set_opacity(b_layer,200);
  	clutter_container_add_actor (CLUTTER_CONTAINER (container), b_layer);

	// Loading an error image
	gchar* pg_directory_path = PG_IMAGES_DIR;	
	gchar* path = g_build_filename (pg_directory_path, filename, NULL);
	ClutterActor *error_screen = tangle_texture_new (path);
	clutter_actor_set_size (error_screen, 300, 200);
	clutter_actor_set_position (error_screen, 250, 100);	
	clutter_actor_show (error_screen);
	clutter_container_add_actor (CLUTTER_CONTAINER (container), error_screen);
	clutter_actor_set_reactive (error_screen, TRUE);

	//g_signal_connect (container, "button-press-event", G_CALLBACK (pg_on_error_screen_exit), NULL);
	g_signal_connect (container, "button-release-event", G_CALLBACK (pg_on_error_screen_exit_release), NULL);
	g_signal_connect (container, "enter-event", G_CALLBACK (pg_on_error_screen_exit_enter), NULL);
}

void
pg_set_select_option_screen(ClutterActor *stage)
{
	// Login container
	pg_login_screen_container = clutter_group_new();
  	clutter_actor_set_position(pg_login_screen_container, 0, 0);
	clutter_actor_set_size(pg_login_screen_container,clutter_actor_get_width(stage),clutter_actor_get_height(stage));
  	clutter_container_add_actor(CLUTTER_CONTAINER (stage),pg_login_screen_container);
	clutter_actor_set_reactive(pg_login_screen_container, TRUE);

	// A Layer to achieve black opacity
	ClutterColor pg_black_color = { 0x00, 0x00, 0x00, 0xff };
	ClutterActor *b_layer = clutter_rectangle_new_with_color (&pg_black_color);
	clutter_actor_set_position (b_layer, 0, 0);
	clutter_actor_set_size (b_layer, clutter_actor_get_width(stage), clutter_actor_get_height(stage));
	clutter_actor_set_opacity(b_layer,220);
	clutter_container_add_actor (CLUTTER_CONTAINER(pg_login_screen_container), b_layer);

#ifdef USER_SELECTION_LOGIN
	ClutterColor actor_color = { 0xff, 0xff, 0xfa, 0x99 };

	// left box - prev
	ClutterActor* left = clutter_rectangle_new_with_color(&actor_color);
	clutter_actor_set_size(left,A_WIDTH,A_HEIGHT);
	clutter_actor_set_anchor_point(left,0,0);
	clutter_actor_set_position(left,clutter_actor_get_width(stage)/4-A_WIDTH,clutter_actor_get_height(stage)/2 - (A_HEIGHT/2));
	clutter_container_add_actor(CLUTTER_CONTAINER(pg_login_screen_container),left);
	clutter_actor_show(left);
	clutter_actor_set_reactive(left, TRUE);
	
	// left box text
	ClutterActor* text_prev = clutter_text_new_full("Sans 22","PREV",&pg_black_color);
	clutter_actor_set_size(text_prev,A_WIDTH-BORDER,A_HEIGHT-BORDER);
	clutter_actor_set_position(text_prev,clutter_actor_get_width(stage)/4-A_WIDTH+BORDER,clutter_actor_get_height(stage)/2);
	clutter_container_add_actor(CLUTTER_CONTAINER(pg_login_screen_container),text_prev);
	clutter_actor_show(text_prev);
  
	// right box - next
	ClutterActor* right = clutter_rectangle_new_with_color(&actor_color);
	clutter_actor_set_size(right,A_WIDTH,A_HEIGHT);
	clutter_actor_set_anchor_point(right,0,0);
	clutter_actor_set_position(right,clutter_actor_get_width(stage)*3/4,clutter_actor_get_height(stage)/2 - (A_HEIGHT/2));
	clutter_container_add_actor(CLUTTER_CONTAINER(pg_login_screen_container),right);
	clutter_actor_show(right);
	clutter_actor_set_reactive(right, TRUE);
	
	// right box text
	ClutterActor* text_next = clutter_text_new_full("Sans 22","NEXT",&pg_black_color);
	clutter_actor_set_size(text_next,A_WIDTH-BORDER,A_HEIGHT-BORDER);
	clutter_actor_set_position(text_next,clutter_actor_get_width(stage)*3/4+BORDER,clutter_actor_get_height(stage)/2);
	clutter_container_add_actor(CLUTTER_CONTAINER(pg_login_screen_container),text_next);
	clutter_actor_show(text_next);
	
	// exit button
	ClutterActor* exit_button = clutter_rectangle_new_with_color(&actor_color);
	clutter_actor_set_size(exit_button,EXIT_BUTTON_SIDE,EXIT_BUTTON_SIDE);
	clutter_actor_set_anchor_point(exit_button,0,0);
	clutter_actor_set_position(exit_button,clutter_actor_get_width(stage)-EXIT_BUTTON_SIDE-BORDER, BORDER);
	clutter_container_add_actor(CLUTTER_CONTAINER(pg_login_screen_container),exit_button);
	clutter_actor_show(exit_button);
	clutter_actor_set_reactive(exit_button, TRUE);
	
	// exit button text
	ClutterActor* text_exit = clutter_text_new_full("Sans 18","EXIT",&pg_black_color);
	clutter_actor_set_size(text_exit,EXIT_BUTTON_SIDE,EXIT_BUTTON_SIDE);
	clutter_actor_set_position(text_exit,clutter_actor_get_width(stage)-EXIT_BUTTON_SIDE-BORDER*0.5,BORDER*1.5);
	clutter_container_add_actor(CLUTTER_CONTAINER(pg_login_screen_container),text_exit);
	clutter_actor_show(text_exit);

	// Username text
	ClutterActor* text = clutter_text_new_full("Sans 26","text",&actor_color);
	clutter_actor_set_size(text,380,80);
	clutter_actor_set_position(text,clutter_actor_get_width(stage)/4+BORDER,400);
	clutter_container_add_actor(CLUTTER_CONTAINER(pg_login_screen_container),text);
	clutter_actor_show(text);
  
  // Container for avatar (and the box behind it)
	ClutterActor* avatar_container = clutter_group_new();
	clutter_actor_set_size(avatar_container,380,320);
	clutter_actor_set_position(avatar_container,clutter_actor_get_width(stage)/4+BORDER,80);
	clutter_container_add_actor(CLUTTER_CONTAINER(pg_login_screen_container),avatar_container);
	
	// The box in the back
	ClutterActor* avatar_box = clutter_rectangle_new_with_color(&actor_color);
	clutter_actor_set_size(avatar_box,380,320);
	clutter_actor_set_position(avatar_box,clutter_actor_get_width(stage)/4+BORDER,80);
	clutter_container_add_actor(CLUTTER_CONTAINER(pg_login_screen_container),avatar_box);
	clutter_actor_show(avatar_box);
	clutter_actor_lower(avatar_box,avatar_container);
	clutter_actor_set_reactive(avatar_box, TRUE);

	g_signal_connect(left,"button-press-event",G_CALLBACK(left_clicked),text);
	g_signal_connect(right,"button-press-event",G_CALLBACK(right_clicked),text);
	g_signal_connect(avatar_box,"button-press-event",G_CALLBACK(avatar_clicked),text);
	g_signal_connect(exit_button,"button-press-event",G_CALLBACK(pg_on_main_exit),exit_button);
	
	// Set to first one in list
	change_username((ClutterText*)text);
	
	// Use the default avatar and add it to avatar container
	community_get_avatar(&avtr,260);
	set_avatar(&avtr,avatar_container,NULL,NULL);
	
#else
	// LOGIN
	gchar* pg_directory_path = PG_IMAGES_DIR;
	gchar* filename = "login_button.png";
	//FIXME: this is never free'ed.
	gchar* path = g_build_filename (pg_directory_path, filename, NULL);
	//FIXME: this is never free'ed.
	ClutterActor *login_button = tangle_texture_new (path);
	clutter_actor_set_size (login_button, 151, 45);
	clutter_actor_set_position (login_button, 30, 200);	
	clutter_actor_show (login_button);
	clutter_container_add_actor (CLUTTER_CONTAINER(pg_login_screen_container), login_button);
	clutter_actor_set_reactive (login_button, TRUE);
	//FIXME: this is never free'ed.
	g_signal_connect (login_button, "button-press-event", G_CALLBACK (pg_on_continue_login), NULL);
	
	// RESET
	gchar* filename1="reset_button.png";
	//FIXME: this is never free'ed.
	gchar* path1 = g_build_filename (pg_directory_path, filename1, NULL);
	//FIXME: this is never free'ed.
	ClutterActor *new_button = tangle_texture_new (path1);
	clutter_actor_set_size (new_button, 151, 45);
	clutter_actor_set_position (new_button, 210, 200);	
	clutter_actor_show (new_button);
	clutter_container_add_actor (CLUTTER_CONTAINER (pg_login_screen_container), new_button);
	clutter_actor_set_reactive (new_button, TRUE);
	//FIXME: this is never free'ed.
	g_signal_connect (new_button, "button-press-event", G_CALLBACK (pg_on_reset_password), NULL);

	// SKIP
	gchar* filename2="skip_button.png";
	//FIXME: this is never free'ed.
	gchar* path2 = g_build_filename (pg_directory_path, filename2, NULL);
	//FIXME: this is never free'ed.
	ClutterActor *skip_button = tangle_texture_new (path2);
	clutter_actor_set_size (skip_button, 151, 45);
	clutter_actor_set_position (skip_button, 410, 200);	
	clutter_actor_show (skip_button);
	clutter_container_add_actor (CLUTTER_CONTAINER (pg_login_screen_container), skip_button);
	clutter_actor_set_reactive (skip_button, TRUE);
	//FIXME: this is never free'ed.
	g_signal_connect (skip_button, "button-press-event", G_CALLBACK (pg_on_skip_passwd), NULL);

	// EXIT
	gchar* filename3="exit_button.png";
	//FIXME: this is never free'ed.
	gchar* path3 = g_build_filename (pg_directory_path, filename3, NULL);
	//FIXME: this is never free'ed.
	ClutterActor *exit_button = tangle_texture_new (path3);
	clutter_actor_set_size (exit_button, 151, 45);
	clutter_actor_set_position (exit_button, 610, 200);	
	clutter_actor_show (exit_button);
	clutter_container_add_actor (CLUTTER_CONTAINER (pg_login_screen_container), exit_button);
	clutter_actor_set_reactive (exit_button, TRUE);
	//FIXME: this is never free'ed.
	g_signal_connect (exit_button, "button-press-event", G_CALLBACK (pg_on_main_exit), NULL);
#endif

}

void pg_set_msg_from_image(ClutterActor *stage, gchar *filename, int pos_x, int pos_y)
{
	  gchar* pg_directory_path = PG_IMAGES_DIR;	  
		//FIXME: this is never free'ed.
	  gchar* path1 = g_build_filename (pg_directory_path, filename, NULL);
		//FIXME: this is never free'ed.
	  ClutterActor *message = tangle_texture_new (path1);
	  clutter_actor_set_size (message, 200, 100);
	  clutter_actor_set_position (message, pos_x, pos_y);
	  clutter_actor_show (message);
	  clutter_container_add_actor (CLUTTER_CONTAINER (stage), message);
	  clutter_actor_set_reactive (message, TRUE);
	  
}

void pg_re_enable_select_option_screen(ClutterActor *stage)
{
	if(pg_login_screen_container)
	{
		clutter_actor_show(pg_login_screen_container);
	}
	else pg_set_select_option_screen(stage);
}



