#include <tangle.h>
#include <glib-object.h>
#include <sys/time.h>
#include <sys/types.h>
#include <dirent.h>
#include "string.h"
#include <time.h>
#include <stdlib.h>
#include <sys/stat.h>
#include "mysongs.h"
#include "community_utilities.h"
#include "../jammo.h"
#include "../../meam/jammo-sample.h"

#include "../../configure.h"
#include "../file_helper.h"
#include "sequencer.h"

static gboolean renaming_loop = FALSE;

// milliseconds 1500
#define DURATION_OF_LONG_CLICK 1000

//Long click:  rename the item
static gboolean tap_and_hold_function(gpointer user_data) {

	ClutterActor* actor=CLUTTER_ACTOR(user_data);
	g_object_set_data(G_OBJECT(actor),"handler_for_longclick",GUINT_TO_POINTER(0));

	const char* filename = clutter_actor_get_name(actor);
	char* projects = configure_get_projects_directory();
	char* finalized = configure_get_finalized_directory();
	int type = -1;

	if(strncmp(filename, projects, strlen(projects)) == 0){ // project
		type = 0;
	}else if(strncmp(finalized, filename, strlen(finalized)) == 0){ // finished song
		type = 1;
	}

	rename_loop(actor, type);
	return FALSE;
}

//Short click: play
static void name_clicked(ClutterActor* actor) {

	const char* filename = clutter_actor_get_name(actor);
	char* projects = configure_get_projects_directory();
	char* finalized = configure_get_finalized_directory();
	int type = -1;

	if(strncmp(filename, projects, strlen(projects)) == 0){ // project
		type = 0;
	}else if(strncmp(finalized, filename, strlen(finalized)) == 0){ // finished song
		type = 1;
	}

	if(renaming_loop){
		rename_loop(actor, type);
	}else{

		if(type == 0){
			start_sequencer_with_this_file(actor, NULL);
		}else if(type == 1){
			play_selected_loop(actor);
		}else{
			printf("Invalid loop name\n");
		}
	}
}


gboolean song_name_press_action (ClutterActor* actor, ClutterButtonEvent *event) {
	guint holding_event_source_id = g_timeout_add(DURATION_OF_LONG_CLICK, tap_and_hold_function, actor);
	g_object_set_data(G_OBJECT(actor),"handler_for_longclick",GUINT_TO_POINTER(holding_event_source_id));

	return TRUE;
}


gboolean song_name_release_action (ClutterActor* actor, ClutterButtonEvent *event) {
	guint holding_event_source_id= GPOINTER_TO_UINT(g_object_get_data(G_OBJECT(actor),"handler_for_longclick"));

	if (holding_event_source_id) {
		g_source_remove(holding_event_source_id);
		g_object_set_data(G_OBJECT(actor),"handler_for_longclick",GUINT_TO_POINTER(0));

		//If tap_and_hold_function is triggered, we do not want call this:
		name_clicked(actor);
	}
	return TRUE;
}



void rename_loop(ClutterActor *loopName, int type){

	static gboolean firstCall = TRUE;

	ClutterActor *text = tangle_button_get_normal_background_actor(TANGLE_BUTTON(loopName));
	const char* givenname = clutter_text_get_text(CLUTTER_TEXT(text));
	const char* filename = clutter_actor_get_name(loopName);
	gchar * newpath = NULL;
	int i = 0, j = 0, type_length = 0, path_length = 0;
	int length = strlen(filename);
	char temp[length];
	char oldpath[length];

	strcpy(temp, filename);

	if(type == 0){ //projects
		path_length = strlen(configure_get_projects_directory());
		type_length = 5; //.json
	}else if(type == 1 || type == 3){ //songs
		path_length = strlen(configure_get_finalized_directory());
		type_length = 4; //.ogg
	}
		
	for(i = path_length + 1; i < length-type_length; i++){
		oldpath[j] = temp[i];
		j++;
	}
	oldpath[j] = 0;

	gchar * path = NULL;

	path = g_strdup_printf("%s/label_%d_%s.csv", configure_get_jammo_directory(), 
			gems_profile_manager_get_userid(NULL), oldpath);

	printf("Path: %s\n", path);
	printf("Filename is:%s\n", filename);

	if(firstCall == TRUE){
		firstCall = FALSE;
		renaming_loop = TRUE;
		printf("Renaming text...\n");

		clutter_text_set_editable (CLUTTER_TEXT(text), TRUE);
		clutter_actor_set_reactive(text, TRUE);
		clutter_actor_grab_key_focus(text);
	}else{
		firstCall = TRUE;
		printf("Done.\n");

		clutter_text_set_editable (CLUTTER_TEXT(text), FALSE);
		clutter_actor_set_reactive(text, FALSE);
	
		if(type == 0){

			char *projects = configure_get_projects_directory();	
			char new_projects_name[180] = ""; 

			strcat(new_projects_name, projects);
			strcat(new_projects_name, "/");
			strcat(new_projects_name, givenname);
			strcat(new_projects_name, ".json");
			printf("Newname: %s.\n", new_projects_name);

			if(file_exist(path)){ //labelfile exists
				newpath = g_strdup_printf("%s/label_%d_%s.csv", configure_get_jammo_directory(), 
							gems_profile_manager_get_userid(NULL), givenname);
				printf("Newpath: %s\n", newpath);
				rename(path, newpath);
			}
			rename(filename, new_projects_name);
			clutter_actor_set_name(loopName, new_projects_name);

		}else if(type == 1){

			char *finalized = configure_get_finalized_directory();	
			char newname[180] = ""; 

			strcat(newname, finalized);
			strcat(newname, "/");
			strcat(newname, givenname);
			strcat(newname, ".ogg");
			printf("Newname: %s.\n", newname);

			if(file_exist(path)){ //labelfile exists
				newpath = g_strdup_printf("%s/label_%d_%s.csv", configure_get_jammo_directory(), 
							gems_profile_manager_get_userid(NULL), givenname);
				printf("Newpath: %s\n", newpath);
				rename(path, newpath);
			}
			rename(filename, newname);
			clutter_actor_set_name(loopName, newname);
		}
		renaming_loop = FALSE;
	}
	g_free(path);
	g_free(newpath);
}

void play_selected_loop(ClutterActor *actor){
	
	//TODO: add correct loop, this one is just to test the button
	static JammoSample *sample = NULL;
	const char *filename = clutter_actor_get_name(actor);

	if(sample == NULL){
		//songName = "/home/teppo/jammo10-jammo-data/data/jammo7-12_all/backingtracks/Sa_LaBamba_110_A.ogg";
		puts("Starting loop");

		if(actor == NULL){
			sample = jammo_sample_new_from_file("/home/teppo/jammo10-jammo-data/data/jammo7-12_all/backingtracks/Sa_LaBamba_110_A.ogg");
		}else{
			printf("Now playing: %s\n", filename);
			sample = jammo_sample_new_from_file(filename);
		}
		jammo_sample_play(sample);
	}else{
		puts("loop stop");
		jammo_sample_stop(sample);
		g_object_unref(sample);
		sample = NULL;
	}
}


void show_song_label(show_label_params *params){

	puts("Starting record label view.");

	FILE *file;
	gchar data[200];	
	gchar *recordName;
	gchar *composer;
	gchar *image;
	if((file = fopen(params->path, "r")) != 0){
	
		if(fread(data, sizeof(gchar), 200, file) != 0){
		
			recordName = strtok(data, ",");
			composer = strtok(NULL, ",");
			image = strtok(NULL, ",");
				
			if(strcmp(recordName, "0") != 0 || strcmp(composer, "0") != 0 || strcmp(image, "0") != 0){
				 
				if(strcmp(params->parentview, "jammosongs") == 0) 				 
					tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("jammosongs-view")));
					
				if(strcmp(params->parentview, "mysongs") == 0) 				 
					tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("mysongs-view")));
					
				clutter_actor_show(jammo_get_actor_by_id("record-label-viewer"));
				
				g_signal_connect_swapped(jammo_get_actor_by_id("record-label-back-button"), "clicked", G_CALLBACK(hide_song_label), params->parentview);
								
				if(strcmp(recordName, "0") != 0)
					clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("record-label-name")), recordName);
				else clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("record-label-name")), "");
					
				if(strcmp(composer, "0") != 0)
					clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("record-label-composer")), composer);
				else clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("record-label-composer")), "");
				
				if(strcmp(image, "0") != 0){
				
					tangle_texture_set_from_file(TANGLE_TEXTURE(jammo_get_actor_by_id("record-label-image")), image);
					clutter_actor_show(jammo_get_actor_by_id("record-label-image"));
					
				}else clutter_actor_hide(jammo_get_actor_by_id("record-label-image"));
				
			
			}
			
		}
		fclose(file);
	}
		
}

void hide_song_label(gchar* parentview){
	
	tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("record-label-viewer")));
	
	if(strcmp(parentview, "jammosongs") == 0) 				 
		clutter_actor_show(jammo_get_actor_by_id("jammosongs-view"));	
		
	if(strcmp(parentview, "mysongs") == 0) 				 
		clutter_actor_show(jammo_get_actor_by_id("mysongs-view"));			
		
}

/*
 * Function for getting current time.
 */
time_type get_current_time(){

	time_t now;
	time_type current_time;
	struct tm *ts;
	gchar temp[80];

	//to get current time and date
	now = time(NULL);

	//to format the time, "dd.mm.yy hh:mm"
	ts = localtime(&now);
	strftime(temp, 18, "%d.%m.%Y %H:%M", ts);
	strcpy(current_time.time, temp);

	return current_time;
}

/*
 * Function for checking whether file exists.
 */
gboolean file_exist(gchar *filename) 
{
  	struct stat buffer;

  	if(stat(filename, &buffer) == 0){
    		return TRUE;
  	}else{
		printf("Cannot find file: %s\n", filename);
    		return FALSE;
  	}
}


/*
* Function clears container that may contain other containers.
*
* parameters:
* -listToClear is the container to be cleared
*
*/
void clear_container(ClutterContainer *listToClear){
	
	int i = 0;
	GList *listItems;
	
	if(listToClear != NULL){
	 	
		listItems = clutter_container_get_children(listToClear); 
		
		if(listItems != NULL){
		
			do{			
				if(i > 0)
					listItems = listItems->next;
								
				clutter_container_remove_actor(CLUTTER_CONTAINER(listToClear), CLUTTER_ACTOR(listItems->data));
				i++;
	
			}while(listItems->next != NULL);
		
		g_list_free(listItems);

		}

	}
	

	listToClear = 0;	

}

/*
* Function creates buttons from each .png type file in the directory.
* 
* parameters:
* -path is the path of the directory
* -list is a container where the buttons are added
* -funtion is a pointer to a function which handles button press events
* -width is the width of the button
* -height is the height of the button
*
*/

gboolean add_images_from_directory(const char* path, ClutterContainer *list, GCallback function, int width, int height){
		
	ClutterActor *button = 0;
	char tempPath[150];
	char result[MAX_FILES_IN_DIR][MAX_FILE_NAME_LEN];
	int numberOfImages;
	
	numberOfImages = community_open_and_arrange_dir(path, ".png", result);	
	
	for(int i = 0; i < numberOfImages; i++){
		strcpy(tempPath, path);
		strcat(tempPath, result[i]);
		add_single_button(button, list, tempPath, width, height, function);
	
	}
	
  	return TRUE;

}	

/*
* Function creates and adds a single button into container.
*
*parameters:
* -button is null pointer to a button to be created
* -list is a container where button is added
* -path is a path to image of the button
* -width is the width of the button
* -height is the height of the button
* -funtion is a pointer to a function which handles button press events
*
*/

gboolean add_single_button(ClutterActor *button, ClutterContainer *list, char* path, int width,int height, GCallback function){

	button = tangle_button_new_with_background_actor(tangle_texture_new(path));
	clutter_actor_set_name(button, path);
	clutter_container_add_actor(list, button);
	clutter_actor_set_size(button, height, width);
	g_signal_connect_swapped(button, "clicked", G_CALLBACK(function), button);

	return TRUE;
}


/*
* A callback funtion that limits the line count of editable textfield.
*
*parameters:
*-pointer to a textfield structure
*
*/
void limit_line_count(TextField *text){

	gchar *textField = malloc((text->max_characters+1) * sizeof(gchar));
	PangoLayout *layout;
	int index;
	
	strncpy(textField, clutter_text_get_text(CLUTTER_TEXT(text->text)), text->max_characters);
	textField[text->max_characters+1] = 0;

	layout = clutter_text_get_layout(CLUTTER_TEXT(text->text));

	while(pango_layout_get_line_count(layout) > text->lineCount){
			index = clutter_text_get_cursor_position(CLUTTER_TEXT(text->text));

			if(index == -1){
				textField[strlen(textField)-1] = 0;
			}else{
				textField[index] = 0;
				strcat(textField, textField+index+1);
				
				clutter_text_set_cursor_position(CLUTTER_TEXT(text->text), index == 0 ? 0 : index-1);
			}
			
			g_signal_handler_disconnect(text->text, text->handler_id);
			clutter_text_set_text(CLUTTER_TEXT(text->text), textField); 
			text->handler_id = g_signal_connect_swapped(text->text, "text-changed", (GCallback)limit_line_count, text);
			layout = clutter_text_get_layout(CLUTTER_TEXT(text->text));
	}
	
	g_free(textField);
		
}



/*
* Frees dynamically allocated memory from GList that contains pointers to message structures.
*/

void clear_messagelist(GList* messages){

	messages = g_list_first(messages);

	message *temp = 0;

	if(messages != NULL){
		
		temp = messages->data;

		if(temp->msg != NULL)
			free(temp->msg);
			
		if(temp->filepath != NULL)
			free(temp->filepath);

		if(messages->data != NULL)
			free(messages->data);
	
		while(messages->next != NULL)
		{
			messages = messages->next;
				
			temp = messages->data;

			if(temp->msg != NULL)
				free(temp->msg);				
			
			if(temp->filepath != NULL)
				free(temp->filepath);				
				
			if(messages->data != NULL)
				free(messages->data);				
		}
	
	}



}

/*
* Computes the avatar from guint32 type number.
*
*paramters:
* -avatar is pointer to a Avatar struct, where the avatar will be created.
* -avatar_id tells the avatar type.
*/

gboolean community_get_avatar(Avatar* avatar, guint32 avatar_id){

	int head, hair_color, hair_type, body, instrument;
	char path[150];
	char result[MAX_FILES_IN_DIR][MAX_FILE_NAME_LEN];
	
	head = (avatar_id & 0xF);
	hair_color = (avatar_id & 0xF0) >> 4;
	body = (avatar_id & 0xFF00) >> 8;
	hair_type = (avatar_id & 0xFF0000) >> 16;
	instrument = (avatar_id & 0xFF000000) >> 24;

	if(head != 0){
	
		strcpy(path, "/opt/jammo/communitymenu/AVATAR_PARTS/heads/");
		
		community_open_and_arrange_dir(path, ".png", result);
		avatar->head = tangle_texture_new(strcat(path, result[head-1]));	
		clutter_actor_set_name(avatar->head, path);
	
	}

	if(body != 0){
	
		strcpy(path, "/opt/jammo/communitymenu/AVATAR_PARTS/bodys/");
		
		community_open_and_arrange_dir(path, ".png", result);
		avatar->body = tangle_texture_new(strcat(path, result[body-1]));	
		clutter_actor_set_name(avatar->body, path);
	
	}
	
	if(hair_color != 0 && hair_type != 0){
	
		strcpy(path, "/opt/jammo/communitymenu/AVATAR_PARTS/hairs/");

		community_open_and_arrange_dir(path, "DIR", result);
		
		strcat(path, result[hair_color-1]);
		strcat(path, "/");
		
		community_open_and_arrange_dir(path, ".png", result);
		
		strcat(path, result[hair_type-1]);
		
		avatar->hair = tangle_texture_new(path);
		clutter_actor_set_name(avatar->hair, path);
		
	
	}	
	
	if(instrument != 0){
	
		strcpy(path, "/opt/jammo/communitymenu/INSTRUMENTS/");
		community_open_and_arrange_dir(path, ".png", result);
		avatar->instrument = tangle_texture_new(strcat(path, result[instrument-1]));
		clutter_actor_set_name(avatar->instrument, path);
	
	
	}

	return TRUE;

}

/*
* Computes and saves guint32 type number from user avatar
*
*paramters:
* -avatar is pointer to a Avatar struct, which contains user avatar
*/

gboolean community_save_avatar(Avatar* avatar){

	guint32 head = 0, hair_color = 0, hair_type = 0, body = 0, instrument = 0;
	char path[150];
	char result[MAX_FILES_IN_DIR][MAX_FILE_NAME_LEN];
	int i;
	int numberOfImages = 0;
	
	if(avatar->head != 0){
	
		strcpy(path, "/opt/jammo/communitymenu/AVATAR_PARTS/heads/");

		numberOfImages = community_open_and_arrange_dir(path, ".png", result);
		
		for(i = 0; i < numberOfImages; i++)
			if(strstr(clutter_actor_get_name(avatar->head), result[i]) != 0)
				break;	
				
		head = i+1;		
	}
	
	if(avatar->body != 0){
	
		strcpy(path, "/opt/jammo/communitymenu/AVATAR_PARTS/bodys/");	
	
		numberOfImages = community_open_and_arrange_dir(path, ".png", result);
		
		for(i = 0; i < numberOfImages; i++)
			if(strstr(clutter_actor_get_name(avatar->body), result[i]) != 0)
				break;	
				
		body = i+1;		
	
	}	
	
	if(avatar->hair != 0){
	
		strcpy(path, "/opt/jammo/communitymenu/AVATAR_PARTS/hairs/");
		
		numberOfImages = community_open_and_arrange_dir(path, "DIR", result);
		
		for(i = 0; i < numberOfImages; i++)
			if(strstr(clutter_actor_get_name(avatar->hair), result[i]) != 0)
				break;	
				
		hair_color = i+1;		
					
		strcpy(path, clutter_actor_get_name(avatar->hair));
		
		char *temp = strrchr(path, '/');
		temp++;
		*temp = 0;
		numberOfImages = community_open_and_arrange_dir(path, ".png", result);
		
		for(i = 0; i < numberOfImages; i++)
			if(strstr(clutter_actor_get_name(avatar->hair), result[i]) != 0)
				break;	
				
		hair_type = i+1;		
	}		
	
	if(avatar->instrument != 0){
		
		strcpy(path, "/opt/jammo/communitymenu/INSTRUMENTS/");
		
		numberOfImages = community_open_and_arrange_dir(path, ".png", result);
		
		for(i = 0; i < numberOfImages; i++)
			if(strstr(clutter_actor_get_name(avatar->instrument), result[i]) != 0)
				break;	
				
		instrument = i+1;
	
	}

	
	guint32 id = 0;
	
	id = head;
	id += (hair_color << 4);
	id += (body << 8);
	id += (hair_type << 16);
	id += (instrument << 24);
	
	return gems_profile_manager_set_avatar_id(id);

}


/*
* This function opens directory, and sorts files in alphabetical order.
* Files must be sorted because file order from opendir() may be different in each device.
*
*parameters: 
* -path is full path of directory to be opened
* -suffix defines which type files will be sorted, other files are ignored
*   (if suffix is "DIR", only directories are listed)
* -result is an array of strings that contains filenames in order when this funtion returns
*
* returns number of files found
*/

int community_open_and_arrange_dir(const char* path, char* suffix, char result[MAX_FILES_IN_DIR][MAX_FILE_NAME_LEN]){
	
	DIR *dir;
	struct dirent *dir_ent;
	int numberOfFiles = 0;
	dir = opendir(path);

	if(dir != NULL){
	
		if(strcmp(suffix, "DIR") == 0){
		
			for(numberOfFiles = 0; (dir_ent = readdir(dir)) != 0; numberOfFiles++){
			
				if(strstr(dir_ent->d_name, ".") != 0 || strstr(dir_ent->d_name, "..") != 0)
					numberOfFiles--;

			
				else strcpy(result[numberOfFiles], dir_ent->d_name);

			}
		
		}else{
	
			for(numberOfFiles = 0; (dir_ent = readdir(dir)) != 0; numberOfFiles++){
			
				if(strstr(dir_ent->d_name, suffix) == 0)
					numberOfFiles--;

			
				else	strcpy(result[numberOfFiles], dir_ent->d_name);	

			}
		}
	
		qsort(result, numberOfFiles, MAX_FILE_NAME_LEN, (void*)strcoll);
	
		
		closedir(dir);
		
	}

	return numberOfFiles;

}

/*
* Transforms avatar into smaller scale, so it can be used in thread-views.
*
*parameters:
* -avatar is the avatar to be scaled
* -avatarBackground is container, where avatar will be set
*/

void community_shrink_and_set_avatar(Avatar* avatar, ClutterContainer *avatarBackground){

	gfloat width, height;
	
	if(avatar->body != 0){
		clutter_actor_get_size(avatar->body, &width, &height);
		clutter_actor_set_size(avatar->body, width*0.3, height*0.3);
		clutter_actor_set_position(avatar->body, 7, 35);
	}

	if(avatar->head != 0){
		clutter_actor_get_size(avatar->head, &width, &height);
		clutter_actor_set_size(avatar->head, width*0.3, height*0.3);
		clutter_actor_set_position(avatar->head, 14, 10);
	}
	
	if(avatar->hair != 0){
	
		clutter_actor_get_size(avatar->hair, &width, &height);
		clutter_actor_set_size(avatar->hair, width*0.3, height*0.3);
		clutter_actor_set_position(avatar->hair, 14, 10);
	
		//hard codin' man is back...
	
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_bush.png"))
			clutter_actor_set_position(avatar->hair, 12, 5);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_centerspread.png"))
			clutter_actor_set_position(avatar->hair, 7, 6);		
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_centerspread2.png"))
			clutter_actor_set_position(avatar->hair, 11, 5);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_centerspread3.png"))
			clutter_actor_set_position(avatar->hair, 12, 5);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_centerspread4.png"))
			clutter_actor_set_position(avatar->hair, 13, 6);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_centerspread5.png"))
			clutter_actor_set_position(avatar->hair, 14, 6);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_emo.png"))
			clutter_actor_set_position(avatar->hair, 14, 6);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_long.png"))
			clutter_actor_set_position(avatar->hair, 11, 5);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_longcurly.png"))
			clutter_actor_set_position(avatar->hair, 10, 6);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_longcurly2.png"))
			clutter_actor_set_position(avatar->hair, 11, 6);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_mohawk.png"))
			clutter_actor_set_position(avatar->hair, 18, 2);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_ponytails.png"))
			clutter_actor_set_position(avatar->hair, 9, 6);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_punk.png"))
			clutter_actor_set_position(avatar->hair, 10, 4);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_punk2.png"))	
			clutter_actor_set_position(avatar->hair, 1, -3);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_top.png"))	
			clutter_actor_set_position(avatar->hair, 15, 8);		
	
	
	}
	
	if(avatar->head != 0)
		clutter_container_add_actor(avatarBackground, avatar->head);	
	
	if(avatar->body != 0)
		clutter_container_add_actor(avatarBackground,avatar->body);
	
	if(avatar->hair != 0)
		clutter_container_add_actor(avatarBackground, avatar->hair);	

}

/*
* Funtion frees GList that contains pointers to dynamically allocated profile_view_params structures
*/


void community_clear_paramslist(GList* paramsList){

	paramsList = g_list_first(paramsList);
	
	if(paramsList != NULL){
	
		if(paramsList->data != 0)
		   free(paramsList->data);
		   
		while(paramsList->next != 0){
			paramsList = paramsList->next;
			
			if(paramsList->data != 0)
				free(paramsList->data);
		
		}   
	}
	
	g_list_free(paramsList);

}

/*
* Funtion frees GList that contains pointers to dynamically allocated show_label_params structures
*/


void community_clear_labelparamslist(GList* paramslist){

	paramslist = g_list_first(paramslist);
	
	if(paramslist != NULL){
	
		g_free(((show_label_params*)paramslist->data)->path);
		g_free(paramslist->data);   
		   
		while(paramslist->next != 0){
			paramslist = paramslist->next;
			g_free(((show_label_params*)paramslist->data)->path);
			g_free(paramslist->data);
		}   
	}
	
	g_list_free(paramslist);

}


void community_autoscroll_to_correct_pos(list_type *list)
{
	gint slot;
	gfloat not_used, offset;

	ClutterAction *action = tangle_actor_get_action_by_type(CLUTTER_ACTOR(list->list), TANGLE_TYPE_SCROLL_ACTION);
	
	tangle_scroll_action_get_offsets(TANGLE_SCROLL_ACTION(action), &not_used, &offset);

	slot = (gint)offset % list->listItemHeight < list->listItemHeight / 2 ? (gint)(offset) / list->listItemHeight  
							  		: (gint)(offset) / list->listItemHeight + 1;

	tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_OUT_QUAD, 300, "offset-y", (gfloat)(slot*list->listItemHeight), NULL);
}
