#include "avatar_editor.h"
#include "startmenu.h"
#include "../jammo.h"
#include "communitymenu.h"
#include "community_utilities.h"
#include "string.h"


static void end_avatar_view();

ClutterContainer *partsList;
ClutterContainer *avatarImage = 0;
typedef enum{BLACK, BLOND, BLUE, BROWN, DARKBROWN, GRAY, ORANGE, VIOLET, WHITE}HAIR_COLOR;
typedef enum{BROWN_HEAD, DARK_HEAD, PINK_HEAD, YELLOW_HEAD}HEADS;
const int NUMBEROFCOLORS = 9;
const int NUMBEROFHEADS = 4;
HAIR_COLOR hairColor;
HEADS heads = YELLOW_HEAD;
char currentHairType[50];
gboolean hairsInList = FALSE;
ClutterActor *instrumentBackground = 0;
Avatar avatar = {0,0,0,0};
TextField hobbiesTextField;
TextField nameTextField;
TextField genderTextField;

static void change_hair_type() ;
void start_avatar_editor(){

	//Creating default user to test avatar saving!

	static int start = 1; // For testing only!!!
	
	if(start){// For testing only!!!
		gems_profile_manager_create_default_user_profile("sala", 23);// For testing only!!!
		gems_profile_manager_authenticate_default_user("sala");// For testing only!!!
		start = 0;// // For testing only!!!
		}
		
		

	guint32 avatar_id = 0;

	printf("Starting avatar editor\n");

	ClutterActor* mainview;
	
	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* avatarView = jammo_get_actor_by_id("avatar-view");
	
	if(avatarView){
		
		clutter_actor_show(CLUTTER_ACTOR(avatarView)); 
		
		partsList = CLUTTER_CONTAINER(jammo_get_actor_by_id("avatar-parts-list"));

		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("avatar_hobbies_text")), _("HOBBIES:"));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("avatar_name_text")), _("NAME:"));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("avatar_gender_text")), _("GENDER:"));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("avatar_instrument_text")), _("FAVOURITE INSTRUMENT:"));
		
		
		
		hobbiesTextField.text = jammo_get_actor_by_id("avatar_hobbies_textfield");
		clutter_text_set_text(CLUTTER_TEXT(hobbiesTextField.text), _("<<YOUR HOBBIES HERE>>"));
		hobbiesTextField.lineCount = 2;
		hobbiesTextField.max_characters = 500;
		hobbiesTextField.handler_id = g_signal_connect_swapped(hobbiesTextField.text, "text-changed", (GCallback)limit_line_count, &hobbiesTextField);
 
		
		nameTextField.text = jammo_get_actor_by_id("avatar_name_textfield");
		clutter_text_set_text(CLUTTER_TEXT(nameTextField.text), _("<<YOUR NAME HERE>>"));
		nameTextField.lineCount = 1;
		nameTextField.max_characters = 500;
		nameTextField.handler_id = g_signal_connect_swapped(nameTextField.text, "text-changed", (GCallback)limit_line_count, &nameTextField);		
		
		genderTextField.text = jammo_get_actor_by_id("avatar_gender_textfield");
		clutter_text_set_text(CLUTTER_TEXT(genderTextField.text), _("<<YOUR GENDER HERE>>"));
		genderTextField.lineCount = 1;
		genderTextField.max_characters = 500;
		genderTextField.handler_id = g_signal_connect_swapped(genderTextField.text, "text-changed", (GCallback)limit_line_count, &genderTextField);					
	
		avatar_id = gems_profile_manager_get_avatar_id(NULL);
	
		if(avatar_id != 0){
			community_get_avatar(&avatar, avatar_id);
			if(avatar.hair != 0){
				char *temp = strstr(clutter_actor_get_name(avatar.hair), "hairs/");
				temp = strpbrk(temp, "/");
				temp++;
				temp = strpbrk(temp, "/");
				temp++;
				strcpy(currentHairType, temp);
			}
		}
	
		set_avatar(&avatar, CLUTTER_ACTOR(avatarImage), CLUTTER_ACTOR(instrumentBackground), "avatar-widgets");
	
	}


}


void set_avatar(Avatar *avatar, ClutterActor *avatarImage, ClutterActor *instrumentBackground, char *widget){



	if(instrumentBackground == 0){

	}

	if(avatar->body == 0){
		avatar->body = tangle_texture_new("/opt/jammo/communitymenu/AVATAR_PARTS/bodys/body_blue.png");
		clutter_actor_set_name(avatar->body, "body_blue.png");
	}
	if(avatar->head == 0){
		avatar->head = tangle_texture_new("/opt/jammo/communitymenu/AVATAR_PARTS/heads/head_yellow.png");
	clutter_actor_set_name(avatar->head, "head_yellow.png");
	}

	if(avatarImage == 0){
		avatarImage = (jammo_get_actor_by_id(widget)); 

	}
	
	
	clutter_container_add_actor(CLUTTER_CONTAINER(avatarImage), avatar->head);
	clutter_actor_set_position(avatar->head, 92, 85);
	
	clutter_container_add_actor(CLUTTER_CONTAINER(avatarImage), avatar->body);
	clutter_actor_set_position(avatar->body, 65, 170);
	
	if(avatar->instrument != 0){

		if(instrumentBackground == 0){
			instrumentBackground = tangle_texture_new("/opt/jammo/communitymenu/community_avatar_avatarbackground.png");
			clutter_actor_set_size(instrumentBackground, 110, 110);
			clutter_container_add_actor(CLUTTER_CONTAINER(avatarImage), instrumentBackground);
		}		
		
		if(strcmp(widget, "user-profile-widgets") == 0){
			clutter_actor_set_position(instrumentBackground, 503, 260);
			clutter_actor_set_position(avatar->instrument, 510, 267);
		}else{
			clutter_actor_set_position(instrumentBackground, 503, 238);
			clutter_actor_set_position(avatar->instrument, 510, 245);
		}
		
		clutter_container_add_actor(CLUTTER_CONTAINER(avatarImage), avatar->instrument);
		clutter_actor_raise(avatar->instrument, instrumentBackground);
	}
	
	
	if(avatar->hair != 0){
	
		clutter_container_add_actor(CLUTTER_CONTAINER(avatarImage), avatar->hair);

		//this must be done since each hair image requires own coordinates
		
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_bush.png"))
			clutter_actor_set_position(avatar->hair, 85, 70);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_centerspread.png"))
			clutter_actor_set_position(avatar->hair, 70, 80);		
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_centerspread2.png"))
			clutter_actor_set_position(avatar->hair, 80, 70);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_centerspread3.png"))
			clutter_actor_set_position(avatar->hair, 83, 72);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_centerspread4.png"))
			clutter_actor_set_position(avatar->hair, 90, 79);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_centerspread5.png"))
			clutter_actor_set_position(avatar->hair, 92, 81);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_emo.png"))
			clutter_actor_set_position(avatar->hair, 89, 78);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_long.png"))
			clutter_actor_set_position(avatar->hair, 80, 69);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_longcurly.png"))
			clutter_actor_set_position(avatar->hair, 78, 73);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_longcurly2.png"))
			clutter_actor_set_position(avatar->hair, 80, 72);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_mohawk.png"))
			clutter_actor_set_position(avatar->hair, 106, 60);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_ponytails.png"))
			clutter_actor_set_position(avatar->hair, 75, 75);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_punk.png"))
			clutter_actor_set_position(avatar->hair, 80, 64);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_punk2.png"))	
			clutter_actor_set_position(avatar->hair, 50, 35);
		if(strstr(clutter_actor_get_name(avatar->hair), "hair_top.png"))	
			clutter_actor_set_position(avatar->hair, 100, 80);
		
	}
	
	clutter_actor_raise(avatar->body, avatar->head);
	if(avatar->hair != 0)
		clutter_actor_raise(avatar->hair, avatar->head);

}

static void pressed(ClutterActor *actor){

	char *temp;

	if(strstr(clutter_actor_get_name(actor), "/opt/jammo/communitymenu/AVATAR_PARTS/bodys")){
		hairsInList = FALSE;
		DESTROY_ACTOR(avatar.body);
		avatar.body = tangle_texture_new(clutter_actor_get_name(actor));
		clutter_actor_set_name(avatar.body, clutter_actor_get_name(actor));
		
		}
		
	if(strstr(clutter_actor_get_name(actor), "/opt/jammo/communitymenu/AVATAR_PARTS/hairs")){
	
		DESTROY_ACTOR(avatar.hair);
			
		avatar.hair = tangle_texture_new(clutter_actor_get_name(actor));
		temp = strstr(clutter_actor_get_name(actor), "hairs/");
		temp = strpbrk(temp, "/");
		temp++;
		temp = strpbrk(temp, "/");
		temp++;
		strcpy(currentHairType, temp);
		clutter_actor_set_name(avatar.hair, clutter_actor_get_name(actor));
		}	

	if(strstr(clutter_actor_get_name(actor), "/opt/jammo/communitymenu/INSTRUMENTS")){
	
		hairsInList = FALSE;
	
		DESTROY_ACTOR(avatar.instrument);
		avatar.instrument = tangle_texture_new(clutter_actor_get_name(actor));
		clutter_actor_set_name(avatar.instrument, clutter_actor_get_name(actor));

		}

	set_avatar(&avatar, CLUTTER_ACTOR(avatarImage), CLUTTER_ACTOR(instrumentBackground), "avatar-widgets");

}

gboolean change_body_color_clicked(TangleActor *actor, gpointer data){

	puts("changing body color");
	
	clear_container(partsList);
	
	const char path[100] = "/opt/jammo/communitymenu/AVATAR_PARTS/bodys/";
	
	
	if(!add_images_from_directory(path, partsList, (GCallback)pressed, 100, 100)){
		puts("can't open directory containing avatar parts");
		
	}

	return TRUE;
}

gboolean change_hair_color_clicked(TangleActor *actor, gpointer data){

	char path[150] = "/opt/jammo/communitymenu/AVATAR_PARTS/hairs/";
	
	puts("changing hair color");
	

	hairColor = (hairColor+1) % NUMBEROFCOLORS;
	
	strcat(path, hairColor == BLACK ? "black/" :
			     hairColor == BLOND ? "blond/" :
			     hairColor == BLUE ? "blue/" :
			     hairColor == BROWN ? "brown/" :
			     hairColor == DARKBROWN ? "darkbrown/" :
			     hairColor == GRAY ? "gray/" :
			     hairColor == ORANGE ? "orange/" :
			     hairColor == VIOLET ? "violet/" :
			     hairColor == WHITE ? "white/" : "");
				     
	if(avatar.hair != 0){	
		strcat(path, currentHairType);	     
	
		DESTROY_ACTOR(avatar.hair);	
		avatar.hair = tangle_texture_new(path);puts(path);	
		clutter_actor_set_name(avatar.hair, path);	
		set_avatar(&avatar, CLUTTER_ACTOR(avatarImage), CLUTTER_ACTOR(instrumentBackground), "avatar-widgets");

	}
		
	if(hairsInList)
		change_hair_type();

	return TRUE;
}

gboolean change_hair_type_clicked(TangleActor *actor, gpointer data){
	change_hair_type();
	return TRUE;
}

static void change_hair_type() {
	puts("changing hair type");
	
	hairsInList = TRUE;

	clear_container(partsList);
	
	char path[100];
	
	if(hairColor == BLACK) strcpy(path, "/opt/jammo/communitymenu/AVATAR_PARTS/hairs/black/");
	if(hairColor == BLOND) strcpy(path, "/opt/jammo/communitymenu/AVATAR_PARTS/hairs/blond/");
	if(hairColor == BLUE) strcpy(path,"/opt/jammo/communitymenu/AVATAR_PARTS/hairs/blue/");
	if(hairColor == BROWN) strcpy(path, "/opt/jammo/communitymenu/AVATAR_PARTS/hairs/brown/");
	if(hairColor == DARKBROWN) strcpy(path, "/opt/jammo/communitymenu/AVATAR_PARTS/hairs/darkbrown/");
	if(hairColor == GRAY) strcpy(path,"/opt/jammo/communitymenu/AVATAR_PARTS/hairs/gray/");
	if(hairColor == ORANGE) strcpy(path, "/opt/jammo/communitymenu/AVATAR_PARTS/hairs/orange/");
	if(hairColor == VIOLET) strcpy(path,"/opt/jammo/communitymenu/AVATAR_PARTS/hairs/violet/");
	if(hairColor == WHITE) strcpy(path,"/opt/jammo/communitymenu/AVATAR_PARTS/hairs/white/");

		
	if(!add_images_from_directory(path, partsList, (GCallback)pressed, 100, 100))
		puts("can't open directory containing avatar parts");
}

gboolean change_head_clicked(TangleActor *actor, gpointer data){

	char path[150] = "/opt/jammo/communitymenu/AVATAR_PARTS/heads/";
	
	hairsInList = FALSE;

	puts("changing head");
	
	clear_container(partsList);
	
	heads = (heads+1)%NUMBEROFHEADS;	

	strcat(path, heads == BROWN_HEAD ? "head_brown.png" :
		     heads == DARK_HEAD ? "head_dark.png" :
		     heads == PINK_HEAD ? "head_pink.png" :
		     heads == YELLOW_HEAD ? "head_yellow.png" : "");
		     
	DESTROY_ACTOR(avatar.head);
	avatar.head = tangle_texture_new(path);
	clutter_actor_set_name(avatar.head, path);
		     
	set_avatar(&avatar, CLUTTER_ACTOR(avatarImage), CLUTTER_ACTOR(instrumentBackground), "avatar-widgets");

	return TRUE;
}


gboolean change_instrument_clicked(TangleActor *actor, gpointer data){

	puts("changing instrument");
	
	clear_container(partsList);

	if(!add_images_from_directory("/opt/jammo/communitymenu/INSTRUMENTS/", partsList, (GCallback)pressed, 100, 100))
		puts("can't open directory containing instruments");

	return TRUE;
}


//For cleanupping
static void end_avatar_view() {
	
	community_save_avatar(&avatar);
	
	clear_container(partsList);
	
	DESTROY_ACTOR(avatar.body);
	DESTROY_ACTOR(avatar.hair);
	DESTROY_ACTOR(avatar.head);
	DESTROY_ACTOR(avatar.instrument);
	DESTROY_ACTOR(instrumentBackground);
	
	partsList = 0;
	avatarImage = 0;	
	
	
}

gboolean avatar_goto_communitymenu(TangleButton *tanglebutton, gpointer none)
{
	end_avatar_view();
	start_communitymenu();
	return TRUE;
}

gboolean avatar_goto_startmenu(TangleButton *tanglebutton, gpointer none)
{
	end_avatar_view();
	startmenu_goto_startmenu(tanglebutton, none);
	return TRUE;
}
