/**sequencer.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is the sequencer.
 */
#include <tangle.h>
#include <glib-object.h>
#include "startmenu.h"
#include "../jammo.h"
#include "../jammo-game-level.h"
#include "sequencer.h"
#include "gamesmenu.h"
#include "communitymenu.h"

#include "../../cem/cem.h"
#include "../../configure.h"
#include <libintl.h> //For gettext

void startmenu_goto_sequencer (TangleButton* tanglebutton, gpointer none){
	start_gamesmenu(); //When level starts, it suppose that gamesmenu is also visible
	gamesmenu_start_first_task_on_this_level("level2"); //TODO: level1000-view (last-level)
}

void startmenu_goto_gamesmenu (TangleButton* tanglebutton, gpointer none){
	cem_add_to_log("From startmenu to gamesmenu clicked",J_LOG_USER_ACTION);
	start_gamesmenu();
}

void startmenu_goto_communitymenu(TangleButton* tanglebutton, gpointer none){
	cem_add_to_log("From startmenu to communitymenu clicked",J_LOG_USER_ACTION);
	start_communitymenu();

}

void startmenu_mentor_clicked(TangleButton* tanglebutton, gpointer none){
	cem_add_to_log("On startmenu mentor clicked",J_LOG_USER_ACTION);
}

void startmenu_draw_version_information(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	//Show version number: defined in configure.ac
	ClutterActor* version_label =  jammo_get_actor_by_id( "startmenu-version-info");
	clutter_text_set_font_name (CLUTTER_TEXT(version_label),"Luxi Mono 36");

	/* TRANSLATORS: This is used on startmenu to concatenate Version information e.g. Version-0.7.13 */
	gchar* version = g_strdup_printf("%s-%s",gettext("Version"),VERSION);
	clutter_text_set_text(CLUTTER_TEXT(version_label), version);
	g_free(version);
}

void startmenu_quit (TangleButton* tanglebutton, gpointer none){
	cem_add_to_log("startmenu_quit-called",J_LOG_USER_ACTION);
	clutter_main_quit();
}

/*
Whenever any view want return back to startmenu, this function can be used
*/
void startmenu_goto_startmenu (TangleButton* tanglebutton, gpointer none){
	cem_add_to_log("startmenu_goto_startmenu-called",J_LOG_USER_ACTION);
	tangle_view_unload(TANGLE_VIEW(jammo_get_actor_by_id("fullsequencer-view")));

	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	clutter_actor_show(jammo_get_actor_by_id("startmenu-view"));
}

