/*
License: GPLv2, read more from COPYING

This file contains the functionality of help menu.
 */
#include <tangle.h>
#include <string.h>
#include "communitymenu.h"
#include "startmenu.h"
#include "../jammo.h"
#include "mysongs.h"
#include "community_utilities.h"
#include "../../gems/community_server_functions.h"
#include "record_cover_tool.h"
#include "../../configure.h"
#include "../file_helper.h"
#include "sequencer.h" //From mysongs to sequencer

static ClutterContainer *songlist = 0;
ClutterContainer* remove_view = 0;
static gint listItemHeight = 0;
ClutterColor mysongs_text_color = { 255, 255, 255, 255 };
static gboolean removing_song = FALSE;
int linenum = 1;
static gchar* command;
static show_label_params params;

void start_mysongs()
{
	puts("Starting Mysongs\n");
	//#include "../../gems/community_server_functions.h"

	int numberOfLoops = 0;
	GList* l; //Iterator
	GList* projects=NULL;
	GList* finalized=NULL;

	strcpy(params.parentview, "mysongs");

	params.path = g_strdup_printf("%s/label_%d.csv", configure_get_jammo_directory(), gems_profile_manager_get_userid(NULL));
	
	command = g_strdup_printf("ls %s 1> /dev/null 2> /dev/null", params.path);

	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");

	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* mysongs_view = jammo_get_actor_by_id("mysongs-view");

	if(mysongs_view)
	{
		clutter_actor_show(CLUTTER_ACTOR(mysongs_view));
		//Project-files:
		projects = file_helper_get_all_files(configure_get_projects_directory());

		//Audio-files:
		finalized = file_helper_get_all_files(configure_get_finalized_directory());

		numberOfLoops += g_list_length (projects) + g_list_length (finalized);


		if(numberOfLoops > 5)
			songlist = CLUTTER_CONTAINER(jammo_get_actor_by_id("mysongs-songs-list-scrollable"));	

		else
			songlist = CLUTTER_CONTAINER(jammo_get_actor_by_id("mysongs-songs-list-unscrollable"));	

		clutter_actor_lower(CLUTTER_ACTOR(songlist),jammo_get_actor_by_id("mysongs_down-index"));
		for (l = projects ; l; l = l->next)
		{
			mysongs_add_loop_to_list(l->data, 1); //0=project-file
		}

		for (l = finalized; l; l = l->next)
		{
			mysongs_add_loop_to_list(l->data, 1); //1=finalized file
		}

		if(numberOfLoops <= 6)
			clutter_actor_set_height(CLUTTER_ACTOR(songlist), listItemHeight * numberOfLoops);

		else
			clutter_actor_set_height(CLUTTER_ACTOR(songlist), listItemHeight * 6);


		ClutterAction *listAction = tangle_actor_get_action_by_type(CLUTTER_ACTOR(songlist), TANGLE_TYPE_SCROLL_ACTION);

		g_signal_connect_swapped(listAction, "clamp-offset-y", G_CALLBACK(mysongs_autoscroll_to_correct_pos), songlist);


	}

	else 	puts("can't find 'mysongs-view' ");
}


void mysongs_goto_communitymenu(TangleButton *tanglebutton, gpointer none)
{
	clear_container(songlist);

	g_free(params.path);

	if(removing_song){
		clear_container(remove_view);
		removing_song = FALSE;
	}		
	start_communitymenu();
}

void mysongs_goto_startmenu(TangleButton *tanglebutton, gpointer none)
{
	clear_container(songlist);

	g_free(params.path);

	if(removing_song){
		clear_container(remove_view);
		removing_song = FALSE;
	}
	startmenu_goto_startmenu(tanglebutton, none);
}

gboolean mysongs_mentor_clicked (TangleButton *tanglebutton, gpointer data)   {
	printf("mentor clicked\n");

	return TRUE;
}


void mysongs_autoscroll_to_correct_pos(ClutterActor *listToScroll)
{
	gint slot;
	gfloat not_used, offset;

	ClutterAction *action = tangle_actor_get_action_by_type(listToScroll, TANGLE_TYPE_SCROLL_ACTION);
	
	tangle_scroll_action_get_offsets(TANGLE_SCROLL_ACTION(action), &not_used, &offset);

	slot = (gint)offset % (gint)listItemHeight < listItemHeight / 2 ? (gint)(offset) / listItemHeight  
							  		: (gint)(offset) / listItemHeight + 1;

	tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_OUT_QUAD, 300, "offset-y", (gfloat)(slot*listItemHeight), NULL);
}

static void start_sequencer_with_this_file(ClutterActor *actor, gpointer none) {
	const char* filename = clutter_actor_get_name(actor);
	sequencer_start_with_file((char*)filename);
}

/*
 * Filename: contains fullpath
 * Type:
 * 0=work in progress (project)
 * 1=finalized work (no editing anymore)
 * 2=workshop in progress
 * 3=song is sent to jammosongs
 *
 *TODO: filename is just printed.
 */
gboolean mysongs_add_loop_to_list(char* filename, int type)
{
	ClutterActor *colorbar;
	ClutterActor *label = 0;
	ClutterActor *remove_button;
	ClutterActor *text;
	ClutterActor *infoButton;
	ClutterActor *textButton;
	ClutterActor *arrowImage;
	ClutterContainer *listContainer;
	
	

	switch (type){
		case 0:
			colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar1.png",NULL);
			linenum++;
			break;
		case 1:
			colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar4.png",NULL);
			linenum++;
			break;
		case 2:
			colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar5.png",NULL);
			linenum++;
			break;
		case 3:
			colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar7.png",NULL);
			linenum = 1;
			break;
		default:
			colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar12.png",NULL);
			break;
	}

	int i, length, path_length=0, type_length=0;
	int y = 0;
	length = strlen(filename);

	char temp[length];
	char filename_for_textbutton[length];
	strcpy(temp, filename);

	if(type == 0){ //projects
		path_length = strlen(configure_get_projects_directory());
		type_length = 5; //.json
	}else if(type == 1 || type == 3){ //songs
		path_length = strlen(configure_get_finalized_directory());
		type_length = 4; //.ogg
	}
		
	for(i=path_length + 1; i < length-type_length; i++){
		filename_for_textbutton[y] = temp[i];
		y++;
	}
	filename_for_textbutton[y] = '\0';

	if(system(command) == 0){ //labelfile is found
		label = tangle_button_new_with_background_actor(clutter_texture_new_from_file("/opt/jammo/communitymenu/community_cdlabel_small.png", NULL));
		clutter_actor_set_position(label, 500, 15);
		g_signal_connect_swapped(label, "clicked", G_CALLBACK(show_song_label), &params);
	}	
	
	

	remove_button = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
			"/opt/jammo/backingtracks/button_cancel.png", NULL));

	text = clutter_text_new_full("Comic Sans MS 14", filename_for_textbutton, &mysongs_text_color);

	infoButton = NULL;
	textButton = NULL;

	textButton = tangle_button_new_with_background_actor(text);
	clutter_actor_set_name(textButton,filename);

	clutter_text_set_editable (CLUTTER_TEXT(text), FALSE);
	clutter_text_set_max_length (CLUTTER_TEXT(text), 99);
	clutter_text_set_single_line_mode (CLUTTER_TEXT(text), TRUE);

	arrowImage = clutter_texture_new_from_file("/opt/jammo/communitymenu/community_rightarrow.png", NULL);

	listContainer = CLUTTER_CONTAINER(clutter_group_new());

	//Additinally of type, there can be another icon e.g. video missing, new comments
		switch(type){
			case 0:
				infoButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
					"/opt/jammo/communitymenu/community_backtosequencer.png", NULL));
				g_signal_connect (CLUTTER_ACTOR(infoButton), "clicked", G_CALLBACK (start_sequencer_with_this_file), NULL);
				//g_signal_connect (textButton, "clicked", G_CALLBACK (start_sequencer_with_this_file),NULL);
				break;
		
			case 1:
				infoButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
					"/opt/jammo/communitymenu/community_umsic_icon.png", NULL));
				g_signal_connect_swapped(CLUTTER_ACTOR(infoButton), "clicked", G_CALLBACK(mysongs_comment), infoButton);									
				break;
			
		
			case 3:
				infoButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file("/opt/jammo/communitymenu/community_comment_icon.png", NULL));
				g_signal_connect(infoButton, "clicked", G_CALLBACK(mysongs_get_comments), NULL);
								
				break;
		}



	if(colorbar == NULL || infoButton == NULL || arrowImage == NULL)
	{
		printf("Failed to load Colorbar or infoButton\n");
		return FALSE;	
	}

	if(listItemHeight == 0) listItemHeight = clutter_actor_get_height(colorbar);

	clutter_container_add_actor(listContainer, colorbar);	//Add components inside the container

	clutter_actor_set_position(infoButton, 690, 15);
	
	if(label != 0){
		clutter_container_add_actor(listContainer, label);
		clutter_actor_raise(label, colorbar);
		g_signal_connect_swapped(label, "clicked", G_CALLBACK(show_song_label), &params);
	}

	clutter_actor_set_name(remove_button,filename);
	clutter_actor_set_position(remove_button, 420, 15);
	clutter_container_add_actor(listContainer, remove_button);

	clutter_actor_set_position(textButton, 60, 23);			
	clutter_container_add_actor(listContainer, textButton);
	
	clutter_actor_set_position(arrowImage, 653, 15);
	clutter_container_add_actor(listContainer, arrowImage);
	
	clutter_container_add_actor(listContainer, infoButton);
	
	g_signal_connect_swapped(textButton, "button-press-event", G_CALLBACK(song_name_press_action), textButton);
	g_signal_connect_swapped(textButton, "button-release-event", G_CALLBACK(song_name_press_action), textButton);

	g_signal_connect_swapped(CLUTTER_ACTOR(remove_button), "clicked", G_CALLBACK(mysongs_remove_song_view), textButton);
		
	clutter_actor_set_name(infoButton,filename);


	clutter_container_add_actor(songlist, CLUTTER_ACTOR(listContainer));

	return TRUE;
}

void mysongs_get_comments(ClutterActor* song){


}


void mysongs_comment(ClutterActor *actor)
{
	/*GList *children = clutter_container_get_children(songlist); //Get list of actors
	GList *node = children;

	int index = 0;
	int found = 0;
	
	while(node != NULL)
	{
		index++;

		if(actor == node->data)
		{*/
			//TO-DO: Send song to JamMo Songs
			const gchar * filename = clutter_actor_get_name(actor);
			//printf("Found it. Index %d\n", index);
			printf("Song is: %s\n", filename);
			printf("Sending song to JamMo Songs...\n");

			//sendJammoFile(filename);

		/*	found = 1;
			break;
		}

		node = node->next;
	}

	g_list_free(children);*/
}


void mysongs_delete_song(ClutterActor *actor)
{
	const gchar * filename = clutter_actor_get_name(actor);
	printf("Removing %s...\n", filename);
	
	if(remove(filename) != 0)
    		printf("Error deleting file\n");
  	else
    		printf("File successfully deleted\n");

	clear_container(songlist);
	clear_container(remove_view);
	removing_song = FALSE;
	mysongs_refresh_list();
}


void mysongs_cancel_song_delete(ClutterActor *actor)
{
	removing_song = FALSE;
	clear_container(remove_view);
}


void mysongs_remove_song_view(ClutterActor *actor){

	if(removing_song) return;

	removing_song = TRUE;
	remove_view = CLUTTER_CONTAINER(jammo_get_actor_by_id("mysongs-container"));
	ClutterContainer *listContainer = CLUTTER_CONTAINER(clutter_group_new());

	ClutterActor *text = CLUTTER_ACTOR(clutter_text_new_full("Comic Sans MS 22", "Remove?", &mysongs_text_color));
	clutter_actor_set_position(text, 30, 60);
	clutter_container_add_actor(listContainer, text);
	
	ClutterActor *ok_button = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
		"/opt/jammo/backingtracks/button_ok.png", NULL));

	ClutterActor *cancel_button = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
		"/opt/jammo/backingtracks/button_cancel.png", NULL));

	clutter_actor_set_position(ok_button, 170, 40);
	clutter_container_add_actor(listContainer, ok_button);

	clutter_actor_set_position(cancel_button, 260, 60);
	clutter_container_add_actor(listContainer, cancel_button);

	g_signal_connect_swapped(CLUTTER_ACTOR(ok_button), "clicked", G_CALLBACK(mysongs_delete_song), actor);
	g_signal_connect_swapped(CLUTTER_ACTOR(cancel_button), "clicked", G_CALLBACK(mysongs_cancel_song_delete), remove_view);

	clutter_container_add_actor(remove_view, CLUTTER_ACTOR(listContainer));
}


void mysongs_refresh_list()
{
	int numberOfLoops = 0;
	GList* l; //Iterator
	GList* projects=NULL;
	GList* finalized=NULL;

	puts("Refreshing list...");

	projects = file_helper_get_all_files(configure_get_projects_directory());
	finalized = file_helper_get_all_files(configure_get_finalized_directory());

	numberOfLoops += g_list_length (projects) + g_list_length (finalized);

	if(numberOfLoops > 5)
		songlist = CLUTTER_CONTAINER(jammo_get_actor_by_id("mysongs-songs-list-scrollable"));	
	else
		songlist = CLUTTER_CONTAINER(jammo_get_actor_by_id("mysongs-songs-list-unscrollable"));	

	clutter_actor_lower(CLUTTER_ACTOR(songlist),jammo_get_actor_by_id("mysongs_down-index"));
	for (l = projects ; l; l = l->next){
		mysongs_add_loop_to_list(l->data, 0); //0=project-file
	}

	for (l = finalized; l; l = l->next){
		mysongs_add_loop_to_list(l->data, 1); //1=finalized file
	}

	if(numberOfLoops <= 6)
		clutter_actor_set_height(CLUTTER_ACTOR(songlist), listItemHeight * numberOfLoops);
	else
		clutter_actor_set_height(CLUTTER_ACTOR(songlist), listItemHeight * 6);

	ClutterAction *listAction = tangle_actor_get_action_by_type(CLUTTER_ACTOR(songlist), TANGLE_TYPE_SCROLL_ACTION);
	g_signal_connect_swapped(listAction, "clamp-offset-y", G_CALLBACK(mysongs_autoscroll_to_correct_pos), songlist);	
}
