/*
 * gems_utils.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2011 University of Oulu, Lappeenranta University of Technology
 *
 * Authors: Jussi Laakkonen <jussi.laakkonen@lut.fi>
 */
 
#include <string.h>
#include <stdio.h>
#include "gems_utils.h"
#include "gems_definitions.h"
#include "../configure.h"


gboolean gems_all_integers(gchar* c)
{
	for(gint i = 0; i < strlen(c); i++) if(!g_ascii_isdigit(c[i])) return FALSE;
	return TRUE;
}

void gems_erase_newline(gchar* c)
{
	// Search for '\n'
	gchar* pos = g_strrstr(c,"\n");
	// Set '\n' -> '\0'
	if(pos) pos[0] = '\0'; 
}

gboolean gems_check_illegal_characters(gchar* data)
{
	// Illegal characters
	gchar illegal[ILLEGAL_CHAR_COUNT] = ILLEGAL_CHARS;
	
	for(gint i = 0; i < ILLEGAL_CHAR_COUNT; i++)
	{
		for(gint j = 0; j < strlen(data); j++)
		{
			// found
			if(data[j] == illegal[i]) return TRUE;
		}
	}
	// Not found
	return FALSE;
}

gchar** gems_list_saved_profiles(guint* count)
{
	gchar** list = (gchar**)g_malloc0(sizeof(gchar*)*sizeof(gchar*));
	guint listcount = 0;
	
	// Profile path
	gchar* path = g_build_filename(configure_get_jammo_directory(),JAMMOPROFILE,NULL);
	
	// Get extension, ignore first '.'
	gchar* profile_ext = g_strdup(&PROFILE_FILE_EXT[1]);
	
	GError** error = NULL;
	GDir* dir = NULL;
	
	// Try to open dir
	if((dir = g_dir_open(path,0,error)))
	{
		const gchar* file = NULL;
		
		for(file = g_dir_read_name(dir); file ; file = g_dir_read_name(dir))
		{
			gchar* full = g_build_filename(path,file,NULL);
			
			// Check that file is regular
			if(g_file_test(full,G_FILE_TEST_IS_REGULAR))
			{
				// Split the file into two
				gchar** splitted = g_strsplit(file,".",2);
				
				if(g_strcmp0(splitted[1],profile_ext) == 0)
				{
					// Add to list
					list[listcount] = g_strdup(splitted[0]);
					listcount++;
				}
				g_strfreev(splitted);
			}
			g_free(full);
		}
		g_dir_close(dir);
	}
	// Error, clear it and free allocated list, return NULL
	else
	{
		g_clear_error(error);
		g_free(profile_ext);
		g_free(path);
		g_strfreev(list);
		return NULL;
	}
	
	g_free(profile_ext);
	g_free(path);
	*count = listcount;
	return list;
}
