#include "profile_viewer.h"
#include "community_utilities.h"
#include "jammosongs.h"
#include <string.h>
#include "avatar_editor.h"

profile_view_params *params;
static Avatar avatar = {0,0,0,0};
static ClutterContainer* avatarBackground = 0;
static ClutterActor* instrumentBackground = 0;

void start_profile_view(profile_view_params *pvp){

	params = pvp;
	gchar *age;
	guint32 avatar_id = 0;	
	gems_peer_profile *profile = gems_profile_get_profile_of_user(params->user_id);

	printf("Starting profileviewer\n");
	
	if(strcmp(params->parent_view, "jammosongs") == 0)
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("jammosongs-view")));
		
	if(strcmp(params->parent_view, "single-thread") == 0)
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("single-thread-view")));

	if(strcmp(params->parent_view, "helpdesk") == 0)
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("helpdesk-view")));			
	
	if(strcmp(params->parent_view, "discuss") == 0)
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("threads-view")));		
	
	ClutterActor* profile_view = jammo_get_actor_by_id("profile-view");
				

	if(profile_view){
		clutter_actor_show(CLUTTER_ACTOR(profile_view));
		
		avatar_id = gems_profile_manager_get_avatar_id(profile);
			if (avatar_id == 0)
				avatar_id = 260; //default avatar	
			
		community_get_avatar(&avatar, avatar_id);				
		set_avatar(&avatar, CLUTTER_ACTOR(avatarBackground), instrumentBackground, "user-profile-widgets");
		
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_name_text")), _("NAME: "));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_gender_text")), _("GENDER: "));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_age_text")), _("AGE: "));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_hobbies_text")), _("HOBBIES: "));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_instrument_text")), _("FAVOURITE INSTRUMENT: "));
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_name_textfield")), gems_profile_manager_get_username(profile));
		
		age = g_strdup_printf("%d", gems_profile_manager_get_age(profile));
		
		clutter_text_set_text(CLUTTER_TEXT(jammo_get_actor_by_id("profile_age_textfield")), age);
		
		g_free(age);
	}else
		puts("can't find 'profile-view' ");
	

}


void end_profile_view(){

	DESTROY_ACTOR(avatar.body);
	DESTROY_ACTOR(avatar.hair);
	DESTROY_ACTOR(avatar.head);
	DESTROY_ACTOR(avatar.instrument);
	clear_container(avatarBackground);
	DESTROY_ACTOR(instrumentBackground);

	if(strcmp(params->parent_view, "single-thread") == 0){
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("profile-view")));
		clutter_actor_show(jammo_get_actor_by_id("single-thread-view"));
	}
	if(strcmp(params->parent_view, "jammosongs") == 0){
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("profile-view")));
		clutter_actor_show(jammo_get_actor_by_id("jammosongs-view"));
	}	
	if(strcmp(params->parent_view, "helpdesk") == 0){
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("profile-view")));
		clutter_actor_show(jammo_get_actor_by_id("helpdesk-view"));
	}
	if(strcmp(params->parent_view, "discuss") == 0){
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("profile-view")));
		clutter_actor_show(jammo_get_actor_by_id("threads-view"));
	}		
}
